/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.chartglyph.Cylinder;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Pie;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.Pie3D;
import com.fr.chart.chartglyph.PiePlotGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Pie3DPlotGlyph
extends PiePlotGlyph {
    private static final long serialVersionUID = -8454922131125531977L;
    private static final double THICKNESS = 5.0;
    private static final double ROUND = 360.0;
    private int depth = 20;
    private Projection projection = new Projection();
    private Pie3D pie3d = new Pie3D();

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void setDepth(int n2) {
        this.depth = n2;
    }

    public boolean equals(Object object) {
        return object instanceof Pie3DPlotGlyph && super.equals(object) && ((Pie3DPlotGlyph)object).depth == this.depth && ComparatorUtils.equals(((Pie3DPlotGlyph)object).projection, this.projection);
    }

    public void draw(Graphics graphics, int n2) {
        this.drawInfo(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.pie3d.drawWithoutSide(graphics2D, n2);
        int n3 = this.getSeriesSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.getSeries(i2).drawLabel(graphics, n2);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public String getPlotGlyphType() {
        return "Pie3DPlotGlyph";
    }

    public Object clone() throws CloneNotSupportedException {
        Pie3DPlotGlyph pie3DPlotGlyph = (Pie3DPlotGlyph)super.clone();
        if (this.projection != null) {
            pie3DPlotGlyph.projection = (Projection)this.projection.clone();
        }
        return pie3DPlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("depth", this.depth);
        jSONObject.put("projection", this.projection.toJSONObject());
        return jSONObject;
    }

    public void layoutDataSeriesGlyph(int n2) {
        this.pie3d.clearCylinder();
        double d2 = this.getBounds().getWidth() / (double)this.getCategoryCount();
        for (int i2 = 0; i2 < this.getCategoryCount(); ++i2) {
            this.initLabelData(i2, n2);
            GeneralPath generalPath = new GeneralPath();
            this.pie3d.setProjection(this.projection);
            for (int i3 = 0; i3 < this.getSeriesSize(); ++i3) {
                DataSeries dataSeries = this.getSeries(i3);
                DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(i2);
                if (dataPoint4Pie.isValueIsNull()) continue;
                Pie3D pie3D = new Pie3D();
                pie3D.setProjection(this.projection);
                double d3 = this.getSeriesStartAngle(i2, i3);
                double d4 = (double)i2 * d2 + d2 / 2.0;
                Point2D.Double double_ = new Point2D.Double(d4, this.getBounds().getHeight() / 2.0);
                double d5 = this.radius / 5.0;
                Cylinder cylinder = new Cylinder(0.0, d5, this.radius);
                cylinder.setX(((Point2D)double_).getX());
                cylinder.setY(((Point2D)double_).getY());
                cylinder.setStart(d3);
                cylinder.setExtent(this.getPercent(i3, i2) * 360.0);
                cylinder.setProjection(this.projection);
                this.getConditionCollection().changeStyleConditionWithInfo(cylinder.getColorInfo(), dataPoint4Pie, this.createColors4Series());
                pie3D.addCylinder(cylinder);
                this.pie3d.addCylinder(cylinder);
                dataPoint4Pie.setDrawImpl(pie3D);
                this.dealLabelBounds(dataPoint4Pie, n2, generalPath);
            }
        }
        this.dealLabelBoundsInOrder();
        this.dealLeadLineSeries();
    }

    public void dealLeadLineSeries() {
        for (int i2 = 0; i2 < this.getCategoryCount(); ++i2) {
            for (int i3 = 0; i3 < this.getSeriesSize(); ++i3) {
                DataSeries dataSeries = this.getSeries(i3);
                DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(i2);
                if (dataPoint4Pie.isValueIsNull()) continue;
                Pie3D pie3D = (Pie3D)dataPoint4Pie.getDrawImpl();
                Cylinder cylinder = pie3D.getCylinder(0);
                double d2 = this.getHalfAngle(this.getSeriesStartAngle(i2, i3), i3, i2);
                this.dealLeadLine(cylinder.top(), dataPoint4Pie, d2 % 360.0);
            }
        }
    }

    protected void dealInsideLabelBounds(DataPoint dataPoint, int n2) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        Point2D point2D = this.getTopArcCenterPoint(dataPoint);
        if (point2D != null) {
            double d2 = this.getLabelDim(dataPoint, n2).getHeight();
            double d3 = this.getLabelDim(dataPoint, n2).getWidth();
            double d4 = point2D.getX() - d3 / 2.0;
            double d5 = point2D.getY() - d2 / 2.0;
            textGlyph.setBounds(new Rectangle2D.Double(d4, d5, d3, d2));
        } else {
            textGlyph.setBounds(null);
        }
    }

    private Point2D getTopArcCenterPoint(DataPoint dataPoint) {
        if (dataPoint.getDrawImpl() != null) {
            Pie3D pie3D = (Pie3D)dataPoint.getDrawImpl();
            return pie3D.topCenterPoint(new Point2D.Double(this.getBounds().getWidth() / 2.0, this.getBounds().getHeight() / 2.0));
        }
        return null;
    }

    protected boolean isNotNeedMoveChangeLabelRadius(Shape shape, Rectangle2D rectangle2D) {
        return true;
    }

    public void drawShape4Series(Graphics graphics, int n2) {
        this.pie3d.drawWithoutSide(graphics, n2);
    }

    protected double getPercent(int n2, int n3) {
        double d2 = this.getTotalValue(n3);
        if (d2 <= 0.0) {
            return 0.0;
        }
        DataSeries dataSeries = this.getSeries(n2);
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n3);
        return Math.abs(dataPoint4Pie.getValue()) / d2;
    }
}

