/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.base.background.AreaColor;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.MapHotAreaColor;
import com.fr.chart.chartglyph.MeterCustomStyle;
import com.fr.chart.chartglyph.MeterInterval;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;

public class MeterStyle
implements XMLable {
    private static final long serialVersionUID = -7636054199242127287L;
    public static final int AUTO = 0;
    public static final int CUSTOM = 1;
    public static final String XML_TAG = "MeterStyle";
    public static final float DEFAULT_BORDER_SIZE = 3.0f;
    public static final float DEFAULT_CIRCLE_SIZE = 10.0f;
    public static final int PIE270 = 270;
    public static final int CUSTOMSHAPE = 1;
    public static final int CIRCLE = 360;
    public static final int PIE = 180;
    public static final double START = 0.0;
    public static final double END = 450.0;
    public static final double SIZE = 50.0;
    private int dialShape = 180;
    private int maxArrowAngle = 180;
    private int meterAngle = 180;
    private int designType = 0;
    private Formula startValue = new Formula("0.0");
    private Formula endValue = new Formula("450.0");
    private Formula tickSize = new Formula("50.0");
    private String units = Inter.getLocText("Yuan");
    private Format unitFormat;
    private boolean tickLabelsVisible = true;
    private TextAttr titleTextAttr = new TextAttr();
    private List intervals;
    private int order = 0;
    private MapHotAreaColor hotAreaColor = null;

    public MeterStyle() {
        this.setIntervals(new ArrayList());
    }

    public int getDesignType() {
        return this.designType;
    }

    public void setDesignTyle(int n2) {
        this.designType = n2;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n2) {
        this.order = n2;
    }

    public MapHotAreaColor getMapHotAreaColor() {
        return this.hotAreaColor;
    }

    public void setMapHotAreaColor(MapHotAreaColor mapHotAreaColor) {
        this.hotAreaColor = mapHotAreaColor;
    }

    public int getDialShape() {
        return this.dialShape;
    }

    public void setDialShape(int n2) {
        this.dialShape = n2;
    }

    public int getMeterAngle() {
        return this.meterAngle;
    }

    public void setMeterAngle(int n2) {
        this.meterAngle = n2;
    }

    public void setMaxArrowAngle(int n2) {
        this.maxArrowAngle = n2;
    }

    public int getMaxArrowAngle() {
        return this.maxArrowAngle;
    }

    public Formula getStartValue() {
        return this.startValue;
    }

    public double getStartValueResult() {
        double d2 = 0.0;
        Number number = ChartBaseUtils.formula2Number(this.startValue);
        if (number != null) {
            d2 = number.doubleValue();
        }
        return d2;
    }

    public void setStartValue(Formula formula) {
        this.startValue = formula;
    }

    public double getEndValueFormula() {
        double d2 = 450.0;
        Number number = ChartBaseUtils.formula2Number(this.getEndValue());
        if (number != null) {
            d2 = number.doubleValue();
        }
        return d2;
    }

    public Formula getEndValue() {
        return this.endValue;
    }

    public void setEndValue(Formula formula) {
        this.endValue = formula;
    }

    public Formula getTickSize() {
        return this.tickSize;
    }

    public Color getBackgroundColor() {
        return MeterCustomStyle.BackColor;
    }

    public Color getBorderColor() {
        return MeterCustomStyle.BC;
    }

    public Color getArrowColor() {
        return MeterCustomStyle.ArrowC;
    }

    public Color getTickColor() {
        return MeterCustomStyle.TickC;
    }

    public double getTickSizeFormula() {
        double d2 = 50.0;
        Number number = ChartBaseUtils.formula2Number(this.getTickSize());
        if (number != null) {
            d2 = number.doubleValue();
        }
        return d2;
    }

    public void setTickSize(Formula formula) {
        this.tickSize = formula;
    }

    public boolean isCustomMeter() {
        return false;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String string) {
        this.units = string;
    }

    public void setUnitFormat(Format format) {
        this.unitFormat = format;
    }

    public Format getUnitFormat() {
        return this.unitFormat;
    }

    public void setTickLabelsVisible(boolean bl) {
        this.tickLabelsVisible = bl;
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTitleTextAttr(TextAttr textAttr) {
        this.titleTextAttr = textAttr;
    }

    public TextAttr getTitleTextAttr() {
        return this.titleTextAttr;
    }

    public void addInterval(MeterInterval meterInterval) {
        this.intervals.add(meterInterval);
    }

    public int getIntervalCount() {
        return this.intervals != null ? this.intervals.size() : 0;
    }

    public MeterInterval getInterval(int n2) {
        if (n2 < 0 || n2 >= this.getIntervalCount()) {
            return null;
        }
        return (MeterInterval)this.intervals.get(n2);
    }

    public void clearAllInterval() {
        if (this.intervals == null) {
            return;
        }
        this.intervals.clear();
    }

    public void convertAreaColor2List(double d2) {
        if (this.getDesignType() == 0) {
            if (d2 < 0.0) {
                double d3;
                double d4 = d3 = d2 * 3.0;
                double d5 = 0.0;
                this.startValue.setResult(new Double(d3));
                this.endValue.setResult(new Double(0.0));
                MeterInterval meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field"), new Formula("" + d4), new Formula("" + d4 * 2.0 / 3.0));
                meterInterval.setBackgroundColor(new Color(231, 71, 62));
                this.addInterval(meterInterval);
                meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field"), new Formula("" + d4 * 2.0 / 3.0), new Formula("" + d4 / 3.0));
                meterInterval.setBackgroundColor(new Color(252, 210, 9));
                this.addInterval(meterInterval);
                meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field"), new Formula("" + d4 / 3.0), new Formula("" + d5));
                meterInterval.setBackgroundColor(new Color(77, 184, 73));
                this.addInterval(meterInterval);
                this.hotAreaColor = new MapHotAreaColor();
            } else {
                double d6 = d2 * 3.0 / 2.0;
                double d7 = 0.0;
                double d8 = d6;
                this.startValue.setResult(new Double(d7));
                this.endValue.setResult(new Double(d6));
                MeterInterval meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field"), new Formula("" + d7), new Formula("" + d8 / 3.0));
                meterInterval.setBackgroundColor(new Color(231, 71, 62));
                this.addInterval(meterInterval);
                meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field"), new Formula("" + d8 / 3.0), new Formula("" + 2.0 * d8 / 3.0));
                meterInterval.setBackgroundColor(new Color(252, 210, 9));
                this.addInterval(meterInterval);
                meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field"), new Formula("" + 2.0 * d8 / 3.0), new Formula("" + d8));
                meterInterval.setBackgroundColor(new Color(77, 184, 73));
                this.addInterval(meterInterval);
                this.hotAreaColor = new MapHotAreaColor();
            }
        } else {
            int n2 = this.hotAreaColor.getAreaNumber();
            List list = this.hotAreaColor.getAreaColorList();
            AreaColor areaColor = (AreaColor)list.get(0);
            this.endValue.setResult(new Double(areaColor.getMin()));
            areaColor = (AreaColor)list.get(n2 - 1);
            this.startValue.setResult(new Double(areaColor.getMax()));
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                AreaColor areaColor2 = (AreaColor)list.get(i2);
                MeterInterval meterInterval = new MeterInterval();
                meterInterval.setBeginValue(new Formula(new Double(areaColor2.getMax()).toString()));
                meterInterval.setEndValue(new Formula(new Double(areaColor2.getMin()).toString()));
                meterInterval.setBackgroundColor(areaColor2.getAreaColor());
                this.addInterval(meterInterval);
            }
        }
    }

    public void convertList2AreaColor() {
        if (this.designType == 1 && this.hotAreaColor != null) {
            this.hotAreaColor.setUseType(1);
            int n2 = this.intervals.size();
            this.hotAreaColor.setAreaNumber(n2);
            this.hotAreaColor.clearColor();
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                MeterInterval meterInterval = (MeterInterval)this.intervals.get(i2);
                AreaColor areaColor = new AreaColor(meterInterval.getEndValueResult(), meterInterval.getStartValueResult(), meterInterval.getBackgroundColor());
                this.hotAreaColor.addAreaColor(areaColor);
            }
        }
    }

    public void setIntervals(List list) {
        this.intervals = list;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        this.writerAttr(xMLPrintWriter);
        if (this.hotAreaColor != null) {
            this.hotAreaColor.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    protected void writerAttr(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attr").attr("meterAngle", this.meterAngle).attr("maxArrowAngle", this.maxArrowAngle).attr("units", this.getUnits()).attr("order", this.order).attr("designType", this.designType).attr("tickLabelsVisible", this.tickLabelsVisible).attr("dialShape", this.dialShape);
        if (this.startValue != null) {
            xMLPrintWriter.attr("startValue", this.startValue.toString());
        }
        if (this.getEndValue() != null) {
            xMLPrintWriter.attr("endValue", this.getEndValue().toString());
        }
        if (this.getTickSize() != null) {
            xMLPrintWriter.attr("tickSize", this.getTickSize().toString());
        }
        xMLPrintWriter.end();
        if (this.titleTextAttr != null) {
            this.titleTextAttr.writeXML(xMLPrintWriter);
        }
        if (this.intervals != null && this.intervals.size() > 0) {
            xMLPrintWriter.startTAG("IntervalList");
            int n2 = this.intervals.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                MeterInterval meterInterval = (MeterInterval)this.intervals.get(i2);
                meterInterval.writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attr".equals(string)) {
                this.setOrder(xMLableReader.getAttrAsInt("order", 0));
                this.setDesignTyle(xMLableReader.getAttrAsInt("designType", 0));
                this.setMeterAngle(xMLableReader.getAttrAsInt("meterAngle", 180));
                this.setMaxArrowAngle(xMLableReader.getAttrAsInt("maxArrowAngle", 180));
                this.setStartValue(new Formula(xMLableReader.getAttrAsString("startValue", "0")));
                this.setEndValue(new Formula(xMLableReader.getAttrAsString("endValue", "400")));
                this.setTickSize(new Formula(xMLableReader.getAttrAsString("tickSize", "50")));
                String string2 = xMLableReader.getAttrAsString("units", null);
                if (string2 != null) {
                    this.setUnits(string2);
                }
                this.setTickLabelsVisible(xMLableReader.getAttrAsBoolean("tickLabelsVisible", true));
                string2 = xMLableReader.getAttrAsString("dialShape", null);
                if (string2 != null) {
                    this.dialShape = this.chartXMLType(string2);
                    if (this.dialShape == 180 && this.meterAngle != 180) {
                        this.dialShape = 1;
                    }
                    if (this.dialShape == 360 && this.meterAngle != 360) {
                        this.dialShape = 1;
                        this.meterAngle = 360;
                    }
                }
            } else if ("TextAttr".equals(string)) {
                this.titleTextAttr = (TextAttr)xMLableReader.readXMLObject(new TextAttr());
            } else if ("IntervalList".equals(string)) {
                this.readInterval(xMLableReader);
            } else if (ComparatorUtils.equals(string, "MapHotAreaColor")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        MeterStyle.this.hotAreaColor = (MapHotAreaColor)xMLableReader.readXMLObject(new MapHotAreaColor());
                    }
                });
            }
        }
    }

    private void readInterval(XMLableReader xMLableReader) {
        this.intervals.clear();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && "MeterInterval".equals(xMLableReader.getTagName())) {
                    MeterStyle.this.intervals.add(xMLableReader.readXMLObject(new MeterInterval()));
                }
            }
        });
    }

    private int chartXMLType(String string) {
        int n2 = 180;
        if ("PIE270".equals(string)) {
            n2 = 270;
        } else if ("CustomShape".equals(string)) {
            n2 = 1;
        } else if ("CIRCLE".equals(string)) {
            n2 = 360;
        } else if ("PIE".equals(string)) {
            n2 = 180;
        }
        return n2;
    }

    public Object clone() throws CloneNotSupportedException {
        MeterStyle meterStyle = (MeterStyle)super.clone();
        if (this.startValue != null) {
            meterStyle.startValue = (Formula)this.startValue.clone();
        }
        if (this.endValue != null) {
            meterStyle.endValue = (Formula)this.endValue.clone();
        }
        if (this.tickSize != null) {
            meterStyle.tickSize = (Formula)this.tickSize.clone();
        }
        if (this.titleTextAttr != null) {
            meterStyle.titleTextAttr = (TextAttr)this.titleTextAttr.clone();
        }
        if (this.unitFormat != null) {
            meterStyle.unitFormat = (Format)this.unitFormat.clone();
        }
        if (this.intervals != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i2 = 0; i2 < this.getIntervalCount(); ++i2) {
                arrayList.add(this.getInterval(i2).clone());
            }
            meterStyle.setIntervals(arrayList);
        }
        if (this.hotAreaColor != null) {
            meterStyle.hotAreaColor = (MapHotAreaColor)this.hotAreaColor.clone();
        }
        return meterStyle;
    }

    public boolean equals(Object object) {
        return object instanceof MeterStyle && ComparatorUtils.equals(object.getClass().getName(), this.getClass().getName()) && ComparatorUtils.equals(((MeterStyle)object).endValue, this.endValue) && ComparatorUtils.equals(((MeterStyle)object).tickSize, this.tickSize) && ((MeterStyle)object).dialShape == this.dialShape && ((MeterStyle)object).maxArrowAngle == this.maxArrowAngle && ((MeterStyle)object).meterAngle == this.meterAngle && ComparatorUtils.equals(((MeterStyle)object).units, this.units) && ComparatorUtils.equals(((MeterStyle)object).unitFormat, this.unitFormat) && ComparatorUtils.equals(((MeterStyle)object).intervals, this.intervals) && ComparatorUtils.equals(((MeterStyle)object).titleTextAttr, this.titleTextAttr) && ((MeterStyle)object).tickLabelsVisible == this.tickLabelsVisible && ComparatorUtils.equals(((MeterStyle)object).startValue, this.startValue) && ((MeterStyle)object).order == this.order && ((MeterStyle)object).designType == this.designType && ComparatorUtils.equals(((MeterStyle)object).hotAreaColor, this.hotAreaColor);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("startValue", ChartBaseUtils.formula2Number(this.startValue));
        jSONObject.put("endValue", ChartBaseUtils.formula2Number(this.endValue));
        jSONObject.put("tickSize", ChartBaseUtils.formula2Number(this.tickSize));
        jSONObject.put("meterAngle", this.meterAngle);
        jSONObject.put("maxArrowAngle", this.maxArrowAngle);
        jSONObject.put("dialShape", this.dialShape);
        jSONObject.put("tickLabelsVisible", this.tickLabelsVisible);
        jSONObject.put("units", this.units);
        jSONObject.put("order", this.order);
        jSONObject.put("designType", this.getDesignType());
        if (this.unitFormat != null) {
            jSONObject.put("unitFormat", ChartBaseUtils.format2JS(this.unitFormat));
        }
        jSONObject.put("titleTextAttr", this.titleTextAttr.toJSONObject());
        if (this.hotAreaColor == null) {
            this.doCompa();
        }
        if (this.intervals != null && this.intervals.size() > 0) {
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
            for (int i2 = 0; i2 < this.intervals.size(); ++i2) {
                arrayList.add(this.getInterval(i2).toJSONObject());
            }
            jSONObject.put("intervals", arrayList.toArray());
        }
        return jSONObject;
    }

    private void doCompa() {
        this.clearAllInterval();
        for (int i2 = 0; i2 < 3; ++i2) {
            MeterInterval meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field"), new Formula("0"), new Formula("0"));
            this.addInterval(meterInterval);
        }
    }

    public void dealFormula(Calculator calculator) {
        if (this.startValue != null) {
            Utils.dealFormulaValue(this.startValue, calculator);
        }
        if (this.endValue != null) {
            Utils.dealFormulaValue(this.endValue, calculator);
        }
        if (this.tickSize != null) {
            Utils.dealFormulaValue(this.tickSize, calculator);
        }
        int n2 = this.getIntervalCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MeterInterval meterInterval = this.getInterval(i2);
            meterInterval.dealFormula(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        if (this.startValue != null) {
            GeneralUtils.dealBuidExecuteSequence(this.startValue, list, calculator);
        }
        if (this.endValue != null) {
            GeneralUtils.dealBuidExecuteSequence(this.endValue, list, calculator);
        }
        if (this.tickSize != null) {
            GeneralUtils.dealBuidExecuteSequence(this.tickSize, list, calculator);
        }
        int n2 = this.getIntervalCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MeterInterval meterInterval = this.getInterval(i2);
            meterInterval.buidExecuteSequenceList(list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (this.startValue != null) {
            this.startValue.modColumnRow(mOD_COLUMN_ROW);
        }
        if (this.endValue != null) {
            this.endValue.modColumnRow(mOD_COLUMN_ROW);
        }
        if (this.tickSize != null) {
            this.tickSize.modColumnRow(mOD_COLUMN_ROW);
        }
        int n2 = this.getIntervalCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MeterInterval meterInterval = this.getInterval(i2);
            meterInterval.modFormulaString(mOD_COLUMN_ROW);
        }
    }

    public String getMeterStyleType() {
        return XML_TAG;
    }
}

