/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.chartglyph.MeterStyle;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class MeterCustomStyle
extends MeterStyle {
    private static final long serialVersionUID = -2998673876776080292L;
    public static final String XML_TAG = "MeterCustomStyle";
    public static final Color BC = new Color(3, 129, 204);
    public static final Color BackColor = Color.blue;
    public static final Color ArrowC = Color.white;
    public static final Color TickC = new Color(85, 85, 85);
    private Color tickColor = new Color(85, 85, 85);
    private Color borderColor = new Color(66, 111, 179);
    private Color backgroundColor = new Color(255, 255, 255);
    private Color arrowColor = new Color(128, 128, 128);

    public boolean isCustomMeter() {
        return true;
    }

    public void setTickColor(Color color) {
        this.tickColor = color;
    }

    public Color getTickColor() {
        return this.tickColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setArrowColor(Color color) {
        this.arrowColor = color;
    }

    public Color getArrowColor() {
        return this.arrowColor;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        this.writerAttr(xMLPrintWriter);
        xMLPrintWriter.startTAG("MeterCustomAttr");
        if (this.arrowColor != null) {
            xMLPrintWriter.attr("arrowColor", this.arrowColor.getRGB());
        }
        if (this.tickColor != null) {
            xMLPrintWriter.attr("tickColor", this.tickColor.getRGB());
        }
        if (this.backgroundColor != null) {
            xMLPrintWriter.attr("backgroundColor", this.backgroundColor.getRGB());
        }
        if (this.borderColor != null) {
            xMLPrintWriter.attr("borderColor", this.borderColor.getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "MeterCustomAttr".equals(string = xMLableReader.getTagName())) {
            this.setArrowColor(xMLableReader.getAttrAsColor("arrowColor", Color.white));
            this.setTickColor(xMLableReader.getAttrAsColor("tickColor", new Color(105, 105, 105)));
            this.setBackgroundColor(xMLableReader.getAttrAsColor("backgroundColor", Color.blue));
            this.setBorderColor(xMLableReader.getAttrAsColor("borderColor", new Color(3, 129, 204)));
        }
    }

    public boolean equals(Object object) {
        return object instanceof MeterCustomStyle && ComparatorUtils.equals(((MeterCustomStyle)object).arrowColor, this.arrowColor) && ComparatorUtils.equals(((MeterCustomStyle)object).tickColor, this.tickColor) && ComparatorUtils.equals(((MeterCustomStyle)object).backgroundColor, this.backgroundColor) && ComparatorUtils.equals(((MeterCustomStyle)object).borderColor, this.borderColor) && super.equals(object);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("borderColor", StableUtils.javaColorToCSSColor(this.borderColor));
        jSONObject.put("backgroundColor", StableUtils.javaColorToCSSColor(this.backgroundColor));
        jSONObject.put("arrowColor", StableUtils.javaColorToCSSColor(this.arrowColor));
        jSONObject.put("tickColor", StableUtils.javaColorToCSSColor(this.tickColor));
        return jSONObject;
    }

    public String getMeterStyleType() {
        return XML_TAG;
    }
}

