/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.DoubleDimension2D;
import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.chartglyph.MeterInterval;
import com.fr.chart.chartglyph.MeterStyle;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.stable.CoreConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.apache.batik.ext.awt.LinearGradientPaint;

public class Meter
extends SpecialGlyph {
    private static final long serialVersionUID = 3950923513149375891L;
    private static final double BASIC_ANGLE = 90.0;
    private static final int CIR = 360;
    private static final int PIE = 180;
    private static final int CHORD = 270;
    private static final int DEFAULT_HEIGHT = 250;
    private static final int DEFALULT_WIDTH = 470;
    private static final int INTERVAL = 9;
    private static final double POINTEREND = 0.8275;
    private static final double METER_WIDTH_OFF = 8.0;
    private static final int HUNDRED = 100;
    private static final int TEN = 10;
    private static final double BASE = 0.09;
    private static final double GAPBASE = 0.07;
    private static final double POINTER = 0.35;
    private static final int MAXCURSIZE = 20;
    private static final int MINCURSIZE = 8;
    private static final double METER_ANOTHER_ANGLE = 190.0;
    private static final double OFFANGLE = 5.0;
    private int labelGap = 8;
    private int currentGap = 16;
    private double innerRadius = 0.14;
    private double value;
    private TextGlyph titleGlyph;
    private MeterStyle meterStyle;
    private Rectangle2D bounds;
    private transient double meterMiddleX;
    private transient double meterMiddleY;
    private Dimension2D maxLabelDim;
    private transient double radius;
    private transient double startAngle;
    private transient double extentAngle;
    private transient int joinType;
    private transient double maxOuterSize = 0.0;
    private transient double arcWidth = 0.0;
    private transient Dimension2D titleDim = new DoubleDimension2D(0.0, 0.0);
    private Arc2D meterShape;

    public Meter() {
    }

    public Meter(TextGlyph textGlyph, double d2, MeterStyle meterStyle) {
        this.setTitle(textGlyph);
        this.setValue(d2);
        this.meterStyle = meterStyle;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void draw(Graphics graphics, int n2) {
        this.resetBeforeDraw();
        this.initTransientValue(n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.bounds.getX(), this.bounds.getY());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n3 = this.meterStyle.getIntervalCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.drawArcForInterval(graphics2D, this.meterStyle.getInterval(i2), i2);
        }
        this.drawTicks(graphics2D, n2);
        this.drawDisplay(graphics2D);
        this.drawArrow(graphics2D);
        if (this.titleGlyph != null) {
            this.titleGlyph.setBounds(new Rectangle2D.Double(this.meterMiddleX - this.titleDim.getWidth() / 2.0, this.meterMiddleY - this.titleDim.getHeight() - this.radius - 7.0, this.titleDim.getWidth(), this.titleDim.getHeight()));
            this.getTitle().draw(graphics2D, n2);
        }
        graphics2D.translate(-this.bounds.getX(), -this.bounds.getY());
    }

    public void resetBeforeDraw() {
        this.meterStyle.clearAllInterval();
        this.meterStyle.convertAreaColor2List(this.value);
        double d2 = this.getTickSize();
        this.meterStyle.setTickSize(new Formula(Double.toString(d2)));
        this.resetAutoMax();
    }

    private void dealWhenPlus() {
        this.meterStyle.clearAllInterval();
        double d2 = 0.0;
        double d3 = d2 + this.meterStyle.getTickSizeFormula() * 9.0 * this.getOrder();
        this.meterStyle.setStartValue(new Formula(Double.toString(d2)));
        this.meterStyle.setEndValue(new Formula(Double.toString(d3)));
        MeterInterval meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field"), new Formula("" + d2), new Formula("" + d3 / 3.0));
        meterInterval.setBackgroundColor(new Color(231, 71, 62));
        this.meterStyle.addInterval(meterInterval);
        meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field"), new Formula("" + d3 / 3.0), new Formula("" + 2.0 * d3 / 3.0));
        meterInterval.setBackgroundColor(new Color(252, 210, 9));
        this.meterStyle.addInterval(meterInterval);
        meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field"), new Formula("" + 2.0 * d3 / 3.0), new Formula("" + d3));
        meterInterval.setBackgroundColor(new Color(77, 184, 73));
        this.meterStyle.addInterval(meterInterval);
    }

    private void dealWhenMinus() {
        this.meterStyle.clearAllInterval();
        double d2 = this.meterStyle.getTickSizeFormula();
        double d3 = -d2 * 9.0 * this.getOrder();
        double d4 = 0.0;
        this.meterStyle.setStartValue(new Formula(Double.toString(d3)));
        this.meterStyle.setEndValue(new Formula(Double.toString(d4)));
        MeterInterval meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field"), new Formula("" + d3), new Formula("" + d3 * 2.0 / 3.0));
        meterInterval.setBackgroundColor(new Color(231, 71, 62));
        this.meterStyle.addInterval(meterInterval);
        meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field"), new Formula("" + d3 * 2.0 / 3.0), new Formula("" + d3 / 3.0));
        meterInterval.setBackgroundColor(new Color(252, 210, 9));
        this.meterStyle.addInterval(meterInterval);
        meterInterval = new MeterInterval(Inter.getLocText("Chart_Meter_Field"), new Formula("" + d3 / 3.0), new Formula("" + d4));
        meterInterval.setBackgroundColor(new Color(77, 184, 73));
        this.meterStyle.addInterval(meterInterval);
    }

    private void resetAutoMax() {
        if (this.meterStyle.getDesignType() == 0) {
            if (this.value < 0.0) {
                this.dealWhenMinus();
            } else {
                this.dealWhenPlus();
            }
        }
    }

    private Dimension2D getCurrentValueDim() {
        double d2 = this.dealWithDoubleValue(this.value / this.getOrder());
        String string = new Double(d2).toString();
        Font font = new Font("SimSun", 0, 20);
        Rectangle2D rectangle2D = font.getStringBounds(string, CoreConstants.DEFAULT_FRC);
        return new DoubleDimension2D(rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Dimension2D getTickLableDim() {
        double d2 = this.getOrder();
        double d3 = this.meterStyle.getStartValueResult() / d2;
        double d4 = this.meterStyle.getEndValueFormula() / d2;
        double d5 = this.meterStyle.getTickSizeFormula();
        Font font = new Font("Century Gothic", 0, 9);
        Rectangle2D rectangle2D = font.getStringBounds("", CoreConstants.DEFAULT_FRC);
        for (double d6 = d3; d6 <= d4; d6 += d5) {
            String string = Utils.doubleToString(d6).trim();
            Rectangle2D rectangle2D2 = font.getStringBounds(string, CoreConstants.DEFAULT_FRC);
            if (!(rectangle2D2.getWidth() > rectangle2D.getWidth())) continue;
            rectangle2D = rectangle2D2;
        }
        return new DoubleDimension2D(rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    private double dealWithDoubleValue(double d2) {
        DecimalFormat decimalFormat = new DecimalFormat("##.##");
        return Double.parseDouble(decimalFormat.format(d2));
    }

    private double getOrder() {
        int n2 = this.meterStyle.getOrder();
        return Math.pow(10.0, n2);
    }

    private double getTickSize() {
        double d2 = this.getOrder();
        double d3 = (this.meterStyle.getEndValueFormula() - this.meterStyle.getStartValueResult()) / d2;
        if (d3 < 10.0) {
            BigDecimal bigDecimal = new BigDecimal(Double.toString(0.09));
            BigDecimal bigDecimal2 = new BigDecimal(Double.toString(this.meterStyle.getEndValueFormula() / d2));
            BigDecimal bigDecimal3 = new BigDecimal(Double.toString(this.meterStyle.getStartValueResult() / d2));
            BigDecimal bigDecimal4 = bigDecimal2.subtract(bigDecimal3);
            while (bigDecimal4.doubleValue() > 1.0) {
                bigDecimal4 = bigDecimal4.divide(bigDecimal4, 10, 6);
                bigDecimal = bigDecimal.multiply(new BigDecimal(Double.toString(10.0)));
            }
            bigDecimal4 = bigDecimal;
            while (bigDecimal4.doubleValue() < bigDecimal2.subtract(bigDecimal3).doubleValue()) {
                bigDecimal4 = bigDecimal4.add(bigDecimal);
            }
            return bigDecimal4.doubleValue() / 9.0;
        }
        double d4 = 0.09;
        double d5 = this.meterStyle.getEndValueFormula() / d2;
        double d6 = this.meterStyle.getStartValueResult() / d2;
        double d7 = d5 - d6;
        while (d7 > 1.0) {
            d7 /= 10.0;
            d4 *= 10.0;
        }
        for (d7 = d4; d7 < d5 - d6; d7 += d4) {
        }
        return d7 / 9.0;
    }

    private void adjuetRadius(double d2, double d3) {
        int n2;
        int n3 = this.getMeterStyle().getMeterAngle();
        Dimension2D dimension2D = this.maxLabelDim;
        int n4 = n2 = this.meterStyle.getMeterAngle() != 360 ? 1 : 2;
        this.radius = n3 == 360 ? Math.min(d2, d3) / 2.0 : (n3 >= 180 ? Math.min(d3 / (1.0 + Math.sin((double)((n3 - 180) / 2) * Math.PI / 180.0)), d2 / 2.0) : Math.min(d3, d2 / 2.0));
        if (dimension2D.getWidth() + this.radius > this.bounds.getWidth() / 2.0) {
            d2 -= 2.0 * (dimension2D.getWidth() + this.radius - this.bounds.getWidth() / 2.0);
        }
        double d4 = this.bounds.getY() + this.bounds.getHeight();
        double d5 = this.getCurrentValueDim().getHeight() + (double)this.currentGap;
        if (n3 == 180 && this.meterMiddleY + d5 > d4) {
            d3 -= d4 - this.meterMiddleY - d5;
        }
        this.radius = n3 == 360 ? Math.min(d2, d3) / 2.0 : (n3 >= 180 ? Math.min(d3 / (1.0 + Math.sin((double)((n3 - 180) / 2) * Math.PI / 180.0)), d2 / 2.0) : Math.min(d3 -= (double)n2 * dimension2D.getHeight(), d2 / 2.0));
        this.meterMiddleY = this.radius > d3 / 2.0 ? this.radius + this.titleDim.getHeight() : d3 / 2.0;
    }

    private void initTransientValue(int n2) {
        if (this.titleGlyph != null) {
            String string = this.titleGlyph.getText();
            this.titleDim = GlyphUtils.calculateTextDimensionWithNoRotation(string, this.getMeterStyle().getTitleTextAttr(), n2);
        }
        if (this.meterStyle.getMaxArrowAngle() <= 180) {
            this.meterStyle.setMeterAngle(180);
        } else if (this.meterStyle.getMaxArrowAngle() <= 270) {
            this.meterStyle.setMeterAngle(270);
        } else {
            this.meterStyle.setMeterAngle(360);
        }
        double d2 = 6.0;
        double d3 = 6.0;
        double d4 = this.bounds.getWidth() - 8.0 - d2;
        double d5 = this.bounds.getHeight() - 8.0 - d3 - this.titleDim.getHeight();
        int n3 = (int)Math.max(470.0 - d4, 250.0 - d5) / 100;
        this.labelGap -= n3;
        this.labelGap = Math.max(this.labelGap, 4);
        int n4 = (int)((250.0 - d5) / 100.0);
        this.currentGap -= n4;
        this.currentGap = Math.max(this.currentGap, 4);
        this.meterMiddleX = this.bounds.getWidth() / 2.0;
        if (this.meterStyle.getMeterAngle() == 360) {
            this.radius = Math.min(d4, d5) / 2.0;
            this.adjuetRadius(d4, d5);
            this.meterMiddleY = this.bounds.getHeight() / 2.0;
        } else {
            int n5 = this.getMeterStyle().getMeterAngle();
            if (n5 > 180) {
                this.radius = Math.min(d5 / (1.0 + Math.sin((double)((n5 - 180) / 2) * Math.PI / 180.0)), d4 / 2.0);
                this.adjuetRadius(d4, d5);
            } else {
                this.radius = Math.min(d5, d4 / 2.0);
                this.adjuetRadius(d4, d5);
            }
        }
        this.innerRadius *= this.radius;
        this.currentGap = (int)(this.radius * 0.07);
        this.currentGap = Math.min(20, this.currentGap);
        this.calculateMeterShape();
    }

    private void calculateMeterShape() {
        this.startAngle = this.valueToAngle(this.meterStyle.getStartValueResult(), this.getMeterStyle().getMeterAngle());
        this.extentAngle = this.valueToAngle(this.meterStyle.getEndValueFormula(), this.getMeterStyle().getMeterAngle()) - this.startAngle;
        this.joinType = 0;
        if (this.meterStyle.getMeterAngle() >= 180) {
            this.joinType = 1;
            if (this.meterStyle.getMeterAngle() == 360) {
                this.joinType = 0;
                this.extentAngle = 360.0;
            }
        } else {
            this.joinType = 2;
        }
        this.meterShape = (double)this.meterStyle.getMeterAngle() < 190.0 ? new Arc2D.Double(this.meterMiddleX - this.radius, this.meterMiddleY - this.radius, 2.0 * this.radius, 2.0 * this.radius, this.startAngle + 5.0, this.extentAngle - 10.0, this.joinType) : new Arc2D.Double(this.meterMiddleX - this.radius, this.meterMiddleY - this.radius, 2.0 * this.radius, 2.0 * this.radius, this.startAngle, this.extentAngle, this.joinType);
    }

    private void drawArrow(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setPaint(new Color(66, 111, 179));
        double d2 = 0.14 * this.radius;
        Arc2D.Double double_ = this.meterStyle.getMeterAngle() == 180 ? new Arc2D.Double(this.meterMiddleX - d2, this.meterMiddleY - d2, d2 * 2.0, d2 * 2.0, 0.0, 180.0, 1) : new Arc2D.Double(this.meterMiddleX - d2, this.meterMiddleY - d2, d2 * 2.0, d2 * 2.0, 0.0, 360.0, 1);
        if (this.getValue() >= this.meterStyle.getStartValueResult() && this.getValue() <= this.meterStyle.getEndValueFormula()) {
            this.drawArrowAngle(graphics2D, double_);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    private GeneralPath getPointerPath() {
        double d2 = 0.35 * this.innerRadius;
        double d3 = Math.asin(d2 / (2.0 * this.innerRadius));
        double d4 = this.valueToAngle(this.value, this.meterStyle.getMaxArrowAngle());
        double d5 = this.meterMiddleX + this.innerRadius * Math.cos(Math.PI * (d4 / 180.0) - d3);
        double d6 = this.meterMiddleY - this.innerRadius * Math.sin(Math.PI * (d4 / 180.0) - d3);
        double d7 = this.meterMiddleX + this.innerRadius * Math.cos(Math.PI * (d4 / 180.0) + d3);
        double d8 = this.meterMiddleY - this.innerRadius * Math.sin(Math.PI * (d4 / 180.0) + d3);
        double d9 = this.meterMiddleX + 0.8275 * this.radius * Math.cos(Math.PI * d4 / 180.0);
        double d10 = this.meterMiddleY - 0.8275 * this.radius * Math.sin(Math.PI * d4 / 180.0);
        if (this.meterStyle.getMeterAngle() == 180) {
            if (180.0 - d3 * 360.0 < d4) {
                d5 = this.meterMiddleX + this.innerRadius * Math.cos(Math.PI * (d4 / 180.0) - 2.0 * d3);
                d6 = this.meterMiddleY - this.innerRadius * Math.sin(Math.PI * (d4 / 180.0) - 2.0 * d3);
                d7 = this.meterMiddleX;
                d8 = this.meterMiddleY;
            }
            if (d3 * 180.0 > d4) {
                d5 = this.meterMiddleX;
                d6 = this.meterMiddleY;
                d7 = this.meterMiddleX + this.innerRadius * Math.cos(Math.PI * (d4 / 180.0) + 2.0 * d3);
                d8 = this.meterMiddleY - this.innerRadius * Math.sin(Math.PI * (d4 / 180.0) + 2.0 * d3);
            }
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)d9, (float)d10);
        generalPath.lineTo((float)d5, (float)d6);
        generalPath.lineTo((float)d7, (float)d8);
        generalPath.closePath();
        return generalPath;
    }

    private void drawArrowAngle(Graphics2D graphics2D, Arc2D arc2D) {
        GeneralPath generalPath = this.getPointerPath();
        graphics2D.setColor(Color.RED);
        graphics2D.fill(generalPath);
        Point2D.Double double_ = new Point2D.Double(arc2D.getX(), arc2D.getY());
        Point2D.Double double_2 = new Point2D.Double(arc2D.getX() + arc2D.getWidth(), arc2D.getY() + arc2D.getHeight());
        float[] fArray = new float[]{0.0f, 0.5f, 1.0f};
        Color[] colorArray = new Color[]{new Color(66, 111, 179), new Color(66, 111, 179), new Color(66, 111, 179)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint((Point2D)double_, (Point2D)double_2, fArray, colorArray);
        graphics2D.setPaint((Paint)linearGradientPaint);
        graphics2D.fill(arc2D);
    }

    public Shape getShape() {
        if (this.meterShape == null) {
            return this.bounds;
        }
        return new Arc2D.Double(this.meterShape.getX() + this.bounds.getX(), this.meterShape.getY() + this.bounds.getY(), this.meterShape.getWidth(), this.meterShape.getHeight(), this.meterShape.getAngleStart(), this.meterShape.getAngleExtent(), this.meterShape.getArcType());
    }

    private double valueToAngle(double d2, int n2) {
        double d3 = (double)(n2 / 2) + 90.0;
        return d3 - (d2 -= this.getMeterStyle().getStartValueResult()) / (this.getMeterStyle().getEndValueFormula() - this.getMeterStyle().getStartValueResult()) * (double)n2;
    }

    private void drawArcForInterval(Graphics2D graphics2D, MeterInterval meterInterval, int n2) {
        this.radius -= (double)this.labelGap;
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setPaint(meterInterval.getBackgroundColor());
        double d2 = this.deal4Begin(n2, meterInterval);
        double d3 = this.deal4End(n2, meterInterval);
        if (d2 > d3) {
            return;
        }
        double d4 = this.valueToAngle(d2, this.getMeterStyle().getMaxArrowAngle());
        double d5 = this.valueToAngle(d3, this.getMeterStyle().getMaxArrowAngle());
        graphics2D.setStroke(new BasicStroke(3.0f));
        double d6 = 0.0;
        this.arcWidth = this.radius * 0.23;
        double d7 = this.radius - d6 - this.arcWidth;
        this.maxOuterSize = Math.max(this.maxOuterSize, this.arcWidth);
        float f2 = (float)d7;
        while ((double)f2 < this.radius - d6) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(this.meterMiddleX - (double)f2, this.meterMiddleY - (double)f2, 2.0f * f2, 2.0f * f2);
            graphics2D.draw(new Arc2D.Double(double_, d4, d5 - d4, 0));
            f2 += 1.0f;
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        this.radius += (double)this.labelGap;
    }

    private double deal4Begin(int n2, MeterInterval meterInterval) {
        double d2 = this.meterStyle.getIntervalCount();
        double d3 = this.meterStyle.getStartValueResult() + this.extentAngle * (double)n2 / d2;
        Number number = ChartBaseUtils.formula2Number(meterInterval.getBeginValue());
        if (number != null) {
            d3 = number.doubleValue();
        }
        if (d3 < this.meterStyle.getStartValueResult()) {
            d3 = this.meterStyle.getStartValueResult();
        }
        return d3;
    }

    private double deal4End(int n2, MeterInterval meterInterval) {
        double d2 = this.meterStyle.getIntervalCount();
        double d3 = this.meterStyle.getStartValueResult() + this.extentAngle * (double)(n2 + 1) / d2;
        Number number = ChartBaseUtils.formula2Number(meterInterval.getEndValue());
        if (number != null) {
            d3 = number.doubleValue();
        }
        if (d3 > this.meterStyle.getEndValueFormula()) {
            d3 = this.meterStyle.getEndValueFormula();
        }
        return d3;
    }

    private void drawTicks(Graphics2D graphics2D, int n2) {
        double d2 = this.meterStyle.getTickSizeFormula();
        double d3 = this.getOrder();
        if (d2 > 0.0) {
            double d4;
            double d5;
            double d6 = this.meterStyle.getStartValueResult() / d3;
            if (d6 > (d5 = this.meterStyle.getEndValueFormula() / d3)) {
                return;
            }
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(Color.BLACK);
            GeneralPath generalPath = new GeneralPath();
            BigDecimal bigDecimal = new BigDecimal(Double.toString(d6)).subtract(new BigDecimal(Double.toString(d2)));
            for (d4 = d6; d4 <= d5; d4 += d2) {
                bigDecimal = bigDecimal.add(new BigDecimal(Double.toString(d2)));
                if (d4 == d6 || d4 == d5) {
                    this.drawTickLine(graphics2D, d4 * d3, true, true);
                } else {
                    this.drawTickLine(graphics2D, d4 * d3, false, true);
                }
                if (this.meterStyle.getMaxArrowAngle() == 360 && d4 == d5) continue;
                this.drawTickLabel(graphics2D, bigDecimal.doubleValue(), generalPath);
            }
            for (d4 = d6; d4 <= d5; d4 += d2 / 5.0) {
                if ((d4 - d6) % d2 == 0.0) continue;
                this.drawTickLine(graphics2D, d4 * d3, false, false);
            }
            graphics2D.setPaint(paint);
        }
    }

    private void drawTickLine(Graphics2D graphics2D, double d2, boolean bl, boolean bl2) {
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        double d3 = this.valueToAngle(d2, this.getMeterStyle().getMaxArrowAngle());
        double d4 = 8.0;
        double d5 = 0.0;
        d5 = this.maxOuterSize;
        if (!bl2 && !bl) {
            d5 -= this.arcWidth / 2.0;
        }
        double d6 = this.meterMiddleX + (this.radius - d4 - this.maxOuterSize + d5) * Math.cos(Math.PI * (d3 / 180.0));
        double d7 = this.meterMiddleY - (this.radius - d4 - this.maxOuterSize + d5) * Math.sin(Math.PI * (d3 / 180.0));
        double d8 = this.meterMiddleX + (this.radius - this.arcWidth - (double)this.labelGap) * Math.cos(Math.PI * (d3 / 180.0));
        double d9 = this.meterMiddleY - (this.radius - this.arcWidth - (double)this.labelGap) * Math.sin(Math.PI * (d3 / 180.0));
        graphics2D.setStroke(new BasicStroke(this.radius > 100.0 ? 1.2f : 0.8f));
        graphics2D.setColor(Color.white);
        graphics2D.draw(new Line2D.Double(d8, d9, d6, d7));
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    private void drawTickLabel(Graphics2D graphics2D, double d2, GeneralPath generalPath) {
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        if (this.meterStyle.isTickLabelsVisible()) {
            Rectangle2D.Double double_;
            double d3 = this.getOrder();
            double d4 = this.valueToAngle(d2 * d3, this.getMeterStyle().getMaxArrowAngle());
            String string = this.meterStyle.getUnitFormat() != null ? this.meterStyle.getUnitFormat().format(Double.valueOf(Utils.doubleToString(d2))).toString() : Utils.doubleToString(d2);
            graphics2D.setPaint(new Color(51, 51, 51));
            float f2 = 9.0f;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setFont(FRFont.getInstance("Century Gothic", 0, f2));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D = this.getTextBounds(string, graphics2D, fontMetrics);
            double d5 = this.meterMiddleX + this.radius * Math.cos(Math.PI * (d4 / 180.0));
            double d6 = this.meterMiddleY - this.radius * Math.sin(Math.PI * (d4 / 180.0));
            if (this.radius * Math.cos(Math.PI * (d4 / 180.0)) < 0.0) {
                d5 -= rectangle2D.getWidth();
            }
            if (generalPath.intersects(double_ = new Rectangle2D.Double(d5, d6, rectangle2D.getWidth(), rectangle2D.getHeight()))) {
                return;
            }
            generalPath.append(double_, false);
            graphics2D.drawString(string, (float)d5, (float)d6);
            if (f2 <= 7.0f) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
        graphics2D.setFont(font);
        graphics2D.setColor(color);
    }

    private void drawDisplay(Graphics2D graphics2D) {
        Font font = graphics2D.getFont();
        String string = "No value";
        string = "" + this.dealWithDoubleValue(this.getValue() / this.getOrder());
        float f2 = 20.0f;
        FRFont fRFont = FRFont.getInstance("Century Gothic", 0, f2);
        graphics2D.setFont(fRFont);
        Rectangle2D rectangle2D = fRFont.getStringBounds(string, CoreConstants.DEFAULT_FRC);
        DoubleDimension2D doubleDimension2D = new DoubleDimension2D(rectangle2D.getWidth(), rectangle2D.getHeight());
        graphics2D.setStroke(new BasicStroke(1.0f));
        double d2 = f2;
        double d3 = ((Dimension2D)doubleDimension2D).getWidth();
        double d4 = this.meterMiddleX - ((Dimension2D)doubleDimension2D).getWidth() / 2.0;
        double d5 = this.meterMiddleY;
        double d6 = this.meterStyle.getMaxArrowAngle();
        double d7 = this.radius * -1.0 * Math.cos(Math.PI * (d6 / 360.0));
        if (this.meterStyle.getMaxArrowAngle() > 180) {
            double d8 = 2.0 * (this.radius - this.arcWidth - (double)this.labelGap) * Math.sin(Math.PI * (d6 / 360.0));
            if (d8 > d3) {
                double d9 = -1.0 * (d3 / 2.0) * Math.cos(Math.PI * (d6 / 360.0)) / Math.sin(Math.PI * (d6 / 360.0));
                d9 = d9 > this.innerRadius ? d9 : this.innerRadius;
                double d10 = d7 - d9;
                d5 = d10 > d2 ? (d5 += -this.radius * Math.cos(Math.PI * (d6 / 360.0)) - d2) : (d5 += this.innerRadius + (double)this.currentGap);
            } else {
                d5 += this.innerRadius + (double)this.currentGap;
                double d11 = this.innerRadius + (double)this.currentGap;
                double d12 = this.radius - this.arcWidth - (double)this.labelGap;
                double d13 = Math.sqrt(d12 * d12 - d11 * d11) * 2.0;
                double d14 = d12 * -1.0 * Math.cos(Math.PI * (d6 / 360.0)) - this.innerRadius - (double)this.currentGap;
                fRFont = this.getCurrentValueFont(new DoubleDimension2D(d13, d14), string);
                rectangle2D = fRFont.getStringBounds(string, CoreConstants.DEFAULT_FRC);
                ((Dimension2D)doubleDimension2D).setSize(rectangle2D.getWidth(), rectangle2D.getHeight());
                d3 = ((Dimension2D)doubleDimension2D).getWidth();
                f2 = fRFont.getSize();
                d4 = this.meterMiddleX - ((Dimension2D)doubleDimension2D).getWidth() / 2.0;
                graphics2D.setFont(fRFont);
            }
        } else {
            d5 += (double)this.currentGap;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d5, d3, d2);
        this.drawContentInDisPlayer(graphics2D, string, double_, f2);
        graphics2D.setFont(font);
    }

    private FRFont getCurrentValueFont(Dimension2D dimension2D, String string) {
        int n2 = 8;
        FRFont fRFont = FRFont.getInstance("Century Gothic", 0, n2);
        Rectangle2D rectangle2D = fRFont.getStringBounds(string, CoreConstants.DEFAULT_FRC);
        DoubleDimension2D doubleDimension2D = new DoubleDimension2D(rectangle2D.getWidth(), rectangle2D.getHeight());
        while (((Dimension2D)doubleDimension2D).getWidth() < dimension2D.getWidth() && ((Dimension2D)doubleDimension2D).getHeight() < dimension2D.getHeight()) {
            fRFont = FRFont.getInstance("Century Gothic", 0, ++n2);
            rectangle2D = fRFont.getStringBounds(string, CoreConstants.DEFAULT_FRC);
            ((Dimension2D)doubleDimension2D).setSize(rectangle2D.getWidth(), rectangle2D.getHeight());
            if (fRFont.getSize() != 20) continue;
            return fRFont;
        }
        return fRFont;
    }

    private void drawContentInDisPlayer(Graphics2D graphics2D, String string, Rectangle2D rectangle2D, float f2) {
        graphics2D.setColor(new Color(25, 79, 151));
        graphics2D.drawString(string, (int)rectangle2D.getX(), (int)(rectangle2D.getY() + (double)f2));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setColor(new Color(25, 79, 151));
        Font font = new Font("Microsoft Yahei", 1, 12);
        graphics2D.setFont(font);
        String string2 = this.meterStyle.getUnits();
        Rectangle2D rectangle2D2 = font.getStringBounds(string2, CoreConstants.DEFAULT_FRC);
        DoubleDimension2D doubleDimension2D = new DoubleDimension2D(rectangle2D2.getWidth(), rectangle2D2.getHeight());
        float f3 = (float)(this.meterMiddleX - ((Dimension2D)doubleDimension2D).getWidth() / 2.0);
        float f4 = (float)(this.meterMiddleY - 0.23 * this.radius);
        graphics2D.drawString(string2, f3, f4);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private Rectangle2D getTextBounds(String string, Graphics2D graphics2D, FontMetrics fontMetrics) {
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        LineMetrics lineMetrics = fontMetrics.getFont().getLineMetrics(string, graphics2D.getFontRenderContext());
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), lineMetrics.getHeight());
        return rectangle2D;
    }

    public void setMeterStyle(MeterStyle meterStyle) {
        this.meterStyle = meterStyle;
    }

    public MeterStyle getMeterStyle() {
        return this.meterStyle;
    }

    public void setValue(double d2) {
        this.value = d2;
    }

    public double getValue() {
        return this.value;
    }

    public void setTitle(TextGlyph textGlyph) {
        this.titleGlyph = textGlyph;
    }

    public void setMaxLabelDim(Dimension2D dimension2D) {
        this.maxLabelDim = dimension2D;
    }

    public TextGlyph getTitle() {
        return this.titleGlyph;
    }

    public boolean equals(Object object) {
        return object instanceof Meter && ComparatorUtils.equals(((Meter)object).getBounds(), this.getBounds()) && ((Meter)object).getValue() == this.getValue() && ComparatorUtils.equals(((Meter)object).getMeterStyle(), this.getMeterStyle()) && ComparatorUtils.equals(((Meter)object).getTitle(), this.getTitle());
    }

    public Object clone() throws CloneNotSupportedException {
        Meter meter = (Meter)super.clone();
        if (this.meterStyle != null) {
            meter.setMeterStyle((MeterStyle)this.meterStyle.clone());
        }
        if (this.bounds != null) {
            meter.setBounds((Rectangle2D)this.bounds.clone());
        }
        if (this.titleGlyph != null) {
            meter.setTitle((TextGlyph)this.titleGlyph.clone());
        }
        return meter;
    }
}

