/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.BaseUtils;
import com.fr.base.GraphHelper;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class GisMapPlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = -1382651172653550801L;
    private boolean gisType;
    private boolean addressType;
    private String googleKey = "";
    private String baiduKey = "";
    private String id4div = null;

    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        BufferedImage bufferedImage = BaseUtils.readImage(this.getImagePath());
        Rectangle2D rectangle2D = this.getBounds();
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getHeight();
        GraphHelper.paintImage(graphics2D, (int)d2, (int)d3, bufferedImage, 4, -1, -1, -1, -1);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public String getImagePath() {
        return "/com/fr/chart/chartglyph/gisMap.png";
    }

    public void layoutAxisGlyph(int n2) {
    }

    public void layoutDataSeriesGlyph(int n2) {
    }

    public String getPlotGlyphType() {
        return "GisMapPlotGlyph";
    }

    public void setAddressType(boolean bl) {
        this.addressType = bl;
    }

    public void setGisType(boolean bl) {
        this.gisType = bl;
    }

    public String getBaiduKey() {
        return this.baiduKey;
    }

    public void setBaiduKey(String string) {
        this.baiduKey = string;
    }

    public String getGoogleKey() {
        return this.googleKey;
    }

    public void setGoogleKey(String string) {
        this.googleKey = string;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("gisType", this.gisType);
        jSONObject.put("addressType", this.addressType);
        String string = this.gisType ? this.baiduKey : this.googleKey;
        jSONObject.put("key", string);
        return jSONObject;
    }

    public boolean equals(Object object) {
        return object instanceof GisMapPlotGlyph && ((GisMapPlotGlyph)object).addressType == this.addressType && ((GisMapPlotGlyph)object).gisType == this.gisType && super.equals(object);
    }
}

