/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.background.ColorBackground;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.Arc3DStyleBase;
import com.fr.chart.chartglyph.ArcHighLightStyleBase;
import com.fr.chart.chartglyph.ArcPlane3DStyle;
import com.fr.chart.chartglyph.ArcTopDownShadeStyle;
import com.fr.chart.chartglyph.ArcTransparentChartStyle;
import com.fr.chart.chartglyph.ChartStyle;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DonutHighLightStyle;
import com.fr.chart.chartglyph.DonutPlotGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class Donut2DPlotGlyph
extends DonutPlotGlyph {
    private static final long serialVersionUID = 44023787828180817L;
    private static final double TRYMAX = 8.0;
    private static final double THREED_BASE = 7.0;
    private static final double ROUND_ANGLE = 360.0;
    private Arc3DStyleBase arc3DStyleBase;
    private ArcHighLightStyleBase arcHighLightStyleBase;

    public void layoutDataSeriesGlyph(int n2) {
        this.initArcValues();
        this.labelBounds.clear();
        int n3 = this.getCategoryCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.dealWithDataSeries(i2, n2);
        }
    }

    private void dealWithDataSeries(int n2, int n3) {
        int n4 = this.getSeriesSize();
        for (int i2 = 0; i2 < n4; ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            DataPoint dataPoint = dataSeries.getDataPoint(n2);
            if (dataPoint.isValueIsNull()) continue;
            ShapeGlyph shapeGlyph = this.calculateShapeGlyph4DifferentSub(dataPoint, n2, i2);
            dataPoint.setDrawImpl(shapeGlyph);
            this.dealLabelBounds(dataPoint, n3);
            this.dealPlotStyle(this.plotStyle, dataPoint);
        }
    }

    private void dealPlotStyle(int n2, DataPoint dataPoint) {
        ShapeGlyph shapeGlyph = (ShapeGlyph)dataPoint.getDrawImpl();
        Shape shape = dataPoint.getShape();
        Arc2D.Double double_ = this.getOuterArcShape(dataPoint.getCategoryIndex(), dataPoint.getSeriesIndex());
        if (shapeGlyph.getBackground() instanceof ColorBackground) {
            Color color = ((ColorBackground)shapeGlyph.getBackground()).getColor();
            ChartStyle chartStyle = null;
            if (n2 == 1) {
                if (this.arc3DStyleBase == null) {
                    this.arc3DStyleBase = new Arc3DStyleBase(this.get3DStyleBaseShape(), this.getOuterArc());
                }
                chartStyle = new ArcPlane3DStyle(color, double_, shape, true, this.getCategoryCount(), this.radius);
            } else if (n2 == 2) {
                if (this.arcHighLightStyleBase == null) {
                    this.arcHighLightStyleBase = new ArcHighLightStyleBase(this.getArcHighlightShadow(), this.getArcGradientArc());
                }
                double d2 = this.radius - this.arcWidth * this.categoryGap / 2.0;
                chartStyle = new DonutHighLightStyle(color, d2, this.centerPoint, shape);
            } else if (n2 == 4) {
                chartStyle = new ArcTopDownShadeStyle(color, double_, shape, true, this.getCategoryCount(), this.radius);
            } else if (n2 == 5) {
                chartStyle = new ArcTransparentChartStyle(color, shape, true);
            }
            if (chartStyle != null) {
                dataPoint.setDataPointStyle(chartStyle);
            }
        }
    }

    private Arc2D getArcWithRadius(double d2) {
        return new Arc2D.Double(this.centerPoint.getX() - d2, this.centerPoint.getY() - d2, 2.0 * d2, 2.0 * d2, 0.0, 360.0, 0);
    }

    private Arc2D getArcHighlightShadow() {
        return this.getArcWithRadius(this.outerArcRadius - this.arcWidth * this.categoryGap / 2.0);
    }

    private Arc2D getArcGradientArc() {
        double d2 = this.innerRadius + this.arcWidth * this.categoryGap / 2.0;
        return this.getArcWithRadius(d2);
    }

    private Arc2D getOuterArc() {
        double d2 = this.radius * (1.0 - this.innerRadiusPercent / 7.0);
        return this.getArcWithRadius(d2);
    }

    private Shape get3DStyleBaseShape() {
        double d2 = this.radius * (1.0 - this.innerRadiusPercent / 7.0);
        double d3 = d2 - this.radius * (1.0 - this.innerRadiusPercent);
        Arc2D.Double double_ = new Arc2D.Double(this.centerPoint.getX() - d2, this.centerPoint.getY() - d2, 2.0 * d2, 2.0 * d2, 0.0, 360.0, 0);
        Arc2D.Double double_2 = new Arc2D.Double(this.centerPoint.getX() - d3, this.centerPoint.getY() - d3, 2.0 * d3, 2.0 * d3, 0.0, 360.0, 0);
        Area area = new Area(double_);
        area.subtract(new Area(double_2));
        return area;
    }

    private ShapeGlyph calculateShapeGlyph4DifferentSub(DataPoint dataPoint, int n2, int n3) {
        Shape shape = this.getArc2DPath(n2, n3);
        ShapeGlyph shapeGlyph = new ShapeGlyph(shape);
        shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
        return shapeGlyph;
    }

    private Arc2D.Double getOuterArcShape(int n2, int n3) {
        double d2 = this.getSeriesStartAngle(n2, n3, false) % 360.0;
        double d3 = this.getActOuterRadius(n2);
        double d4 = this.getPercent(n3, n2) * (360.0 - this.getSeriesGapAngle(n2, n3, false));
        Arc2D.Double double_ = new Arc2D.Double(this.centerPoint.getX() - d3, this.centerPoint.getY() - d3, 2.0 * d3, 2.0 * d3, 180.0 - d2, -d4, 2);
        return double_;
    }

    private Shape getArc2DPath(int n2, int n3) {
        double d2 = this.getSeriesStartAngle(n2, n3, true) % 360.0;
        double d3 = this.getArcInnerRadius(n2);
        double d4 = this.getPercent(n3, n2) * (360.0 - this.getSeriesGapAngle(n2, n3, true));
        double d5 = this.getSeriesStartAngle(n2, n3, false) % 360.0;
        double d6 = this.getActOuterRadius(n2);
        double d7 = this.getPercent(n3, n2) * (360.0 - this.getSeriesGapAngle(n2, n3, false));
        GeneralPath generalPath = new GeneralPath();
        Arc2D.Double double_ = new Arc2D.Double(this.centerPoint.getX() - d6, this.centerPoint.getY() - d6, 2.0 * d6, 2.0 * d6, 180.0 - d5, -d7, 0);
        Arc2D.Double double_2 = new Arc2D.Double(this.centerPoint.getX() - d3, this.centerPoint.getY() - d3, 2.0 * d3, 2.0 * d3, 180.0 - d2 - d4, d4, 0);
        generalPath.moveTo((float)double_.getStartPoint().getX(), (float)double_.getStartPoint().getY());
        generalPath.append(double_, true);
        generalPath.lineTo((float)double_2.getStartPoint().getX(), (float)double_2.getStartPoint().getY());
        generalPath.append(double_2, true);
        generalPath.closePath();
        return generalPath;
    }

    protected void dealLabelBounds(DataPoint dataPoint, int n2) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph == null) {
            return;
        }
        String string = textGlyph.getText();
        if (string != null && string.length() > 0) {
            int n3 = dataPoint.getSeriesIndex();
            int n4 = dataPoint.getCategoryIndex();
            double d2 = this.getSeriesStartAngle(n4, n3, true) % 360.0;
            double d3 = this.getPercent(n3, n4) * 360.0;
            double d4 = (d3 / 2.0 + d2) % 360.0;
            double d5 = this.innerRadius + this.arcWidth * (double)n4 + this.arcWidth / 2.0;
            double d6 = this.centerPoint.getX() - d5 * Math.cos(d4 / 180.0 * Math.PI);
            double d7 = this.centerPoint.getY() - d5 * Math.sin(d4 / 180.0 * Math.PI);
            Dimension2D dimension2D = this.getLabelDim(dataPoint, n2);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d6 - dimension2D.getWidth() / 2.0, d7 - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
            if (this.isBlankBounds(double_)) {
                textGlyph.setBounds(double_);
                this.labelBounds.add(double_);
            } else {
                int n5 = 4;
                int n6 = 0;
                while ((double)n6 < 8.0) {
                    int n7 = (int)((double)n6 / 2.0) + 1;
                    n7 = n6 % 2 == 0 ? n5 - n7 : n5 + n7;
                    d4 = (d2 + (double)n7 * d3 / 8.0) % 360.0;
                    d6 = this.centerPoint.getX() - d5 * Math.cos(d4 / 180.0 * Math.PI);
                    d7 = this.centerPoint.getY() - d5 * Math.sin(d4 / 180.0 * Math.PI);
                    double_ = new Rectangle2D.Double(d6 - dimension2D.getWidth() / 2.0, d7 - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
                    if (this.isBlankBounds(double_)) {
                        textGlyph.setBounds(double_);
                        this.labelBounds.add(double_);
                        break;
                    }
                    ++n6;
                }
            }
        }
    }

    private boolean isBlankBounds(Rectangle2D rectangle2D) {
        boolean bl = true;
        for (int i2 = 0; i2 < this.labelBounds.size(); ++i2) {
            if (!ChartUtils.rectangleOverlapped((Rectangle2D)this.labelBounds.get(i2), rectangle2D)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawInfo(graphics);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.arc3DStyleBase != null) {
            this.arc3DStyleBase.paintStyle(graphics);
        } else if (this.arcHighLightStyleBase != null) {
            this.arcHighLightStyleBase.paintStyle(graphics);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics, n2);
    }

    public String getPlotGlyphType() {
        return "Donut2DPlotGlyph";
    }

    protected double getSeriesStartAngle(int n2, int n3, boolean bl) {
        double d2 = 135.0;
        double d3 = this.getSeriesGapAngle(n2, n3, bl);
        double d4 = d3 / (double)this.getSeriesSize();
        double d5 = 0.0;
        for (int i2 = 0; i2 < n3; ++i2) {
            d5 += this.getPercent(i2, n2) * (360.0 - d3);
        }
        return d2 += d5 + d4 * (double)n3 + d4 / 2.0;
    }

    protected double getSeriesGapAngle(int n2, int n3, boolean bl) {
        double d2 = this.seriesGap * 2.0 * Math.PI * this.innerRadius;
        double d3 = bl ? this.getArcInnerRadius(n2) : this.getActOuterRadius(n2);
        return d2 / d3 * 360.0 / (Math.PI * 2);
    }

    private Dimension2D getLabelDim(DataPoint dataPoint, int n2) {
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
        TextAttr textAttr = attrContents.getTextAttr();
        return GlyphUtils.calculateTextDimensionWithNoRotation(dataPoint.getDataLabel().getText(), textAttr, n2);
    }

    public boolean equals(Object object) {
        return object instanceof Donut2DPlotGlyph && super.equals(object);
    }
}

