/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.AttrAxisPosition;
import com.fr.chart.chartglyph.AreaPlotGlyph;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.Bar2DPlotGlyph;
import com.fr.chart.chartglyph.BarDataWithAxisGlyph;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.CustomAttr;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSeries4Area;
import com.fr.chart.chartglyph.LinePlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class CustomPlotGlyph
extends CategoryPlotGlyph {
    private static final long serialVersionUID = -717908304255012814L;
    private Bar2DPlotGlyph bar2DPlotGlyph;
    private Bar2DPlotGlyph bar2DPlotGlyphStack;
    private LinePlotGlyph linePlotGlyph;
    private AreaPlotGlyph areaPlotGlyphStack;
    ArrayList<DataSeries> stackList = new ArrayList();

    public void setBar2DPlotGlyph(Bar2DPlotGlyph bar2DPlotGlyph) {
        this.bar2DPlotGlyph = bar2DPlotGlyph;
    }

    public void setBar2DPlotGlyphStack(Bar2DPlotGlyph bar2DPlotGlyph) {
        this.bar2DPlotGlyphStack = bar2DPlotGlyph;
    }

    public void setLinePlotGlyph(LinePlotGlyph linePlotGlyph) {
        this.linePlotGlyph = linePlotGlyph;
    }

    public void setAreaPlotGlyphStack(AreaPlotGlyph areaPlotGlyph) {
        this.areaPlotGlyphStack = areaPlotGlyph;
    }

    public void layoutAxisGlyph(int n2) {
        this.layoutDoubleAxisGlyph(this.getxAxisGlyph(), this.getyAxisGlyph(), this.getSecondAxisGlyph(), n2);
    }

    public void layoutDataSeriesGlyph(int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            CustomAttr customAttr = (CustomAttr)this.getConditionCollection().getAttrByResult(this.getSeries(i2));
            AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, this.getSeries(i2));
            int n6 = customAttr.getRenderer();
            if (n6 == 1) {
                ++n3;
                continue;
            }
            if (n6 != 3) continue;
            if (ComparatorUtils.equals(attrAxisPosition.getAxisPosition(), "LEFT")) {
                ++n4;
                continue;
            }
            ++n5;
        }
        this.dealSeriesSingle(n3, n4, n5, n2);
        this.bar2DPlotGlyphStack.setTotalRectForStackedBar(this.stackList);
        this.dealLabelBoundsInOrder();
    }

    private void dealSeriesSingle(int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            AxisGlyph axisGlyph = this.getSeriesAxisGlyph(i2);
            AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, dataSeries);
            CustomAttr customAttr = (CustomAttr)this.getConditionCollection().getAttrByResult(dataSeries);
            int n9 = customAttr.getRenderer();
            if (n9 == 1) {
                this.bar2DPlotGlyph.setBounds(this.getBounds());
                this.bar2DPlotGlyph.dealShape4Bar(dataSeries, this, new BarDataWithAxisGlyph(this.getxAxisGlyph(), axisGlyph, n2, n6), n5);
                ++n6;
                continue;
            }
            if (n9 == 3) {
                this.bar2DPlotGlyphStack.setBounds(this.getBounds());
                if (ComparatorUtils.equals(attrAxisPosition.getAxisPosition(), "LEFT")) {
                    this.bar2DPlotGlyphStack.dealShape4Bar(dataSeries, this, new BarDataWithAxisGlyph(this.getxAxisGlyph(), axisGlyph, n3, n7), n5);
                    ++n7;
                } else {
                    this.bar2DPlotGlyphStack.dealShape4Bar(dataSeries, this, new BarDataWithAxisGlyph(this.getxAxisGlyph(), axisGlyph, n4, n8), n5);
                    ++n8;
                }
                this.stackList.add(dataSeries);
                continue;
            }
            if (n9 == 2 || n9 == 4) {
                this.linePlotGlyph.setBounds(this.getBounds());
                this.linePlotGlyph.dealLine4PlotGlyph(dataSeries, this, this.getxAxisGlyph(), axisGlyph, n5);
                continue;
            }
            if (n9 != 6 && n9 != 5) continue;
            this.areaPlotGlyphStack.setBounds(this.getBounds());
            this.areaPlotGlyphStack.dealAreaShape4PlotGlyph((DataSeries4Area)dataSeries, this, this.getxAxisGlyph(), axisGlyph, n5);
        }
    }

    private double getPreType(int n2, int n3, int n4) {
        AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, this.getSeries(n2));
        double d2 = 0.0;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            CustomAttr customAttr = (CustomAttr)this.getConditionCollection().getAttrByResult(this.getSeries(i2));
            AttrAxisPosition attrAxisPosition2 = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, this.getSeries(i2));
            if (customAttr.getRenderer() != n4 || !ComparatorUtils.equals(attrAxisPosition.getAxisPosition(), attrAxisPosition2.getAxisPosition())) continue;
            d2 += this.getDataPointPercentValue(i2, n3);
        }
        return d2;
    }

    public double getPreSum4Area(int n2, int n3) {
        return this.getPreType(n2, n3, 6) + this.getPreType(n2, n3, 5);
    }

    public double getPreSum4Bar(int n2, int n3, boolean bl) {
        AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, this.getSeries(n2));
        String string = attrAxisPosition.getAxisPosition();
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            double d4 = this.getDataPointPercentValue(i2, n3);
            CustomAttr customAttr = (CustomAttr)this.getConditionCollection().getAttrByResult(this.getSeries(i2));
            int n4 = customAttr.getRenderer();
            AttrAxisPosition attrAxisPosition2 = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, this.getSeries(n2));
            if (n4 != 3 || !ComparatorUtils.equals(string, attrAxisPosition2.getAxisPosition())) continue;
            if (d4 > 0.0) {
                d2 += d4;
                continue;
            }
            d3 += d4;
        }
        if (bl) {
            return d3;
        }
        return d2;
    }

    public int[] getDrawSequence() {
        int n2;
        int n3;
        Integer[] integerArray = new Integer[this.getSeriesSize()];
        double[] dArray = new double[this.getSeriesSize()];
        int[] nArray = new int[this.getSeriesSize()];
        double d2 = 0.0;
        double d3 = 0.0;
        for (n3 = 0; n3 < this.getSeriesSize(); ++n3) {
            integerArray[n3] = new Integer(n3);
            dArray[n3] = Double.MIN_VALUE;
            DataSeries dataSeries = this.getSeries(n3);
            CustomAttr customAttr = (CustomAttr)this.getConditionCollection().getAttrByResult(dataSeries);
            nArray[n3] = customAttr.getRenderer();
            for (n2 = 0; n2 < dataSeries.getDataPointCount(); ++n2) {
                if (dataSeries.getDataPoint(n2).isValueIsNull() || !(Math.abs(dataSeries.getDataPoint(n2).getValue()) > dArray[n3])) continue;
                dArray[n3] = Math.abs(dataSeries.getDataPoint(n2).getValue());
            }
            if ((nArray[n3] == 6 || nArray[n3] == 5) && dArray[n3] != Double.MIN_VALUE) {
                d2 += dArray[n3];
            }
            if (nArray[n3] != 3 || dArray[n3] == Double.MIN_VALUE) continue;
            d3 += dArray[n3];
        }
        this.reDealValue(nArray, dArray, d2, d3);
        this.order4LineBar(integerArray, nArray);
        n3 = -1;
        int n4 = -1;
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            if (this.isBarIndexCre(n4, n3, nArray, integerArray, i2)) {
                n3 = i2;
            }
            if (!this.isAreaIndexCre(n4, i2, nArray, integerArray)) continue;
            n4 = i2;
        }
        if (n4 < 0) {
            n4 = integerArray.length;
        }
        if (n3 < 0) {
            n3 = integerArray.length;
        }
        this.order4Area(n4, dArray, integerArray);
        this.order4Bar(n4, n3, integerArray, dArray);
        int[] nArray2 = new int[integerArray.length];
        for (n2 = 0; n2 < integerArray.length; ++n2) {
            nArray2[n2] = integerArray[n2];
        }
        return nArray2;
    }

    private void order4Area(int n2, final double[] dArray, Integer[] integerArray) {
        Arrays.sort(integerArray, 0, n2, new Comparator(){

            public int compare(Object object, Object object2) {
                Integer n2 = (Integer)object;
                Integer n3 = (Integer)object2;
                return dArray[n2] > dArray[n3] ? -1 : (dArray[n2] < dArray[n3] ? 1 : 0);
            }
        });
    }

    private void order4Bar(int n2, int n3, Integer[] integerArray, final double[] dArray) {
        Arrays.sort(integerArray, n2, n3, new Comparator(){

            public int compare(Object object, Object object2) {
                Integer n2 = (Integer)object;
                Integer n3 = (Integer)object2;
                return dArray[n2] > dArray[n3] ? -1 : (dArray[n2] < dArray[n3] ? 1 : 0);
            }
        });
    }

    private void reDealValue(int[] nArray, double[] dArray, double d2, double d3) {
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            if ((nArray[i2] == 6 || nArray[i2] == 5) && dArray[i2] != Double.MIN_VALUE) {
                dArray[i2] = d2;
            }
            if (nArray[i2] != 3 || dArray[i2] == Double.MIN_VALUE) continue;
            dArray[i2] = d3;
        }
    }

    private boolean isAreaIndexCre(int n2, int n3, int[] nArray, Integer[] integerArray) {
        return n2 < 0 && nArray[integerArray[n3]] != 5 && nArray[integerArray[n3]] != 6;
    }

    private boolean isBarIndexCre(int n2, int n3, int[] nArray, Integer[] integerArray, int n4) {
        return n2 >= 0 && n3 < 0 && nArray[integerArray[n4]] != 1 && nArray[integerArray[n4]] != 3;
    }

    private void order4LineBar(Integer[] integerArray, final int[] nArray) {
        Arrays.sort(integerArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Integer n2 = (Integer)object;
                Integer n3 = (Integer)object2;
                if (nArray[n2] == 2 || nArray[n2] == 4) {
                    return 1;
                }
                if (nArray[n3] == 2 || nArray[n3] == 4) {
                    return -1;
                }
                if (nArray[n2] == 1 || nArray[n2] == 3) {
                    return 1;
                }
                if (nArray[n3] == 1 || nArray[n3] == 3) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public boolean equals(Object object) {
        return object instanceof CustomPlotGlyph && super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        CustomPlotGlyph customPlotGlyph = (CustomPlotGlyph)super.clone();
        return customPlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.bar2DPlotGlyph != null) {
            jSONObject.put("bar2DPlotGlyph", this.bar2DPlotGlyph.toJSONObject());
        }
        if (this.bar2DPlotGlyphStack != null) {
            jSONObject.put("bar2DPlotGlyphStack", this.bar2DPlotGlyphStack.toJSONObject());
        }
        if (this.areaPlotGlyphStack != null) {
            jSONObject.put("areaPlotGlyphStack", this.areaPlotGlyphStack.toJSONObject());
        }
        if (this.linePlotGlyph != null) {
            jSONObject.put("linePlotGlyph", this.linePlotGlyph.toJSONObject());
        }
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return "CustomPlotGlyph";
    }
}

