/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.GraphHelper;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.chart.chartglyph.StockPlotGlyph;
import com.fr.chart.chartglyph.TitleGlyph;
import com.fr.stable.StringUtils;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class ChartGlyphLayout {
    private static final double DEFAULT_WIDTH = 507.0;
    private static final double DEFAULT_HEIGHT = 340.0;
    private static final double DEFAULT_GAP = 8.0;
    private static final double MIN_GAP = 4.0;
    private static final double MAX_GAP = 16.0;
    private static final double INCRE_ONE_PIX = 100.0;
    private static double WIDTH_GAP = 8.0;
    private static double HEIGHT_GAP = 8.0;
    private static double CHART_CHANGE_HEIGHT = 20.0;
    private static double ARROW_WIDTH = 10.0;
    private static double ARROW_HEIGHT = 5.0;

    public static void doLayout(ChartGlyph chartGlyph, int n2) {
        if (chartGlyph == null || chartGlyph.getBounds() == null) {
            return;
        }
        Rectangle2D rectangle2D = chartGlyph.getBounds();
        ChartGlyphLayout.preMoreChangeChart(chartGlyph, rectangle2D);
        ChartGlyphLayout.preGap4ChartBorder(chartGlyph, rectangle2D);
        ChartGlyphLayout.preGap4ChartInPadding(rectangle2D);
        ChartGlyphLayout.titleGlyphDoLayout(rectangle2D, chartGlyph.getTitleGlyph(), n2);
        ChartGlyphLayout._calculatorDataSheetCateUnitLength(rectangle2D, chartGlyph, n2);
        ChartGlyphLayout.legendDoLayoutWithLeftBounds(rectangle2D, chartGlyph, n2);
        ChartGlyphLayout.makeSureDataSheetBounds(rectangle2D, chartGlyph, n2);
        ChartGlyphLayout.plotDoLayout(rectangle2D, chartGlyph, n2);
        ChartGlyphLayout.dataSheetDoLayoutWithPlotGlyph(chartGlyph);
    }

    private static void makeSureDataSheetBounds(Rectangle2D rectangle2D, ChartGlyph chartGlyph, int n2) {
        DataSheetGlyph dataSheetGlyph = chartGlyph.getDataSheetGlyph();
        if (dataSheetGlyph == null) {
            return;
        }
        Dimension2D dimension2D = dataSheetGlyph.getPrefferedSize(chartGlyph, n2);
        double d2 = dimension2D.getHeight();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight() - d2, rectangle2D.getWidth(), d2);
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() - d2);
        dataSheetGlyph.setBounds(double_);
    }

    private static void preMoreChangeChart(ChartGlyph chartGlyph, Rectangle2D rectangle2D) {
        if (chartGlyph.isUseChangeChart()) {
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY() + CHART_CHANGE_HEIGHT, rectangle2D.getWidth(), rectangle2D.getHeight() - CHART_CHANGE_HEIGHT);
        }
    }

    private static void preGap4ChartBorder(ChartGlyph chartGlyph, Rectangle2D rectangle2D) {
        double d2 = GraphHelper.getLineStyleSize(chartGlyph.getBorderStyle());
        rectangle2D.setFrame(rectangle2D.getX() + d2, rectangle2D.getY() + d2, rectangle2D.getWidth() - d2 * 2.0, rectangle2D.getHeight() - d2 * 2.0);
    }

    private static void preGap4ChartInPadding(Rectangle2D rectangle2D) {
        WIDTH_GAP = Math.min(16.0, Math.max(4.0, 8.0 + (rectangle2D.getWidth() - 507.0) / 100.0));
        HEIGHT_GAP = Math.min(16.0, Math.max(4.0, 8.0 + (rectangle2D.getHeight() - 340.0) / 100.0));
        rectangle2D.setFrame(rectangle2D.getX() + WIDTH_GAP, rectangle2D.getY() + HEIGHT_GAP, rectangle2D.getWidth() - WIDTH_GAP * 2.0, rectangle2D.getHeight() - HEIGHT_GAP * 2.0);
    }

    private static void titleGlyphDoLayout(Rectangle2D rectangle2D, TitleGlyph titleGlyph, int n2) {
        if (titleGlyph == null || StringUtils.isEmpty(titleGlyph.getText()) || !titleGlyph.isVisible()) {
            return;
        }
        Dimension2D dimension2D = titleGlyph.preferredDimension(n2, rectangle2D.getWidth(), rectangle2D.getHeight());
        double d2 = 0.0;
        d2 = titleGlyph.getPosition() == 2 ? rectangle2D.getX() : (titleGlyph.getPosition() == 4 ? rectangle2D.getX() + rectangle2D.getWidth() - dimension2D.getWidth() : rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, rectangle2D.getY(), dimension2D.getWidth(), dimension2D.getHeight());
        titleGlyph.setBounds(ChartBaseUtils.rectangle2RoundRectangle(double_, titleGlyph.isRoundBorder()));
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY() + dimension2D.getHeight() + HEIGHT_GAP, rectangle2D.getWidth(), rectangle2D.getHeight() - dimension2D.getHeight() - HEIGHT_GAP);
    }

    private static void legendDoLayoutWithLeftBounds(Rectangle2D rectangle2D, ChartGlyph chartGlyph, int n2) {
        LegendGlyph legendGlyph = chartGlyph.getLegendGlyph();
        if (legendGlyph == null || !legendGlyph.isVisible()) {
            return;
        }
        legendGlyph.layoutLegendAndRefreshChartBounds(rectangle2D, WIDTH_GAP, HEIGHT_GAP, n2);
    }

    private static void _calculatorDataSheetCateUnitLength(Rectangle2D rectangle2D, ChartGlyph chartGlyph, int n2) {
        DataSheetGlyph dataSheetGlyph = chartGlyph.getDataSheetGlyph();
        if (dataSheetGlyph == null) {
            return;
        }
        PlotGlyph plotGlyph = chartGlyph.getPlotGlyph();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        ChartGlyphLayout.legendDoLayoutWithLeftBounds(double_, chartGlyph, n2);
        ChartGlyphLayout._justAxisDoLayout(double_, chartGlyph, n2);
        DataSheetGlyph dataSheetGlyph2 = chartGlyph.getDataSheetGlyph();
        Rectangle2D rectangle2D2 = dataSheetGlyph2.getBounds();
        if (plotGlyph != null && dataSheetGlyph2 != null) {
            int n3 = 0;
            if (plotGlyph instanceof CategoryPlotGlyph) {
                int n4 = ((CategoryPlotGlyph)plotGlyph).getxAxisGlyph().getPosition();
                if (n4 == 1 || n4 == 3) {
                    n3 = (int)((CategoryPlotGlyph)plotGlyph).getxAxisGlyph().getBounds().getWidth() / plotGlyph.getCategoryCount();
                } else {
                    int n5 = (int)((CategoryPlotGlyph)plotGlyph).getyAxisGlyph().getBounds().getX() + (int)plotGlyph.getBounds().getX();
                    n3 = (int)(rectangle2D2.getX() + rectangle2D2.getWidth() - (double)n5) / plotGlyph.getCategoryCount();
                }
            } else if (plotGlyph instanceof StockPlotGlyph) {
                n3 = (int)((StockPlotGlyph)plotGlyph).getxAxisGlyph().getUnitLen();
            }
            dataSheetGlyph2.setUnitLength(n3);
        }
    }

    private static void plotDoLayout(Rectangle2D rectangle2D, ChartGlyph chartGlyph, int n2) {
        PlotGlyph plotGlyph = chartGlyph.getPlotGlyph();
        if (plotGlyph == null) {
            return;
        }
        ChartGlyphLayout._justAxisDoLayout(rectangle2D, chartGlyph, n2);
        plotGlyph.layoutDataSeriesGlyph(n2);
        plotGlyph.setBounds(ChartBaseUtils.rectangle2RoundRectangle(plotGlyph.getBounds(), plotGlyph.isRoundBorder()));
    }

    private static void _justAxisDoLayout(Rectangle2D rectangle2D, ChartGlyph chartGlyph, int n2) {
        Cloneable cloneable;
        double d2;
        PlotGlyph plotGlyph = chartGlyph.getPlotGlyph();
        if (plotGlyph == null) {
            return;
        }
        double d3 = plotGlyph.getPreGap4AxisRightUnit();
        double d4 = plotGlyph.getPreGap4AxisTopUnit();
        double d5 = plotGlyph.getPreLeft4DataSheet(n2);
        DataSheetGlyph dataSheetGlyph = chartGlyph.getDataSheetGlyph();
        double d6 = 0.0;
        if (dataSheetGlyph != null) {
            d2 = dataSheetGlyph.getPrefferedSize(chartGlyph, n2).getWidth();
            d6 = d5 > d2 ? 0.0 : d2 - d5;
        }
        d2 = 0.0;
        double d7 = 0.0;
        if (plotGlyph instanceof RectanglePlotGlyph) {
            cloneable = (RectanglePlotGlyph)plotGlyph;
            if (cloneable.getxAxisGlyph() != null && cloneable.getxAxisGlyph().isArrowShow()) {
                d2 = ARROW_WIDTH;
            }
            if (cloneable.getyAxisGlyph() != null && cloneable.getyAxisGlyph().isArrowShow()) {
                d7 = ARROW_HEIGHT;
            }
        }
        cloneable = new Rectangle2D.Double(rectangle2D.getX() + d6, rectangle2D.getY() + d4 + d7, rectangle2D.getWidth() - d6 - d3 - d2, rectangle2D.getHeight() - d4 - d7);
        plotGlyph.setBounds((RectangularShape)cloneable);
        plotGlyph.layoutAxisGlyph(n2);
    }

    private static void dataSheetDoLayoutWithPlotGlyph(ChartGlyph chartGlyph) {
        DataSheetGlyph dataSheetGlyph = chartGlyph.getDataSheetGlyph();
        if (dataSheetGlyph != null) {
            dataSheetGlyph.doLayout(chartGlyph.getPlotGlyph());
        }
    }
}

