/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ColorInfo;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.general.ComparatorUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.apache.batik.ext.awt.RadialGradientPaint;

public class Bubble
extends SpecialGlyph {
    private static final long serialVersionUID = -6475998623025879245L;
    private Rectangle2D bounds;
    private double centerX = 0.0;
    private double centerY = 0.0;
    private double radius = 0.0;
    private ColorInfo colorInfo = new ColorInfo();

    public Bubble() {
        this(0.0, 0.0, 0.0);
    }

    public Bubble(double d2, double d3, double d4) {
        this.centerX = d2;
        this.centerY = d3;
        this.radius = d4;
        this.setBounds(new Rectangle2D.Double(d2 - d4, d3 - d4, d4 * 2.0, d4 * 2.0));
    }

    public void setCenterX(double d2) {
        this.centerX = d2;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterY(double d2) {
        this.centerY = d2;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public void setRadius(double d2) {
        this.radius = d2;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setColorInfo(ColorInfo colorInfo) {
        this.colorInfo = colorInfo;
    }

    public ColorInfo getColorInfo() {
        return this.colorInfo;
    }

    private void setBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    public void draw(Graphics graphics, int n2) {
        if (this.radius <= 1.0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Paint paint = graphics2D.getPaint();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.colorInfo.getSeriesAttrAlpha().getAlpha()));
        Color color = this.colorInfo.getSeriesAttrColor().getSeriesColor();
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint((Point2D)new Point2D.Double(this.centerX, this.centerY), (float)this.radius, new float[]{0.1f, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f}, new Color[]{new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.0f), new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.1f), new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.3f), new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.5f), new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.7f), new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.9f)});
        graphics2D.setPaint((Paint)radialGradientPaint);
        Arc2D.Double double_ = new Arc2D.Double(this.bounds, 0.0, 360.0, 0);
        graphics2D.fill(double_);
        if (this.radius >= 8.0) {
            int n3 = (int)this.bounds.getX();
            int n4 = (int)this.bounds.getY();
            int n5 = (int)this.bounds.getWidth();
            if (n5 <= 0) {
                n5 = 1;
            }
            double d2 = double_.getCenterX() - (double)n3;
            double d3 = double_.getCenterY() - (double)n4;
            double d4 = ((RectangularShape)double_).getWidth() / 2.0;
            graphics2D.translate(n3, n4);
            GeneralPath generalPath = new GeneralPath();
            float f2 = 0.0f;
            float f3 = (float)(d3 - 1.0);
            float f4 = (float)d2;
            float f5 = (float)(d3 + d4);
            float f6 = (float)(d2 + d4);
            float f7 = (float)(d3 - 1.0);
            generalPath.moveTo(f2, f3);
            generalPath.quadTo(f4, f5, f6, f7);
            RadialGradientPaint radialGradientPaint2 = new RadialGradientPaint((Point2D)new Point2D.Double(0.0, 0.0), (float)(1.5 * (double)n5 / 2.0), new float[]{0.0f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.4f), new Color(1.0f, 1.0f, 1.0f, 0.1f)});
            graphics2D.setPaint((Paint)radialGradientPaint2);
            graphics2D.fill(generalPath);
            graphics2D.fill(new Arc2D.Double(0.0, 0.0, d4 * 2.0, d4 * 2.0, 0.0, 180.0, 0));
            graphics2D.translate(-n3, -n4);
            graphics2D.setPaint(new Color(1.0f, 1.0f, 1.0f, 0.7f));
            graphics2D.rotate(-0.7853981633974483, this.centerX, this.centerY);
            graphics2D.fill(new Arc2D.Double(this.centerX - this.radius * 0.15, this.centerY - this.radius * 0.9, this.radius * 0.3, this.radius * 0.2, 0.0, 360.0, 0));
            graphics2D.rotate(0.7853981633974483, this.centerX, this.centerY);
            graphics2D.setComposite(composite);
            graphics2D.setPaint(paint);
        }
    }

    public Shape getShape() {
        return this.bounds;
    }

    public boolean equals(Object object) {
        return object instanceof Bubble && ComparatorUtils.equals(((Bubble)object).bounds, this.bounds) && ComparatorUtils.equals(((Bubble)object).colorInfo, this.colorInfo) && ((Bubble)object).centerX == this.centerX && ((Bubble)object).centerY == this.centerY && ((Bubble)object).radius == this.radius && super.equals(object);
    }
}

