/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.chartglyph.BarStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.freehep.graphicsio.swf.SWFGraphics2D;

public class BarVertical3DStyle
extends BarStyle {
    private boolean axisReversed;

    public BarVertical3DStyle(Color color, Rectangle2D rectangle2D, boolean bl, boolean bl2) {
        this.color = color;
        this.rect = rectangle2D;
        this.avoidOriginDraw = bl;
        this.axisReversed = bl2;
    }

    public void paintStyle(Graphics graphics) {
        Paint paint;
        Object object;
        if (this.rect == null || this.color == null) {
            return;
        }
        if (graphics instanceof SWFGraphics2D) {
            object = (SWFGraphics2D)graphics;
            paint = object.getPaint();
            if (this.isAvoidOriginDraw()) {
                object.setPaint((Paint)this.color);
                object.fill((Shape)this.rect);
                object.setPaint(paint);
                return;
            }
        }
        if (this.rect.getWidth() <= MIN_WIDTH || this.rect.getHeight() <= MIN_HEIGHT) {
            this.drawNormal((Graphics2D)graphics, this.rect, this.color);
        } else {
            object = (Graphics2D)graphics;
            paint = ((Graphics2D)object).getPaint();
            Stroke stroke = ((Graphics2D)object).getStroke();
            GradientPaint gradientPaint = new GradientPaint((float)this.rect.getX(), (float)this.rect.getY(), this.getShadeStartColor(), (float)(this.rect.getX() + this.rect.getWidth()), (float)this.rect.getY(), this.getShadeEndColor());
            ((Graphics2D)object).setPaint(gradientPaint);
            ((Graphics2D)object).fill(this.rect);
            ((Graphics2D)object).setPaint(this.getStrokeColor());
            ((Graphics2D)object).setStroke(new BasicStroke(1.0f));
            ((Graphics2D)object).draw(this.rect);
            ((Graphics2D)object).setPaint(this.getInnerStrokeColor());
            GeneralPath generalPath = new GeneralPath();
            if (this.axisReversed) {
                generalPath.moveTo((float)this.rect.getX() + 1.0f, (float)this.rect.getY() + 1.0f);
                generalPath.lineTo((float)this.rect.getX() + 1.0f, (float)(this.rect.getY() + this.rect.getHeight()) - 2.0f);
                generalPath.lineTo((float)(this.rect.getX() + this.rect.getWidth()) - 1.0f, (float)(this.rect.getY() + this.rect.getHeight()) - 2.0f);
            } else {
                generalPath.moveTo((float)this.rect.getX() + 1.0f, (float)(this.rect.getY() + this.rect.getHeight()) - 2.0f);
                generalPath.lineTo((float)this.rect.getX() + 1.0f, (float)this.rect.getY() + 1.0f);
                generalPath.lineTo((float)(this.rect.getX() + this.rect.getWidth()) - 1.0f, (float)this.rect.getY() + 1.0f);
            }
            ((Graphics2D)object).draw(generalPath);
            ((Graphics2D)object).setPaint(paint);
            ((Graphics2D)object).setStroke(stroke);
        }
    }
}

