/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartglyph.TopDownShadeChart;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class BarTopDownShadeStyle
extends TopDownShadeChart {
    private Rectangle2D rect;
    private boolean isHorizontal;
    private boolean axisReversed;

    public BarTopDownShadeStyle(Color color, Rectangle2D rectangle2D, boolean bl, boolean bl2, boolean bl3) {
        this.baseColor = color;
        this.rect = rectangle2D;
        this.isHorizontal = bl;
        this.avoidOriginDraw = bl2;
        this.axisReversed = bl3;
    }

    public void paintStyle(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isHorizontal) {
            this.horizontalPaint(graphics2D);
            this.horizontalDraw(graphics2D);
        } else {
            this.verticalPaint(graphics2D);
            this.verticalDraw(graphics2D);
        }
    }

    private void horizontalPaint(Graphics2D graphics2D) {
        Color color = this.getStartColor();
        Color color2 = this.getEndColor();
        GradientPaint gradientPaint = this.axisReversed ? new GradientPaint((float)this.rect.getX(), (float)this.rect.getY(), color, (float)(this.rect.getX() + this.rect.getWidth()), (float)this.rect.getY(), color2) : new GradientPaint((float)(this.rect.getX() + this.rect.getWidth()), (float)this.rect.getY(), color, (float)this.rect.getX(), (float)this.rect.getY(), color2);
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(this.rect);
        graphics2D.setPaint(paint);
    }

    private void horizontalDraw(Graphics2D graphics2D) {
        GeneralPath generalPath = this.axisReversed ? ChartUtils.getBoundsWithoutRight(this.rect) : ChartUtils.getBoundsWithoutLeft(this.rect);
        Color color = this.getLineColor();
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(color);
        graphics2D.draw(generalPath);
        graphics2D.setPaint(paint);
    }

    private void verticalPaint(Graphics2D graphics2D) {
        Color color = this.getStartColor();
        Color color2 = this.getEndColor();
        GradientPaint gradientPaint = this.axisReversed ? new GradientPaint((float)this.rect.getX(), (float)(this.rect.getY() + this.rect.getHeight()), color, (float)this.rect.getX(), (float)this.rect.getY(), color2) : new GradientPaint((float)this.rect.getX(), (float)this.rect.getY(), color, (float)this.rect.getX(), (float)(this.rect.getY() + this.rect.getHeight()), color2);
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(this.rect);
        graphics2D.setPaint(paint);
    }

    private void verticalDraw(Graphics2D graphics2D) {
        GeneralPath generalPath = this.axisReversed ? ChartUtils.getBoundsWithoutTop(this.rect) : ChartUtils.getBoundsWithoutBottom(this.rect);
        Color color = this.getLineColor();
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(color);
        graphics2D.draw(generalPath);
        graphics2D.setPaint(paint);
    }
}

