/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.background.ColorBackground;
import com.fr.chart.chartglyph.BarDataWithAxisGlyph;
import com.fr.chart.chartglyph.BarHighLightStyle;
import com.fr.chart.chartglyph.BarHorizontal3DStyle;
import com.fr.chart.chartglyph.BarHorizontalHighLightStyle;
import com.fr.chart.chartglyph.BarPlotGlyph;
import com.fr.chart.chartglyph.BarTopDownShadeStyle;
import com.fr.chart.chartglyph.BarTransparentChartStyle;
import com.fr.chart.chartglyph.BarVertical3DStyle;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.ChartStyle;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.StackedBar3DStyle;
import com.fr.chart.chartglyph.StackedBarHighLightStyle;
import com.fr.chart.chartglyph.StackedBarTopDownShadeStyle;
import com.fr.chart.chartglyph.StackedBarTransparentChartStyle;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bar2DPlotGlyph
extends BarPlotGlyph {
    private static final long serialVersionUID = -5822126857464796926L;
    private static final double LABEL_BAR_GAP = 3.0;

    @Override
    protected void resetClip(Graphics2D graphics2D) {
        if (this.getBounds() != null) {
            graphics2D.setClip(this.getBounds());
        }
    }

    @Override
    public void layoutDataSeriesGlyph(int n2) {
        int n3;
        int n4 = this.getSeriesSize();
        for (n3 = 0; n3 < n4; ++n3) {
            this.dealShape4Bar(this.getSeries(n3), this, new BarDataWithAxisGlyph(this.getxAxisGlyph(), this.getSeriesAxisGlyph(n3), this.getSeriesSize(), n3), n2);
        }
        this.dealLabelBoundsInOrder();
        if (this.plotStyle == 2) {
            n4 = this.getSeriesSize();
            for (n3 = 0; n3 < n4; ++n3) {
                DataSeries dataSeries = this.getSeries(n3);
                int n5 = dataSeries.getDataPointCount();
                for (int i2 = 0; i2 < n5; ++i2) {
                    DataPoint dataPoint = dataSeries.getDataPoint(i2);
                    if (dataPoint.getDataPointStyle() == null) continue;
                    dataPoint.getDataPointStyle().setTotalRect(this.getTotalRectWhenStacked(dataPoint.getCategoryIndex()));
                }
            }
        }
    }

    public void dealShape4Bar(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, BarDataWithAxisGlyph barDataWithAxisGlyph, int n2) {
        int n3 = 0;
        int n4 = dataSeries.getDataPointCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (dataSeries.getDataPoint(i2).isValueIsNull()) continue;
            ++n3;
        }
        this.dealShape4DataSeries(dataSeries, categoryPlotGlyph, barDataWithAxisGlyph, n3, n2);
    }

    public void setTotalRectForStackedBar(ArrayList<DataSeries> arrayList) {
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            DataSeries dataSeries = arrayList.get(i2);
            int n3 = dataSeries.getDataPointCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                DataPoint dataPoint = dataSeries.getDataPoint(i3);
                if (dataPoint.getDataPointStyle() == null) continue;
                dataPoint.getDataPointStyle().setTotalRect(this.getTotalRectWhenStacked(dataPoint.getCategoryIndex(), arrayList));
            }
        }
    }

    private Rectangle2D getTotalRectWhenStacked(int n2, ArrayList<DataSeries> arrayList) {
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        double d5 = 0.0;
        int n3 = arrayList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            DataPoint dataPoint = arrayList.get(i2).getDataPoint(n2);
            Rectangle2D.Double double_ = (Rectangle2D.Double)dataPoint.getShape();
            if (double_ == null) continue;
            d2 = Math.min(d2, double_.getX());
            d3 = Math.min(d3, double_.getY());
            if (this.isHorizontal) {
                d4 += double_.getWidth();
                d5 = double_.getHeight();
                continue;
            }
            d4 = double_.getWidth();
            d5 += double_.getHeight();
        }
        if (d4 == 0.0 || d5 == 0.0) {
            return null;
        }
        return new Rectangle2D.Double(d2, d3, d4, d5);
    }

    private boolean _isOutPlotBounds(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getBounds();
        double d2 = rectangle2D.getX();
        double d3 = d2 + rectangle2D.getWidth();
        double d4 = rectangle2D.getY();
        double d5 = d4 + rectangle2D.getHeight();
        if (d2 < 0.0 || d3 > rectangle2D2.getWidth() + 1.0) {
            return true;
        }
        return d4 < 0.0 || d5 > rectangle2D2.getHeight() + 1.0;
    }

    private void dealShape4DataSeries(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, BarDataWithAxisGlyph barDataWithAxisGlyph, int n2, int n3) {
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        int n4 = 0;
        int n5 = dataSeries.getDataPointCount();
        for (int i2 = 0; i2 < n5; ++i2) {
            DataPoint dataPoint = dataSeries.getDataPoint(i2);
            if (dataPoint.isValueIsNull()) continue;
            ShapeGlyph shapeGlyph = new ShapeGlyph();
            dataPoint.setDrawImpl(shapeGlyph);
            Rectangle2D rectangle2D = this.getBarShape(dataSeries, categoryPlotGlyph, i2, barDataWithAxisGlyph);
            if (this._isOutPlotBounds(rectangle2D)) {
                shapeGlyph.setShape(null);
                continue;
            }
            shapeGlyph.setShape(rectangle2D);
            if (this.getSeriesSize() == 1) {
                shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
                shapeGlyph.dealConditionWithSeriesColor(this.getConditionCollection(), dataPoint, this.createColors4Cate());
            } else {
                shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
            }
            double d2 = this.getDataPointPercentValue(dataSeries.getSeriesIndex(), i2);
            this.calculateFittingData(d2, dArray, dArray2, n4, rectangle2D);
            ++n4;
            this.addChartStyle4DataPoint(this.plotStyle, dataPoint, shapeGlyph, rectangle2D);
            this.dealDataPointLabel(dataPoint, n3);
        }
        if (!this.isStacked() && !this.isHorizontal) {
            this.trendLineFitting(dArray, dArray2, dataSeries);
        }
    }

    private void calculateFittingData(double d2, double[] dArray, double[] dArray2, int n2, Shape shape) {
        boolean bl;
        Rectangle2D rectangle2D = (Rectangle2D)shape;
        boolean bl2 = bl = d2 > 0.0 != this.getyAxisGlyph().hasAxisReversed();
        if (bl) {
            dArray[n2] = rectangle2D.getCenterX();
            dArray2[n2] = rectangle2D.getY();
        } else {
            dArray[n2] = rectangle2D.getCenterX();
            dArray2[n2] = rectangle2D.getY() + rectangle2D.getHeight();
        }
    }

    private void addChartStyle4DataPoint(int n2, DataPoint dataPoint, ShapeGlyph shapeGlyph, Rectangle2D rectangle2D) {
        if (shapeGlyph.getBackground() instanceof ColorBackground) {
            Color color = ((ColorBackground)shapeGlyph.getBackground()).getColor();
            ChartStyle chartStyle = null;
            boolean bl = this.getyAxisGlyph().hasAxisReversed();
            if (n2 == 1) {
                chartStyle = this.isStacked() ? new StackedBar3DStyle(color, rectangle2D, this.isHorizontal, true, bl) : (this.isHorizontal ? new BarHorizontal3DStyle(color, rectangle2D, true, bl) : new BarVertical3DStyle(color, rectangle2D, true, bl));
            } else if (n2 == 2) {
                if (this.isStacked()) {
                    chartStyle = new StackedBarHighLightStyle(color, rectangle2D, this.isHorizontal, true, bl);
                    if (dataPoint.getSeriesIndex() == this.getSeriesSize() - 1) {
                        ((StackedBarHighLightStyle)chartStyle).setIsTop(true);
                    } else if (dataPoint.getSeriesIndex() == 0) {
                        ((StackedBarHighLightStyle)chartStyle).setFirstDraw(true);
                    }
                } else {
                    chartStyle = this.isHorizontal ? new BarHorizontalHighLightStyle(color, rectangle2D, true, bl) : new BarHighLightStyle(color, rectangle2D, true, bl);
                }
            } else if (n2 == 4) {
                if (this.isStacked()) {
                    chartStyle = new StackedBarTopDownShadeStyle(color, rectangle2D, this.isHorizontal, false, bl);
                    if (dataPoint.getSeriesIndex() == this.getSeriesSize() - 1) {
                        chartStyle.setTotalRect(this.getTotalRectWhenStacked(dataPoint.getCategoryIndex()));
                    }
                } else {
                    chartStyle = new BarTopDownShadeStyle(color, rectangle2D, this.isHorizontal, true, bl);
                }
            } else if (n2 == 5) {
                if (this.isStacked()) {
                    chartStyle = new StackedBarTransparentChartStyle(color, rectangle2D, this.isHorizontal, true, bl);
                    if (dataPoint.getSeriesIndex() == this.getSeriesSize() - 1) {
                        chartStyle.setTotalRect(this.getTotalRectWhenStacked(dataPoint.getCategoryIndex()));
                    }
                } else {
                    chartStyle = new BarTransparentChartStyle(color, rectangle2D, this.isHorizontal, true, bl);
                }
            }
            if (chartStyle != null) {
                dataPoint.setDataPointStyle(chartStyle);
            }
        }
    }

    private Rectangle2D getTotalRectWhenStacked(int n2) {
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        double d5 = 0.0;
        int n3 = this.getSeriesSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            DataPoint dataPoint = this.getSeries(i2).getDataPoint(n2);
            Rectangle2D.Double double_ = (Rectangle2D.Double)dataPoint.getShape();
            if (double_ == null) continue;
            d2 = Math.min(d2, double_.getX());
            d3 = Math.min(d3, double_.getY());
            if (this.isHorizontal) {
                d4 += double_.getWidth();
                d5 = double_.getHeight();
                continue;
            }
            d4 = double_.getWidth();
            d5 += double_.getHeight();
        }
        if (d4 == 0.0 || d5 == 0.0) {
            return null;
        }
        return new Rectangle2D.Double(d2, d3, d4, d5);
    }

    @Override
    protected Rectangle2D getLabelBoundsInHorizontal(Dimension2D dimension2D, Rectangle2D rectangle2D, int n2) {
        double d2 = 0.0;
        if (!this.getyAxisGlyph().hasAxisReversed()) {
            switch (n2) {
                case 5: {
                    d2 = rectangle2D.getX() + rectangle2D.getWidth() - dimension2D.getWidth() - 3.0;
                    break;
                }
                case 6: {
                    d2 = rectangle2D.getX() + rectangle2D.getWidth() + 3.0;
                    break;
                }
                default: {
                    d2 = rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0;
                    break;
                }
            }
        } else {
            switch (n2) {
                case 5: {
                    d2 = rectangle2D.getX() + 3.0;
                    break;
                }
                case 6: {
                    d2 = rectangle2D.getX() - dimension2D.getWidth() - 3.0;
                    break;
                }
                default: {
                    d2 = rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0;
                }
            }
        }
        return new Rectangle2D.Double(d2, rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
    }

    @Override
    protected Rectangle2D getLabelBoundsInVertical(Dimension2D dimension2D, Rectangle2D rectangle2D, int n2) {
        double d2 = 0.0;
        if (!this.getyAxisGlyph().hasAxisReversed()) {
            switch (n2) {
                case 5: {
                    d2 = rectangle2D.getY() + 3.0;
                    break;
                }
                case 6: {
                    d2 = rectangle2D.getY() - dimension2D.getHeight() - 3.0;
                    break;
                }
                default: {
                    d2 = rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0;
                    break;
                }
            }
        } else {
            switch (n2) {
                case 5: {
                    d2 = rectangle2D.getY() + rectangle2D.getHeight() - 3.0 - dimension2D.getHeight();
                    break;
                }
                case 6: {
                    d2 = rectangle2D.getY() + rectangle2D.getHeight() + 3.0;
                    break;
                }
                default: {
                    d2 = rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0;
                }
            }
        }
        return new Rectangle2D.Double(rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0, d2, dimension2D.getWidth(), dimension2D.getHeight());
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Bar2DPlotGlyph && super.equals(object);
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        return jSONObject;
    }

    @Override
    public String getPlotGlyphType() {
        return "Bar2DPlotGlyph";
    }
}

