/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.FRContext;
import com.fr.base.TableData;
import com.fr.base.chartdata.BaseTableDefinition;
import com.fr.base.chartdata.ChartData;
import com.fr.base.chartdata.TopDefinition;
import com.fr.chart.chartdata.TopChartData;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.data.TableDataException;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public abstract class TableDataDefinition
extends TopDefinition
implements BaseTableDefinition {
    private static final long serialVersionUID = 6650119421972084763L;
    private TableData tableData;

    public void setTableData(TableData tableData) {
        this.tableData = tableData;
    }

    public TableData getTableData() {
        return this.tableData;
    }

    public abstract ChartData createChartData(DataModel var1);

    public String[] getDependence(Calculator calculator) {
        if (this.getTableData() == null) {
            return new String[0];
        }
        ParameterProvider[] parameterProviderArray = this.getTableData().getParameters(calculator);
        if (parameterProviderArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[parameterProviderArray.length];
        for (int i2 = 0; i2 < parameterProviderArray.length; ++i2) {
            stringArray[i2] = parameterProviderArray[i2].getName().startsWith("$") ? parameterProviderArray[i2].getName() : "$" + parameterProviderArray[i2].getName();
        }
        return stringArray;
    }

    public ChartData calcu4ChartData(Calculator calculator) {
        ChartData chartData = null;
        try {
            TableDataDefinition tableDataDefinition = (TableDataDefinition)this.clone();
            if (tableDataDefinition != null) {
                if (tableDataDefinition.getTableData() != null) {
                    DataModel dataModel = tableDataDefinition.getTableData().createDataModel(calculator);
                    if (dataModel == DataModel.EMPTY_DATAMODEL) {
                        throw new TableDataException(Inter.getLocText("Chart_Table_Data_Not_Found") + "!");
                    }
                    chartData = tableDataDefinition.createChartData(dataModel);
                }
                if (chartData != null) {
                    chartData = tableDataDefinition.createTopChartData((TopChartData)chartData, calculator);
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().errorWithServerLevel(exception.getMessage(), exception);
        }
        return chartData;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.tableData != null) {
            DataCoreXmlUtils.writeXMLTableData(xMLPrintWriter, this.tableData);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        TableData tableData;
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "TableData".equals(string = xMLableReader.getTagName()) && (tableData = DataCoreXmlUtils.readXMLTableData(xMLableReader)) != null) {
            this.setTableData(tableData);
        }
    }

    public void modDefinitionFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
    }

    public boolean equals(Object object) {
        return object instanceof TableDataDefinition && ComparatorUtils.equals(((TableDataDefinition)object).tableData, this.tableData) && super.equals(object);
    }
}

