/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.BaseUtils;
import com.fr.base.Utils;
import com.fr.chart.chartdata.TableDataDefinition;
import com.fr.data.core.DataCoreUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class NormalTableDataDefinition
extends TableDataDefinition {
    private static final long serialVersionUID = -1211079023903447407L;
    protected transient int firstLabelCol;
    protected transient int secondCol;
    protected transient int thirdCol;
    protected transient Object[] categoryLabels;
    protected transient Object[] secondLabels;
    protected transient Object[] thirdLabels;
    private String categoryName;
    private ArrayList moreCateLabels = new ArrayList();

    protected int add2ColumnListWithName(DataModel dataModel, List list, String string) throws TableDataException {
        int n2 = DataCoreUtils.getColumnIndexByName(dataModel, string);
        if (n2 != -1) {
            list.addAll(Arrays.asList(BaseUtils.getDistinctValues(dataModel, n2)));
        } else {
            list.add(string);
        }
        return n2;
    }

    protected void initAllCateLabels(DataModel dataModel) throws TableDataException {
        int n2;
        int n3;
        ArrayList arrayList = new ArrayList();
        this.firstLabelCol = this.add2ColumnListWithName(dataModel, arrayList, this.getCategoryName());
        Object[] objectArray = arrayList.toArray();
        ArrayList arrayList2 = new ArrayList();
        if (this.getMoreCateWithIndex(0) != null) {
            this.secondCol = this.add2ColumnListWithName(dataModel, arrayList2, Utils.objectToString(this.getMoreCateWithIndex(0)));
        }
        this.secondLabels = arrayList2.toArray(new Object[arrayList2.size()]);
        ArrayList arrayList3 = new ArrayList();
        if (this.getMoreCateWithIndex(1) != null) {
            this.thirdCol = this.add2ColumnListWithName(dataModel, arrayList3, Utils.objectToString(this.getMoreCateWithIndex(1)));
        }
        this.thirdLabels = arrayList3.toArray(new Object[arrayList3.size()]);
        int n4 = objectArray.length;
        int n5 = n3 = this.secondLabels != null ? this.secondLabels.length : 1;
        if (n3 > 0) {
            n4 *= n3;
        }
        int n6 = n2 = this.thirdLabels != null ? this.thirdLabels.length : 1;
        if (n2 > 0) {
            n4 *= n2;
        }
        this.categoryLabels = new Object[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            this.categoryLabels[i2] = objectArray[i2 % objectArray.length];
        }
    }

    protected int getCategoryIndex(DataModel dataModel, int n2) throws TableDataException {
        int n3;
        Object object = dataModel.getValueAt(n2, this.firstLabelCol);
        int n4 = this.check4IndexInObjects(object, this.categoryLabels);
        Object object2 = dataModel.getValueAt(n2, this.secondCol);
        int n5 = this.check4IndexInObjects(object2, this.secondLabels);
        Object object3 = dataModel.getValueAt(n2, this.thirdCol);
        int n6 = this.check4IndexInObjects(object3, this.thirdLabels);
        int n7 = this.categoryLabels == null ? 1 : this.categoryLabels.length;
        int n8 = this.secondLabels == null ? 1 : this.secondLabels.length;
        int n9 = n3 = this.thirdLabels == null ? 1 : this.thirdLabels.length;
        if (n3 > 0 && n8 > 0) {
            return n4 + n5 * n7 / (n3 * n8) + n6 * n7 / n3;
        }
        if (n8 > 0) {
            return n4 + n5 * n7 / n8;
        }
        return n4;
    }

    private int check4IndexInObjects(Object object, Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!ComparatorUtils.equals(object, objectArray[i2])) continue;
            return i2;
        }
        return 0;
    }

    protected Object[] getMoreLabelWithIndex(DataModel dataModel, int n2) throws TableDataException {
        int n3 = this.getMoreCateSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            ArrayList arrayList = new ArrayList();
            this.add2ColumnListWithName(dataModel, arrayList, Utils.objectToString(this.getMoreCateWithIndex(i2)));
            if (i2 != n2) continue;
            return arrayList.toArray(new Object[arrayList.size()]);
        }
        return new Object[0];
    }

    public void setCategoryName(String string) {
        this.categoryName = string;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void addMoreCate(String string) {
        this.moreCateLabels.add(string);
    }

    public int getMoreCateSize() {
        return this.moreCateLabels.size();
    }

    public Object getMoreCateWithIndex(int n2) {
        return n2 < this.moreCateLabels.size() ? this.moreCateLabels.get(n2) : null;
    }

    public void clearMoreCate() {
        this.moreCateLabels.clear();
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.getCategoryName() != null) {
            xMLPrintWriter.startTAG("CategoryName").attr("value", this.getCategoryName()).end();
        }
        if (!this.moreCateLabels.isEmpty()) {
            xMLPrintWriter.startTAG("TableMoreCate");
            int n2 = this.moreCateLabels.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                xMLPrintWriter.startTAG("oneMoreCate");
                xMLPrintWriter.attr("cateName", Utils.objectToString(this.moreCateLabels.get(i2)));
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals("CategoryName", string)) {
                String string2 = xMLableReader.getAttrAsString("value", null);
                if (string2 != null) {
                    this.setCategoryName(string2);
                }
            } else if (ComparatorUtils.equals("TableMoreCate", string)) {
                this.clearMoreCate();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (ComparatorUtils.equals("oneMoreCate", xMLableReader.getTagName())) {
                            String string = xMLableReader.getAttrAsString("cateName", "");
                            NormalTableDataDefinition.this.addMoreCate(string);
                        }
                    }
                });
            }
        }
    }

    public boolean equals(Object object) {
        return object instanceof NormalTableDataDefinition && ComparatorUtils.equals(((NormalTableDataDefinition)object).categoryName, this.categoryName) && ComparatorUtils.equals(((NormalTableDataDefinition)object).moreCateLabels, this.moreCateLabels) && super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        NormalTableDataDefinition normalTableDataDefinition = (NormalTableDataDefinition)super.clone();
        normalTableDataDefinition.moreCateLabels = (ArrayList)this.moreCateLabels.clone();
        return normalTableDataDefinition;
    }
}

