/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.Utils;
import com.fr.base.chartdata.ChartData;
import com.fr.chart.chartdata.MapAreaValue;
import com.fr.chart.chartdata.MapChartData;
import com.fr.chart.chartdata.MapTitleValue;
import com.fr.chart.chartdata.SeriesDefinition;
import com.fr.chart.chartdata.TableDataDefinition;
import com.fr.data.core.DataCoreUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.List;

public class MapSingleLayerTableDefinition
extends TableDataDefinition {
    public static final String XML_TAG = "MapSingleLayerTableDefinition";
    private static final long serialVersionUID = -8537307090949351871L;
    private String areaName;
    private List list = new ArrayList();

    public ChartData createChartData(DataModel dataModel) {
        MapChartData mapChartData = new MapChartData();
        this.createMapDataWithLayerIndex(mapChartData, dataModel);
        return mapChartData;
    }

    public void createMapDataWithLayerIndex(MapChartData mapChartData, DataModel dataModel) {
        int n2 = this.list.size();
        if (StringUtils.isNotEmpty(this.getAreaName()) && n2 > 0) {
            try {
                int n3 = dataModel.getRowCount();
                int n4 = DataCoreUtils.getColumnIndexByName(dataModel, this.getAreaName());
                if (n4 != -1) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        Object object = dataModel.getValueAt(i2, n4);
                        if (object == null || !StringUtils.isNotEmpty(Utils.objectToString(object))) continue;
                        MapAreaValue mapAreaValue = new MapAreaValue();
                        mapChartData.addMapData(Utils.objectToString(object), mapAreaValue);
                        for (int i3 = 0; i3 < n2; ++i3) {
                            SeriesDefinition seriesDefinition = (SeriesDefinition)this.list.get(i3);
                            if (seriesDefinition == null || seriesDefinition.getValue() == null) continue;
                            String string = Utils.objectToString(seriesDefinition.getSeriesName());
                            String string2 = Utils.objectToString(seriesDefinition.getValue());
                            int n5 = DataCoreUtils.getColumnIndexByName(dataModel, string2);
                            if (n5 == -1) continue;
                            Object object2 = dataModel.getValueAt(i2, n5);
                            Number number = Utils.objectToNumber(object2, false);
                            mapAreaValue.addTitleValue(new MapTitleValue(string, number.doubleValue()));
                        }
                    }
                }
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error("Some error In Map Table Data");
            }
        }
    }

    public void setAreaName(String string) {
        this.areaName = string;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public void addTitleValue(SeriesDefinition seriesDefinition) {
        this.list.add(seriesDefinition);
    }

    public void clearTitleValue() {
        this.list.clear();
    }

    public int getTitleValueSize() {
        return this.list.size();
    }

    public SeriesDefinition getTitleValueWithIndex(int n2) {
        if (n2 >= 0 && n2 < this.list.size()) {
            return (SeriesDefinition)this.list.get(n2);
        }
        return null;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("AreaName");
        xMLPrintWriter.attr("areaName", this.getAreaName());
        xMLPrintWriter.end();
        int n2 = this.list.size();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                xMLPrintWriter.startTAG("DefinitionList");
                SeriesDefinition seriesDefinition = (SeriesDefinition)this.list.get(i2);
                seriesDefinition.writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals("AreaName", string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        MapSingleLayerTableDefinition.this.setAreaName(xMLableReader.getAttrAsString("areaName", ""));
                    }
                });
            } else if (ComparatorUtils.equals("DefinitionList", string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        SeriesDefinition seriesDefinition = (SeriesDefinition)xMLableReader.readXMLObject(new SeriesDefinition());
                        MapSingleLayerTableDefinition.this.addTitleValue(seriesDefinition);
                    }
                });
            } else if (ComparatorUtils.equals("SeriesDefinition", string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        SeriesDefinition seriesDefinition = (SeriesDefinition)xMLableReader.readXMLObject(new SeriesDefinition());
                        MapSingleLayerTableDefinition.this.setAreaName(Utils.objectToString(seriesDefinition.getSeriesName()));
                        seriesDefinition.setSeriesName(Inter.getLocText("Value"));
                        MapSingleLayerTableDefinition.this.addTitleValue(seriesDefinition);
                    }
                });
            }
        }
    }
}

