/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.background.ColorBackground;
import com.fr.base.chartdata.ChartData;
import com.fr.chart.base.AttrAxisPosition;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.AttrMarkerType;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartattr.AreaPlot;
import com.fr.chart.chartattr.Bar2DPlot;
import com.fr.chart.chartattr.CategoryAxis;
import com.fr.chart.chartattr.CategoryPlot;
import com.fr.chart.chartattr.ChartFactory;
import com.fr.chart.chartattr.ChartXMLCompatibleUtils;
import com.fr.chart.chartattr.LinePlot;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.ValueAxis;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.AreaPlotGlyph;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.Bar2DPlotGlyph;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.CustomAttr;
import com.fr.chart.chartglyph.CustomPlotGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSeries4Area;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.LinePlotGlyph;
import com.fr.chart.chartglyph.Marker;
import com.fr.chart.chartglyph.MarkerFactory;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class CustomPlot
extends CategoryPlot {
    private static final long serialVersionUID = 4202124515267193546L;
    private static final double DEFAULT_SEREIS_GAP = -0.15;
    private static final double MARKER_SIZE = 0.6;
    private static final String[] CUSTOM_SERIES = new String[]{"Rect", "Line"};
    private static final String[][] CUSTOM_VALUES = new String[][]{{"4", "7", "6", "8", "9.5", "9"}, {"5", "8", "7", "9", "9.7", "9.5"}};
    private Bar2DPlot bar2DPlot = new Bar2DPlot();
    private Bar2DPlot bar2DPlotStack = new Bar2DPlot(true);
    private LinePlot linePlot = new LinePlot();
    private AreaPlot areaPlotStack = new AreaPlot();
    private transient double pointMaxMinValue;
    private transient double lineStackMaxMinValue;
    private transient double barStackMaxMinValue;
    private transient double areaStackMaxMinValue;

    public CustomPlot() {
        this.setxAxis(new CategoryAxis(3));
        this.setyAxis(new ValueAxis(2));
        this.setSecondAxis(new ValueAxis(4));
        this.getConditionCollection().setDefaultAttr(new CustomAttr());
    }

    public boolean isSupportZoomCategoryAxis() {
        return true;
    }

    public void setBar2DPlot(Bar2DPlot bar2DPlot) {
        this.bar2DPlot = bar2DPlot;
    }

    public Bar2DPlot getBar2DPlot() {
        return this.bar2DPlot;
    }

    public void setBar2DPlotStack(Bar2DPlot bar2DPlot) {
        this.bar2DPlotStack = bar2DPlot;
    }

    public Bar2DPlot getBar2DPlotStack() {
        return this.bar2DPlotStack;
    }

    public void setLinePlot(LinePlot linePlot) {
        this.linePlot = linePlot;
    }

    public LinePlot getLinePlot() {
        return this.linePlot;
    }

    public void setAreaPlotStack(AreaPlot areaPlot) {
        this.areaPlotStack = areaPlot;
    }

    public AreaPlot getAreaPlotStack() {
        return this.areaPlotStack;
    }

    public boolean isSupportDataLabelAttr() {
        return false;
    }

    public String getPlotName() {
        String string = Inter.getLocText("ChartF-Comb_Chart");
        if (this.getDataSheet().isVisible() && this.getDataSheet().isVisible()) {
            string = Inter.getLocText(new String[]{"Data", "Table"}) + string;
        }
        return string;
    }

    public String[] getAlertLinePaneTitle() {
        return new String[]{"Main_Value_Axis", "Second_Value_Axis"};
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        CustomPlotGlyph customPlotGlyph = new CustomPlotGlyph();
        this.install4PlotGlyph(customPlotGlyph, chartData);
        this.installAxisGlyph(customPlotGlyph, chartData);
        return customPlotGlyph;
    }

    protected DataSeries createDataSeries(int n2) {
        CustomAttr customAttr = (CustomAttr)this.getConditionCollection().getAttrBySeriesIndex(n2);
        if (customAttr.getRenderer() == 5 || 6 == customAttr.getRenderer()) {
            return new DataSeries4Area(n2);
        }
        return new DataSeries(n2);
    }

    public void install4PlotGlyph(CustomPlotGlyph customPlotGlyph, ChartData chartData) {
        this.addCondition4EveryTypeInCustom(this.bar2DPlot);
        this.addCondition4EveryTypeInCustom(this.bar2DPlotStack);
        this.addCondition4EveryTypeInCustom(this.linePlot);
        this.addCondition4EveryTypeInCustom(this.areaPlotStack);
        super.install4PlotGlyph(customPlotGlyph, chartData);
        Bar2DPlotGlyph bar2DPlotGlyph = (Bar2DPlotGlyph)this.bar2DPlot.createPlotGlyph(chartData);
        bar2DPlotGlyph.setPlotFillStyle(this.getPlotFillStyle());
        bar2DPlotGlyph.setPlotStyle(this.getPlotStyle());
        customPlotGlyph.setBar2DPlotGlyph(bar2DPlotGlyph);
        Bar2DPlotGlyph bar2DPlotGlyph2 = (Bar2DPlotGlyph)this.bar2DPlotStack.createPlotGlyph(chartData);
        bar2DPlotGlyph2.setPlotFillStyle(this.getPlotFillStyle());
        bar2DPlotGlyph2.setSeriesOverlapPercent(1.0);
        bar2DPlotGlyph2.setPlotStyle(this.getPlotStyle());
        customPlotGlyph.setBar2DPlotGlyphStack(bar2DPlotGlyph2);
        LinePlotGlyph linePlotGlyph = (LinePlotGlyph)this.linePlot.createPlotGlyph(chartData);
        linePlotGlyph.setPlotFillStyle(this.getPlotFillStyle());
        customPlotGlyph.setLinePlotGlyph(linePlotGlyph);
        AreaPlotGlyph areaPlotGlyph = (AreaPlotGlyph)this.areaPlotStack.createPlotGlyph(chartData);
        areaPlotGlyph.setPlotFillStyle(this.getPlotFillStyle());
        customPlotGlyph.setAreaPlotGlyphStack(areaPlotGlyph);
    }

    private void addCondition4EveryTypeInCustom(Plot plot) {
        ConditionCollection conditionCollection = this.getConditionCollection();
        ConditionCollection conditionCollection2 = plot.getConditionCollection();
        conditionCollection2.clearConditionAttr();
        for (int i2 = 0; i2 < conditionCollection.getConditionAttrSize(); ++i2) {
            conditionCollection2.addConditionAttr(conditionCollection.getConditionAttr(i2));
        }
    }

    protected ConditionCollection getSeriesIndexConditionCollection(int n2) {
        CustomAttr customAttr = (CustomAttr)this.getConditionCollection().getAttrBySeriesIndex(n2);
        int n3 = customAttr.getRenderer();
        if (n3 == 1) {
            return this.bar2DPlot.getConditionCollection();
        }
        if (n3 == 3) {
            return this.bar2DPlotStack.getConditionCollection();
        }
        if (n3 == 6 || n3 == 5) {
            return this.areaPlotStack.getConditionCollection();
        }
        if (n3 == 2 || n3 == 4) {
            return this.linePlot.getConditionCollection();
        }
        return this.getConditionCollection();
    }

    private void installAxisGlyph(CustomPlotGlyph customPlotGlyph, ChartData chartData) {
        AxisGlyph axisGlyph = this.getxAxis().createAxisGlyph(chartData);
        customPlotGlyph.setxAxisGlyph(axisGlyph);
        axisGlyph.setAxisType("xAxis");
        axisGlyph.setDrawBetweenTick(true);
        AxisGlyph axisGlyph2 = this.getyAxis().createAxisGlyph(chartData);
        customPlotGlyph.setyAxisGlyph(axisGlyph2);
        axisGlyph2.setAxisType("yAxis");
        axisGlyph2.initMinMaxValue(this.getAxisMinValueFromData(chartData, "LEFT", axisGlyph2.isLog(), customPlotGlyph), this.getAxisMaxValueFromData(chartData, "LEFT", customPlotGlyph));
        if (this.isUseSecondAxis()) {
            AxisGlyph axisGlyph3 = this.getSecondAxis().createAxisGlyph(chartData);
            customPlotGlyph.setSecondAxisGlyph(axisGlyph3);
            axisGlyph3.setAxisType("secondAxis");
            axisGlyph3.initMinMaxValue(this.getAxisMinValueFromData(chartData, "RIGHT", axisGlyph3.isLog(), customPlotGlyph), this.getAxisMaxValueFromData(chartData, "RIGHT", customPlotGlyph));
        }
        customPlotGlyph.axisExtendsMaxMinValueWithTrendLine(customPlotGlyph.getxAxisGlyph());
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof CustomPlot;
    }

    private double getAxisMinValueFromData(ChartData chartData, String string, boolean bl, RectanglePlotGlyph rectanglePlotGlyph) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d2 = 0.0;
        double d3 = 0.0;
        if (bl) {
            d2 = Double.MAX_VALUE;
            d3 = 1.0;
        }
        for (int i2 = 0; i2 < normalChartData.getCategoryLabelCount(); ++i2) {
            this.resteValue(bl);
            for (int i3 = 0; i3 < normalChartData.getSeriesCount(); ++i3) {
                if (normalChartData.getValueAt(i3, i2) == null) continue;
                double d4 = normalChartData.getValueAt(i3, i2).doubleValue();
                CustomAttr customAttr = (CustomAttr)this.getConditionCollection().getAttrBySeriesIndex(i3);
                DataPoint dataPoint = rectanglePlotGlyph.getSeries(i3).getDataPoint(i2);
                if (!this.isInCategoryField(rectanglePlotGlyph.getxAxisGlyph(), dataPoint.getCategoryName())) continue;
                AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, dataPoint, ChartConstants.NULL_COLORS);
                if (!(d4 < d3) || !ComparatorUtils.equals(attrAxisPosition.getAxisPosition(), string)) continue;
                this.addValueInRender(customAttr.getRenderer(), false, d4);
                d2 = bl && d4 < d3 && d2 > d4 ? d4 : d2;
            }
            if (bl) continue;
            d2 = Math.min(d2, Math.min(Math.min(this.lineStackMaxMinValue, this.barStackMaxMinValue), Math.min(this.areaStackMaxMinValue, this.pointMaxMinValue)));
        }
        if (d2 == Double.MAX_VALUE) {
            return 1.0;
        }
        return d2;
    }

    private double getAxisMaxValueFromData(ChartData chartData, String string, RectanglePlotGlyph rectanglePlotGlyph) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d2 = 0.0;
        for (int i2 = 0; i2 < normalChartData.getCategoryLabelCount(); ++i2) {
            this.resteValue(false);
            for (int i3 = 0; i3 < normalChartData.getSeriesCount(); ++i3) {
                if (normalChartData.getValueAt(i3, i2) == null) continue;
                double d3 = normalChartData.getValueAt(i3, i2).doubleValue();
                CustomAttr customAttr = (CustomAttr)this.getConditionCollection().getAttrBySeriesIndex(i3);
                DataPoint dataPoint = rectanglePlotGlyph.getSeries(i3).getDataPoint(i2);
                if (!this.isInCategoryField(rectanglePlotGlyph.getxAxisGlyph(), dataPoint.getCategoryName())) continue;
                AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, dataPoint, ChartConstants.NULL_COLORS);
                if (!(d3 >= 0.0) || !ComparatorUtils.equals(attrAxisPosition.getAxisPosition(), string)) continue;
                this.addValueInRender(customAttr.getRenderer(), true, d3);
            }
            d2 = Math.max(d2, Math.max(Math.max(this.lineStackMaxMinValue, this.barStackMaxMinValue), Math.max(this.areaStackMaxMinValue, this.pointMaxMinValue)));
        }
        if (d2 == this.getAxisMinValueFromData(normalChartData, string, false, rectanglePlotGlyph)) {
            return d2 + 10.0;
        }
        return d2;
    }

    private void addValueInRender(int n2, boolean bl, double d2) {
        if (n2 == 5) {
            this.lineStackMaxMinValue += d2;
        } else if (n2 == 3) {
            this.barStackMaxMinValue += d2;
        } else if (n2 == 6 || n2 == 5) {
            this.areaStackMaxMinValue += d2;
        } else {
            this.pointMaxMinValue = bl ? Math.max(this.pointMaxMinValue, d2) : Math.min(this.pointMaxMinValue, d2);
        }
    }

    private void resteValue(boolean bl) {
        this.pointMaxMinValue = 0.0;
        this.lineStackMaxMinValue = 0.0;
        this.barStackMaxMinValue = 0.0;
        this.areaStackMaxMinValue = 0.0;
        if (bl) {
            this.pointMaxMinValue = 1.0;
        }
    }

    protected LineMarkerIcon getLegendMarkerIcon(DataSeries dataSeries, Color[] colorArray) {
        LineMarkerIcon lineMarkerIcon = new LineMarkerIcon();
        CustomAttr customAttr = (CustomAttr)this.getConditionCollection().getAttrByResult(dataSeries);
        if (customAttr.getRenderer() == 2 || customAttr.getRenderer() == 4) {
            AttrColor attrColor = (AttrColor)this.getConditionCollection().getDataSeriesCondition(AttrColor.class, dataSeries, colorArray);
            AttrLineStyle attrLineStyle = (AttrLineStyle)this.getConditionCollection().getDataSeriesCondition(AttrLineStyle.class, dataSeries, colorArray);
            lineMarkerIcon.setLineStyle(attrLineStyle.getLineStyle());
            lineMarkerIcon.setBackground(ColorBackground.getInstance(attrColor.getSeriesColor()));
            AttrMarkerType attrMarkerType = (AttrMarkerType)this.getConditionCollection().getDataSeriesCondition(AttrMarkerType.class, dataSeries, colorArray);
            Marker marker = MarkerFactory.createMarker(attrMarkerType.getMarkerType());
            marker.setSize(marker.getSize() * 0.6);
            marker.setBackground(ColorBackground.getInstance(attrColor.getSeriesColor()));
            lineMarkerIcon.setMarker(marker);
        }
        this.dealCondition(lineMarkerIcon, dataSeries, colorArray);
        return lineMarkerIcon;
    }

    public void clearConditionAttrAndRenewLegend(Plot plot) {
        super.clearConditionAttrAndRenewLegend(plot);
        ChartFactory.createSeriesMap4CustomPlot(this);
    }

    public ChartData defaultChartData() {
        CategoryAxis categoryAxis = (CategoryAxis)this.getxAxis();
        return categoryAxis.isDate() ? new NormalChartData(ChartUtils.LONG_CATEGORY_DATE, CUSTOM_SERIES, CUSTOM_VALUES) : new NormalChartData(ChartUtils.LONG_CATEGORY_STRING, CUSTOM_SERIES, CUSTOM_VALUES);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            this.comXML(xMLableReader);
        }
    }

    private void comXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (ComparatorUtils.equals(string, "CustomLine")) {
            xMLableReader.readXMLObject(new LinePlot());
        } else if (ComparatorUtils.equals(string, "CustomAreaStack")) {
            xMLableReader.readXMLObject(new AreaPlot());
        } else if (ComparatorUtils.equals(string, "CustomBar")) {
            xMLableReader.readXMLObject(new Bar2DPlot());
        } else if (ComparatorUtils.equals(string, "CustomBarStack")) {
            xMLableReader.readXMLObject(new Bar2DPlot());
        } else if (ComparatorUtils.equals(string, "CustomLineStack")) {
            xMLableReader.readXMLObject(new AreaPlot());
        } else if (ComparatorUtils.equals(string, "CustomArea")) {
            xMLableReader.readXMLObject(new LinePlot());
        } else if (ComparatorUtils.equals(string, "Attr")) {
            if (!xMLableReader.getAttrAsBoolean("isShowLine", true)) {
                ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), true);
            }
            if (!xMLableReader.getAttrAsBoolean("isShowMarker", true)) {
                ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), false);
            }
            this.getLinePlot().setNullValueBreak(xMLableReader.getAttrAsBoolean("isLineNullValueBreak", true));
            this.getBar2DPlot().setCategoryIntervalPercent(xMLableReader.getAttrAsDouble("categoryIntervalPercent", 1.0));
            this.getBar2DPlot().setSeriesOverlapPercent(xMLableReader.getAttrAsDouble("seriesOverlapPercent", -0.15));
            this.getBar2DPlot().setSimulation3D(xMLableReader.getAttrAsBoolean("isSimulation3D", true));
            if (!xMLableReader.getAttrAsBoolean("isShowLine_stack", true)) {
                ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), true);
            }
            if (!xMLableReader.getAttrAsBoolean("isShowMarker_stack", true)) {
                ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), false);
            }
            this.getBar2DPlotStack().setSimulation3D(xMLableReader.getAttrAsBoolean("isSimulation3D_stack", true));
            this.getBar2DPlotStack().setCategoryIntervalPercent(xMLableReader.getAttrAsDouble("categoryIntervalPercent_stack", 1.0));
            this.getBar2DPlotStack().setSeriesOverlapPercent(xMLableReader.getAttrAsDouble("seriesOverlapPercent_stack", 1.0));
            this.getAreaPlotStack().setCurve(xMLableReader.getAttrAsBoolean("isCurveAreaStack", false));
            this.getLinePlot().setCurve(xMLableReader.getAttrAsBoolean("isCurveLine", false));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CategoryPlot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof CustomPlot && super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        CustomPlot customPlot = (CustomPlot)super.clone();
        if (this.linePlot != null) {
            customPlot.linePlot = (LinePlot)this.linePlot.clone();
        }
        if (this.areaPlotStack != null) {
            customPlot.areaPlotStack = (AreaPlot)this.areaPlotStack.clone();
        }
        if (this.bar2DPlot != null) {
            customPlot.bar2DPlot = (Bar2DPlot)this.bar2DPlot.clone();
        }
        if (this.bar2DPlotStack != null) {
            customPlot.bar2DPlotStack = (Bar2DPlot)this.bar2DPlotStack.clone();
        }
        return customPlot;
    }
}

