/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.CoreDecimalFormat;
import com.fr.base.FRContext;
import com.fr.base.TemplateUtils;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrAxisPosition;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.AttrMarkerType;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.base.ChartInternationnalNameContentBean;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartattr.Area3DPlot;
import com.fr.chart.chartattr.AreaPlot;
import com.fr.chart.chartattr.Axis;
import com.fr.chart.chartattr.Bar2DPlot;
import com.fr.chart.chartattr.Bar3DPlot;
import com.fr.chart.chartattr.BubblePlot;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.ChartXMLCompatibleUtils;
import com.fr.chart.chartattr.CustomPlot;
import com.fr.chart.chartattr.Donut2DPlot;
import com.fr.chart.chartattr.Donut3DPlot;
import com.fr.chart.chartattr.GanttPlot;
import com.fr.chart.chartattr.GisMapPlot;
import com.fr.chart.chartattr.LinePlot;
import com.fr.chart.chartattr.MapPlot;
import com.fr.chart.chartattr.MeterCustomPlot;
import com.fr.chart.chartattr.MeterPlot;
import com.fr.chart.chartattr.Pie3DPlot;
import com.fr.chart.chartattr.PiePlot;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.RadarPlot;
import com.fr.chart.chartattr.RangePlot;
import com.fr.chart.chartattr.StockPlot;
import com.fr.chart.chartattr.XYScatterPlot;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.CustomAttr;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.ListCondition;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Locale;

public abstract class ChartFactory {
    private static final double DEFAULT_OVER_GAP = -0.5;
    public static ChartInternationnalNameContentBean[] allChartBaseNames = new ChartInternationnalNameContentBean[]{new ChartInternationnalNameContentBean("ChartF-Column", 0), new ChartInternationnalNameContentBean("ChartF-Line", 1), new ChartInternationnalNameContentBean("ChartF-Bar", 2), new ChartInternationnalNameContentBean("ChartF-Pie", 3), new ChartInternationnalNameContentBean("ChartF-Area", 4), new ChartInternationnalNameContentBean("ChartF-XYScatter", 5), new ChartInternationnalNameContentBean("Chart_BubbleChart", 6), new ChartInternationnalNameContentBean("ChartF-Radar", 7), new ChartInternationnalNameContentBean("ChartF-Stock", 8), new ChartInternationnalNameContentBean("ChartF-Meter", 9), new ChartInternationnalNameContentBean("ChartF-Range_Chart", 10), new ChartInternationnalNameContentBean("ChartF-Comb_Chart", 11), new ChartInternationnalNameContentBean("Chart-Map", 12), new ChartInternationnalNameContentBean("ChartF-Gantt", 13), new ChartInternationnalNameContentBean("ChartF-Gis", 14), new ChartInternationnalNameContentBean("ChartF-Donut", 15)};
    public static ChartInternationnalNameContentBean[] gridBIChartBaseNames = new ChartInternationnalNameContentBean[]{new ChartInternationnalNameContentBean("ChartF-Column", 0), new ChartInternationnalNameContentBean("ChartF-Line", 1), new ChartInternationnalNameContentBean("ChartF-Bar", 2), new ChartInternationnalNameContentBean("ChartF-Pie", 3), new ChartInternationnalNameContentBean("ChartF-Area", 4), new ChartInternationnalNameContentBean("ChartF-XYScatter", 5), new ChartInternationnalNameContentBean("Chart_BubbleChart", 6), new ChartInternationnalNameContentBean("ChartF-Radar", 7), new ChartInternationnalNameContentBean("ChartF-Stock", 8), new ChartInternationnalNameContentBean("ChartF-Meter", 9), new ChartInternationnalNameContentBean("ChartF-Range_Chart", 10), new ChartInternationnalNameContentBean("ChartF-Comb_Chart", 11), new ChartInternationnalNameContentBean("ChartF-Gantt", 13), new ChartInternationnalNameContentBean("ChartF-Gis", 14), new ChartInternationnalNameContentBean("ChartF-Donut", 15)};
    private static Chart[] columnChartTypes = new Chart[]{ChartFactory.createColumnChart(), ChartFactory.createStackColumnChart(), ChartFactory.createPercentStackColumnChart(), ChartFactory.create3DColumnChart(), ChartFactory.create3DColumnHorizonDrawChart(), ChartFactory.create3DStackColumnChart(), ChartFactory.create3DPercentStackColumnChart()};
    private static Chart[] lineChartTypes = new Chart[]{ChartFactory.createLineChart(false, false, false), ChartFactory.createLineChart(true, false, false), ChartFactory.createLineChart(true, false, true), ChartFactory.createLineChart(false, true, false), ChartFactory.createLineChart(true, true, false), ChartFactory.createLineChart(true, true, true)};
    private static Chart[] barChartTypes = new Chart[]{ChartFactory.createBarChart(), ChartFactory.createStackBarChart(), ChartFactory.createPercentStackBarChart(), ChartFactory.create3DBarChart(), ChartFactory.create3DBarHorizontalDrawChart(), ChartFactory.create3DStackBarChart(), ChartFactory.create3DPercentStackBarChart()};
    private static Chart[] pieChartTypes = new Chart[]{ChartFactory.createPieChart(1), ChartFactory.createPie3DChart()};
    private static Chart[] areaChartTypes = new Chart[]{ChartFactory.createAreaChart(true, false), ChartFactory.createAreaChart(true, true), ChartFactory.createArea3DChart(true, false), ChartFactory.createArea3DChart(true, true)};
    private static Chart[] XYScatterChartTypes = new Chart[]{ChartFactory.createXYScatterChart(true, false)};
    private static Chart[] bubbleChartTypes = new Chart[]{ChartFactory.createBubbleChart()};
    private static Chart[] radarChartTypes = new Chart[]{ChartFactory.createUnFilledRadarChartWithoutMarker(), ChartFactory.createUnFilledRadarChartWithMarker(), ChartFactory.createFilledRadarChartWithoutMarker(), ChartFactory.createFilledRadaeChartWithMarker()};
    private static Chart[] stockChartTypes = new Chart[]{ChartFactory.createStockChart()};
    private static Chart[] meterChartTypes = new Chart[]{ChartFactory.createMeterChart(), ChartFactory.createMeterCustomChart()};
    private static Chart[] rangeChartTypes = new Chart[]{ChartFactory.createRangeChart()};
    private static Chart[] combChartTypes = new Chart[]{ChartFactory.createCustomChart(false), ChartFactory.createCustomChart(true)};
    private static Chart[] mapChartTypes = new Chart[]{ChartFactory.createMapChart()};
    private static Chart[] ganttChartTypes = new Chart[]{ChartFactory.createGanttChart()};
    private static Chart[] gisChartTypes = new Chart[]{ChartFactory.createGisChart(true), ChartFactory.createGisChart(false)};
    private static Chart[] donutChartTypes = new Chart[]{ChartFactory.create2DDonutChart(), ChartFactory.create3DDonutChart()};

    public static ChartInternationnalNameContentBean[] getAllChartNames() {
        ChartInternationnalNameContentBean[] chartInternationnalNameContentBeanArray;
        if (FRContext.getLocale().equals(Locale.US)) {
            chartInternationnalNameContentBeanArray = new ChartInternationnalNameContentBean[gridBIChartBaseNames.length];
            for (int i2 = 0; i2 < gridBIChartBaseNames.length; ++i2) {
                chartInternationnalNameContentBeanArray[i2] = new ChartInternationnalNameContentBean(Inter.getLocText(gridBIChartBaseNames[i2].getName()), allChartBaseNames[i2].getContent());
            }
        } else {
            chartInternationnalNameContentBeanArray = new ChartInternationnalNameContentBean[allChartBaseNames.length];
            for (int i3 = 0; i3 < allChartBaseNames.length; ++i3) {
                chartInternationnalNameContentBeanArray[i3] = new ChartInternationnalNameContentBean(Inter.getLocText(allChartBaseNames[i3].getName()), allChartBaseNames[i3].getContent());
            }
        }
        return chartInternationnalNameContentBeanArray;
    }

    public static ChartInternationnalNameContentBean[] getAllChartNames4Browser() {
        ChartInternationnalNameContentBean[] chartInternationnalNameContentBeanArray = new ChartInternationnalNameContentBean[allChartBaseNames.length];
        for (int i2 = 0; i2 < allChartBaseNames.length; ++i2) {
            chartInternationnalNameContentBeanArray[i2] = new ChartInternationnalNameContentBean(TemplateUtils.i18nTpl(allChartBaseNames[i2].getName()), allChartBaseNames[i2].getContent());
        }
        return chartInternationnalNameContentBeanArray;
    }

    public static ChartInternationnalNameContentBean[] getAllChartBaseNames() {
        return allChartBaseNames;
    }

    public static Chart[] getChartTypes(int n2) {
        switch (n2) {
            case 0: {
                return columnChartTypes;
            }
            case 1: {
                return lineChartTypes;
            }
            case 2: {
                return barChartTypes;
            }
            case 3: {
                return pieChartTypes;
            }
            case 4: {
                return areaChartTypes;
            }
            case 5: {
                return XYScatterChartTypes;
            }
            case 6: {
                return bubbleChartTypes;
            }
            case 7: {
                return radarChartTypes;
            }
            case 8: {
                return stockChartTypes;
            }
            case 9: {
                return meterChartTypes;
            }
            case 10: {
                return rangeChartTypes;
            }
            case 11: {
                return combChartTypes;
            }
            case 12: {
                return mapChartTypes;
            }
            case 13: {
                return ganttChartTypes;
            }
            case 14: {
                return gisChartTypes;
            }
            case 15: {
                return donutChartTypes;
            }
        }
        return null;
    }

    private static void setChartFontAttr(Plot plot) {
        TextAttr textAttr;
        if (plot.getxAxis() != null) {
            textAttr = new TextAttr();
            textAttr.setFRFont(FRFont.getInstance("Microsoft YaHei", 0, 9.0f));
            plot.getxAxis().setTextAttr(textAttr);
        }
        if (plot.getyAxis() != null) {
            textAttr = new TextAttr();
            textAttr.setFRFont(FRFont.getInstance("Century Gothic", 0, 9.0f));
            plot.getyAxis().setTextAttr(textAttr);
            if (plot.getSecondAxis() != null) {
                plot.getSecondAxis().setTextAttr(textAttr);
            }
        }
        if (plot.getLegend() != null) {
            plot.getLegend().setFRFont(FRFont.getInstance("Microsoft YaHei", 0, 9.0f));
        }
    }

    public static Chart createColumnChart() {
        return new Chart(ChartFactory.createBar2DPlot());
    }

    private static Chart createBarChart() {
        Bar2DPlot bar2DPlot = ChartFactory.createBar2DPlot();
        bar2DPlot.setHorizontal(true);
        return new Chart(bar2DPlot);
    }

    private static Bar2DPlot createBar2DPlot() {
        Bar2DPlot bar2DPlot = new Bar2DPlot();
        ChartFactory.setChartFontAttr(bar2DPlot);
        return bar2DPlot;
    }

    private static Chart createStackColumnChart() {
        return new Chart(ChartFactory.createStackBar2DPlot());
    }

    private static Chart createStackBarChart() {
        Bar2DPlot bar2DPlot = ChartFactory.createStackBar2DPlot();
        bar2DPlot.setHorizontal(true);
        return new Chart(bar2DPlot);
    }

    private static Bar2DPlot createStackBar2DPlot() {
        Bar2DPlot bar2DPlot = new Bar2DPlot();
        bar2DPlot.setStacked(true);
        ChartFactory.setChartFontAttr(bar2DPlot);
        bar2DPlot.setSeriesOverlapPercent(1.0);
        return bar2DPlot;
    }

    private static Chart createPercentStackColumnChart() {
        return new Chart(ChartFactory.createPercentStackBar2DPlot());
    }

    private static Chart createPercentStackBarChart() {
        Bar2DPlot bar2DPlot = ChartFactory.createPercentStackBar2DPlot();
        bar2DPlot.setHorizontal(true);
        return new Chart(bar2DPlot);
    }

    private static Bar2DPlot createPercentStackBar2DPlot() {
        Bar2DPlot bar2DPlot = new Bar2DPlot();
        ChartFactory.setChartFontAttr(bar2DPlot);
        bar2DPlot.setStacked(true);
        bar2DPlot.setSeriesOverlapPercent(1.0);
        Axis axis = bar2DPlot.getyAxis();
        axis.setPercentage(true);
        axis.setFormat(new CoreDecimalFormat(new DecimalFormat("#0%"), "#0%"));
        return bar2DPlot;
    }

    private static Chart create3DColumnChart() {
        Bar3DPlot bar3DPlot = ChartFactory.createBar3DPlot();
        ChartFactory.setChartFontAttr(bar3DPlot);
        return new Chart(bar3DPlot);
    }

    private static Chart create3DBarChart() {
        Bar3DPlot bar3DPlot = ChartFactory.createBar3DPlot();
        ChartFactory.setChartFontAttr(bar3DPlot);
        bar3DPlot.setHorizontal(true);
        return new Chart(bar3DPlot);
    }

    private static Bar3DPlot createBar3DPlot() {
        Bar3DPlot bar3DPlot = new Bar3DPlot();
        bar3DPlot.setSeriesOverlapPercent(1.0);
        return bar3DPlot;
    }

    private static Chart create3DColumnHorizonDrawChart() {
        Bar3DPlot bar3DPlot = ChartFactory.create3DHorizonDrawPlot();
        ChartFactory.setChartFontAttr(bar3DPlot);
        return new Chart(bar3DPlot);
    }

    private static Chart create3DBarHorizontalDrawChart() {
        Bar3DPlot bar3DPlot = ChartFactory.create3DHorizonDrawPlot();
        ChartFactory.setChartFontAttr(bar3DPlot);
        bar3DPlot.setHorizontal(true);
        return new Chart(bar3DPlot);
    }

    private static Bar3DPlot create3DHorizonDrawPlot() {
        Bar3DPlot bar3DPlot = new Bar3DPlot();
        bar3DPlot.setHorizontalDrawBar(true);
        bar3DPlot.setSeriesOverlapPercent(-0.5);
        return bar3DPlot;
    }

    private static Chart create3DStackColumnChart() {
        Bar3DPlot bar3DPlot = ChartFactory.create3DStackPlot();
        ChartFactory.setChartFontAttr(bar3DPlot);
        return new Chart(bar3DPlot);
    }

    private static Chart create3DStackBarChart() {
        Bar3DPlot bar3DPlot = ChartFactory.create3DStackPlot();
        ChartFactory.setChartFontAttr(bar3DPlot);
        bar3DPlot.setHorizontal(true);
        return new Chart(bar3DPlot);
    }

    private static Bar3DPlot create3DStackPlot() {
        Bar3DPlot bar3DPlot = new Bar3DPlot();
        bar3DPlot.setStacked(true);
        bar3DPlot.setSeriesOverlapPercent(1.0);
        return bar3DPlot;
    }

    private static Chart create3DPercentStackColumnChart() {
        return new Chart(ChartFactory.creat3DPercentStackPlot());
    }

    private static Chart create3DPercentStackBarChart() {
        Bar3DPlot bar3DPlot = ChartFactory.creat3DPercentStackPlot();
        ChartFactory.setChartFontAttr(bar3DPlot);
        bar3DPlot.setHorizontal(true);
        return new Chart(bar3DPlot);
    }

    private static Bar3DPlot creat3DPercentStackPlot() {
        Bar3DPlot bar3DPlot = new Bar3DPlot();
        bar3DPlot.setStacked(true);
        bar3DPlot.setSeriesOverlapPercent(1.0);
        bar3DPlot.getyAxis().setPercentage(true);
        bar3DPlot.getyAxis().setFormat(new CoreDecimalFormat(new DecimalFormat("#0%"), "#0%"));
        return bar3DPlot;
    }

    private static Chart createPieChart(int n2) {
        PiePlot piePlot = new PiePlot();
        piePlot.setSubType(n2);
        ChartFactory.createPieCondition(piePlot);
        return new Chart(piePlot);
    }

    private static void createPieCondition(Plot plot) {
        ConditionCollection conditionCollection = plot.getConditionCollection();
        AttrBorder attrBorder = (AttrBorder)conditionCollection.getDefaultAttr().getExisted(AttrBorder.class);
        if (attrBorder == null) {
            attrBorder = new AttrBorder();
            conditionCollection.getDefaultAttr().addDataSeriesCondition(attrBorder);
        }
        attrBorder.setBorderColor(Color.WHITE);
        attrBorder.setBorderStyle(1);
        ChartFactory.setChartFontAttr(plot);
        AttrContents attrContents = new AttrContents("${VALUE}${PERCENT}");
        plot.setHotTooltipStyle(attrContents);
        attrContents.setFormat(new CoreDecimalFormat(new DecimalFormat("#.##"), "#.##"));
        attrContents.setPercentFormat(new CoreDecimalFormat(new DecimalFormat("#.##%"), "#.##%"));
    }

    private static Chart createPie3DChart() {
        Pie3DPlot pie3DPlot = new Pie3DPlot();
        ChartFactory.createPieCondition(pie3DPlot);
        return new Chart(pie3DPlot);
    }

    private static Chart createLineChart(boolean bl, boolean bl2, boolean bl3) {
        DataSeriesCondition dataSeriesCondition;
        LinePlot linePlot = new LinePlot();
        ConditionCollection conditionCollection = linePlot.getConditionCollection();
        linePlot.setStacked(bl);
        if (!bl2) {
            ChartXMLCompatibleUtils.changeAttrNone(conditionCollection, false);
        } else {
            dataSeriesCondition = (AttrMarkerType)conditionCollection.getDefaultAttr().getExisted(AttrMarkerType.class);
            if (dataSeriesCondition == null) {
                dataSeriesCondition = new AttrMarkerType();
                conditionCollection.getDefaultAttr().addDataSeriesCondition(dataSeriesCondition);
            }
            ((AttrMarkerType)dataSeriesCondition).setMarkerType("RoundFilledMarker");
        }
        if (bl3) {
            linePlot.getyAxis().setPercentage(true);
            linePlot.getyAxis().setFormat(new CoreDecimalFormat(new DecimalFormat("#0%"), "#0%"));
        }
        if ((dataSeriesCondition = (AttrLineStyle)conditionCollection.getDefaultAttr().getExisted(AttrLineStyle.class)) == null) {
            dataSeriesCondition = new AttrLineStyle();
            conditionCollection.getDefaultAttr().addDataSeriesCondition(dataSeriesCondition);
        }
        ((AttrLineStyle)dataSeriesCondition).setLineStyle(5);
        ChartFactory.setChartFontAttr(linePlot);
        return new Chart(linePlot);
    }

    public static Chart createCustomChart(boolean bl) {
        CustomPlot customPlot = new CustomPlot();
        if (bl) {
            customPlot.getDataSheet().setVisible(true);
            customPlot.getxAxis().setShowAxisLabel(false);
            customPlot.getLegend().setPosition(1);
        }
        ChartFactory.setChartFontAttr(customPlot);
        ChartFactory.createSeriesMap4CustomPlot(customPlot);
        Axis axis = customPlot.getSecondAxis();
        axis.setMainGridStyle(0);
        return new Chart(customPlot);
    }

    private static Chart createAreaChart(boolean bl, boolean bl2) {
        AreaPlot areaPlot = new AreaPlot();
        ConditionCollection conditionCollection = areaPlot.getConditionCollection();
        AttrAlpha attrAlpha = (AttrAlpha)conditionCollection.getDefaultAttr().getExisted(AttrAlpha.class);
        if (attrAlpha == null) {
            attrAlpha = new AttrAlpha();
            conditionCollection.getDefaultAttr().addDataSeriesCondition(attrAlpha);
        }
        attrAlpha.setAlpha(0.7f);
        areaPlot.setStacked(bl);
        AttrMarkerType attrMarkerType = (AttrMarkerType)conditionCollection.getDefaultAttr().getExisted(AttrMarkerType.class);
        if (attrMarkerType == null) {
            attrMarkerType = new AttrMarkerType("NullMarker");
            conditionCollection.getDefaultAttr().addDataSeriesCondition(attrMarkerType);
        }
        if (bl2) {
            areaPlot.getyAxis().setPercentage(true);
            areaPlot.getyAxis().setFormat(new CoreDecimalFormat(new DecimalFormat("#0%"), "#0%"));
        }
        ChartFactory.setChartFontAttr(areaPlot);
        return new Chart(areaPlot);
    }

    private static Chart createArea3DChart(boolean bl, boolean bl2) {
        Area3DPlot area3DPlot = new Area3DPlot();
        area3DPlot.setStacked(bl);
        if (bl2) {
            area3DPlot.getyAxis().setPercentage(true);
            area3DPlot.getyAxis().setFormat(new CoreDecimalFormat(new DecimalFormat("#0%"), "#0%"));
        }
        ChartFactory.setChartFontAttr(area3DPlot);
        return new Chart(area3DPlot);
    }

    private static Chart createMeterChart() {
        MeterPlot meterPlot = new MeterPlot();
        if (meterPlot.getLegend() != null) {
            meterPlot.getLegend().setLegendVisible(false);
        }
        ChartFactory.setChartFontAttr(meterPlot);
        return new Chart(meterPlot);
    }

    private static Chart createMeterCustomChart() {
        MeterCustomPlot meterCustomPlot = new MeterCustomPlot();
        if (meterCustomPlot.getLegend() != null) {
            meterCustomPlot.getLegend().setLegendVisible(false);
        }
        ChartFactory.setChartFontAttr(meterCustomPlot);
        return new Chart(meterCustomPlot);
    }

    private static Chart createRangeChart() {
        RangePlot rangePlot = new RangePlot();
        ChartFactory.setChartFontAttr(rangePlot);
        return new Chart(rangePlot);
    }

    public static Chart createGanttChart() {
        GanttPlot ganttPlot = new GanttPlot();
        Axis axis = ((Plot)ganttPlot).getyAxis();
        axis.setMainGridStyle(1);
        axis.setMainGridColor(new Color(192, 192, 192));
        ChartFactory.setChartFontAttr(ganttPlot);
        return new Chart(ganttPlot);
    }

    public static Chart createGisChart(boolean bl) {
        GisMapPlot gisMapPlot = new GisMapPlot();
        gisMapPlot.getHotTooltipStyle().setFormat(new CoreDecimalFormat(new DecimalFormat("#.##"), "#.##"));
        gisMapPlot.setGisType(bl);
        gisMapPlot.setHotTooltipStyle(new AttrContents("${ADDRESS}"));
        return new Chart(gisMapPlot);
    }

    public static Chart create2DDonutChart() {
        Donut2DPlot donut2DPlot = new Donut2DPlot();
        return new Chart(donut2DPlot);
    }

    public static Chart create3DDonutChart() {
        Donut3DPlot donut3DPlot = new Donut3DPlot();
        return new Chart(donut3DPlot);
    }

    private static Chart createXYScatterChart(boolean bl, boolean bl2) {
        XYScatterPlot xYScatterPlot = new XYScatterPlot();
        if (!bl) {
            ChartXMLCompatibleUtils.changeAttrNone(xYScatterPlot.getConditionCollection(), false);
        }
        if (!bl2) {
            ChartXMLCompatibleUtils.changeAttrNone(xYScatterPlot.getConditionCollection(), true);
        }
        ChartFactory.setChartFontAttr(xYScatterPlot);
        return new Chart(xYScatterPlot);
    }

    private static Chart createBubbleChart() {
        BubblePlot bubblePlot = new BubblePlot();
        AttrBorder attrBorder = (AttrBorder)bubblePlot.getConditionCollection().getDefaultAttr().getExisted(AttrBorder.class);
        if (attrBorder == null) {
            attrBorder = new AttrBorder();
            bubblePlot.getConditionCollection().getDefaultAttr().addDataSeriesCondition(attrBorder);
        }
        attrBorder.setBorderColor(Color.GRAY);
        attrBorder.setBorderStyle(1);
        ChartFactory.setChartFontAttr(bubblePlot);
        return new Chart(bubblePlot);
    }

    private static Chart createFilledRadaeChartWithMarker() {
        RadarPlot radarPlot = new RadarPlot();
        radarPlot.setIsFilled(true);
        return ChartFactory.createRadarChart(radarPlot);
    }

    private static Chart createFilledRadarChartWithoutMarker() {
        RadarPlot radarPlot = new RadarPlot();
        radarPlot.setIsFilled(true);
        radarPlot.getConditionCollection().getDefaultAttr().addDataSeriesCondition(new AttrMarkerType("NullMarker"));
        return ChartFactory.createRadarChart(radarPlot);
    }

    private static Chart createUnFilledRadarChartWithMarker() {
        RadarPlot radarPlot = new RadarPlot();
        radarPlot.setIsFilled(false);
        return ChartFactory.createRadarChart(radarPlot);
    }

    private static Chart createUnFilledRadarChartWithoutMarker() {
        RadarPlot radarPlot = new RadarPlot();
        radarPlot.setIsFilled(false);
        radarPlot.getConditionCollection().getDefaultAttr().addDataSeriesCondition(new AttrMarkerType("NullMarker"));
        return ChartFactory.createRadarChart(radarPlot);
    }

    private static Chart createRadarChart(RadarPlot radarPlot) {
        AttrAlpha attrAlpha = (AttrAlpha)radarPlot.getConditionCollection().getDefaultAttr().getExisted(AttrAlpha.class);
        if (attrAlpha == null) {
            attrAlpha = new AttrAlpha();
            radarPlot.getConditionCollection().getDefaultAttr().addDataSeriesCondition(attrAlpha);
        }
        attrAlpha.setAlpha(0.7f);
        ChartFactory.setChartFontAttr(radarPlot);
        ChartFactory.setDefaultCondition4RadarChart(radarPlot);
        return new Chart(radarPlot);
    }

    public static void setDefaultCondition4RadarChart(Plot plot) {
        plot.getConditionCollection().getDefaultAttr().addDataSeriesCondition(new AttrLineStyle(5));
    }

    public static Chart createStockChart() {
        StockPlot stockPlot = new StockPlot();
        stockPlot.setHotTooltipStyle(new AttrContents("${VALUE}"));
        Axis axis = stockPlot.getSecondAxis();
        axis.setMainGridStyle(0);
        ChartFactory.setChartFontAttr(stockPlot);
        return new Chart(stockPlot);
    }

    public static void createSeriesMap4CustomPlot(CustomPlot customPlot) {
        ConditionCollection conditionCollection = customPlot.getConditionCollection();
        if (customPlot.getLinePlot() != null) {
            LinePlot linePlot = customPlot.getLinePlot();
            ConditionAttr conditionAttr = linePlot.getConditionCollection().getDefaultAttr();
            conditionAttr.addDataSeriesCondition(new AttrLineStyle(5));
        }
        conditionCollection.setDefaultAttr(new CustomAttr());
        conditionCollection.addConditionAttr(ChartFactory.createCustomAttrWithType(1, 0, "LEFT"));
        conditionCollection.addConditionAttr(ChartFactory.createCustomAttrWithType(2, 1, "RIGHT"));
    }

    public static CustomAttr createCustomAttrWithType(int n2, int n3, String string) {
        CustomAttr customAttr = new CustomAttr(n2);
        if (n2 == 2) {
            customAttr.addDataSeriesCondition(new AttrLineStyle(5));
            customAttr.addDataSeriesCondition(new AttrMarkerType("NullMarker"));
        }
        customAttr.addDataSeriesCondition(new AttrAxisPosition(string));
        ListCondition listCondition = new ListCondition();
        listCondition.addJoinCondition(0, new CommonCondition(ChartConstants.SERIES_INDEX, 0, new Integer(n3 + 1)));
        customAttr.setCondition(listCondition);
        customAttr.setName(Inter.getLocText("Condition_Attributes") + n3 + 1);
        return customAttr;
    }

    private static Chart createMapChart() {
        MapPlot mapPlot = new MapPlot();
        ChartFactory.setChartFontAttr(mapPlot);
        mapPlot.getHotTooltipStyle().setFormat(new CoreDecimalFormat(new DecimalFormat("#.##"), "#.##"));
        mapPlot.getHotTooltipStyle().setPercentFormat(new CoreDecimalFormat(new DecimalFormat("#.##%"), "#.##%"));
        return new Chart(mapPlot);
    }
}

