/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.BaseXMLUtils;
import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrLine;
import com.fr.chart.base.AttrLineStyle;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.List;

public class ChartAlertValue
implements XMLable {
    private static final long serialVersionUID = -4932357846358003761L;
    public static final String XML_TAG = "ChartAlertValue";
    private Formula alertValueFormula = new Formula();
    private AttrColor alertLineColor = new AttrColor(Color.red);
    private AttrLineStyle alertLineStyle = new AttrLineStyle(1);
    private float alertLineAlpha = 1.0f;
    private String alertContent = Inter.getLocText("ChartF_Alert");
    private FRFont alertFont = FRFont.getInstance();
    private int alertPosition = 4;
    private String alertNameInPaneSelect = "";

    public ChartAlertValue() {
    }

    public ChartAlertValue(Formula formula) {
        this.alertValueFormula = formula;
    }

    public void setAlertValueFormula(Formula formula) {
        this.alertValueFormula = formula;
    }

    public Formula getAlertValueFormula() {
        return this.alertValueFormula;
    }

    public void setAlertPosition(int n2) {
        this.alertPosition = n2;
    }

    public int getAlertPosition() {
        return this.alertPosition;
    }

    public void setAlertContent(String string) {
        this.alertContent = string;
    }

    public String getAlertContent() {
        return this.alertContent;
    }

    public void setLineColor(AttrColor attrColor) {
        this.alertLineColor = attrColor;
    }

    public AttrColor getLineColor() {
        return this.alertLineColor;
    }

    public void setLineStyle(AttrLineStyle attrLineStyle) {
        this.alertLineStyle = attrLineStyle;
    }

    public AttrLineStyle getLineStyle() {
        return this.alertLineStyle;
    }

    public void setAlertFont(FRFont fRFont) {
        this.alertFont = fRFont;
    }

    public FRFont getAlertFont() {
        return this.alertFont;
    }

    public void setAlertLineAlpha(float f2) {
        this.alertLineAlpha = f2;
    }

    public float getAlertLineAlpha() {
        return this.alertLineAlpha;
    }

    public void setAlertPaneSelectName(String string) {
        this.alertNameInPaneSelect = string;
    }

    public String getAlertPaneSelectName() {
        return this.alertNameInPaneSelect;
    }

    public void dealFormula(Calculator calculator) {
        if (this.alertValueFormula != null) {
            Utils.dealFormulaValue(this.alertValueFormula, calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        if (this.alertValueFormula != null) {
            GeneralUtils.dealBuidExecuteSequence(this.alertValueFormula, list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (this.alertValueFormula != null) {
            this.alertValueFormula.modColumnRow(mOD_COLUMN_ROW);
        }
    }

    public boolean equals(Object object) {
        return object instanceof ChartAlertValue && ComparatorUtils.equals(((ChartAlertValue)object).getLineColor(), this.alertLineColor) && ComparatorUtils.equals(((ChartAlertValue)object).getLineStyle(), this.alertLineStyle) && ComparatorUtils.equals(((ChartAlertValue)object).getAlertValueFormula(), this.alertValueFormula) && ComparatorUtils.equals(((ChartAlertValue)object).getAlertPaneSelectName(), this.alertNameInPaneSelect) && ((ChartAlertValue)object).getAlertPosition() == this.alertPosition && ComparatorUtils.equals(((ChartAlertValue)object).getAlertContent(), this.alertContent) && ComparatorUtils.equals(((ChartAlertValue)object).getAlertFont(), this.alertFont) && ((ChartAlertValue)object).alertLineAlpha == this.alertLineAlpha;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                this.setAlertPaneSelectName(xMLableReader.getAttrAsString("name", ""));
                this.setAlertValueFormula(new Formula(xMLableReader.getAttrAsString("formula", "")));
                this.setAlertContent(xMLableReader.getAttrAsString("alertContent", Inter.getLocText("ChartF_Alert")));
                this.setAlertPosition(xMLableReader.getAttrAsInt("alertPosition", 2));
                this.setAlertLineAlpha(xMLableReader.getAttrAsFloat("alertLineAlpha", 1.0f));
            } else if (string.equals("AttrLine")) {
                AttrLine attrLine = (AttrLine)xMLableReader.readXMLObject(new AttrLine());
                this.alertLineColor = new AttrColor(attrLine.getSeriesLineColor());
                this.alertLineStyle = new AttrLineStyle(attrLine.getSeriesLineStyle());
            } else if (string.equals("FRFont")) {
                this.alertFont = BaseXMLUtils.readFRFont(xMLableReader);
            } else if (string.equals("AttrColor")) {
                this.alertLineColor = (AttrColor)xMLableReader.readXMLObject(new AttrColor());
            } else if (string.equals("AttrLineStyle")) {
                this.alertLineStyle = (AttrLineStyle)xMLableReader.readXMLObject(new AttrLineStyle());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr");
        xMLPrintWriter.attr("name", this.alertNameInPaneSelect).attr("alertPosition", this.alertPosition).attr("alertLineAlpha", this.alertLineAlpha).attr("alertContent", this.alertContent);
        if (this.alertValueFormula != null) {
            xMLPrintWriter.attr("formula", this.alertValueFormula.toString());
        }
        xMLPrintWriter.end();
        if (this.getLineColor() != null) {
            this.getLineColor().writeXML(xMLPrintWriter);
        }
        if (this.getLineStyle() != null) {
            this.getLineStyle().writeXML(xMLPrintWriter);
        }
        if (this.alertFont != null) {
            BaseXMLUtils.writeFRFont(xMLPrintWriter, this.alertFont);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        ChartAlertValue chartAlertValue = (ChartAlertValue)super.clone();
        if (this.alertValueFormula != null) {
            chartAlertValue.setAlertValueFormula((Formula)this.alertValueFormula.clone());
        }
        if (this.getLineStyle() != null) {
            chartAlertValue.setLineStyle((AttrLineStyle)this.getLineStyle().clone());
        }
        if (this.getLineColor() != null) {
            chartAlertValue.setLineColor((AttrColor)this.getLineColor().clone());
        }
        if (this.alertFont != null) {
            chartAlertValue.setAlertFont((FRFont)this.alertFont.clone());
        }
        return chartAlertValue;
    }
}

