/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.chart.base.LineStyleInfo;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class TrendLine
implements XMLable {
    private static final long serialVersionUID = -993509754275088848L;
    private int moveAverage = 2;
    private int equation = 1;
    private int square = 6;
    private LineStyleInfo lineStyleInfo = new LineStyleInfo();
    private String trendLineName = Inter.getLocText("Chart_TrendLine");

    public TrendLine() {
    }

    public TrendLine(int n2) {
        this.setEquation(n2);
    }

    public void setEquation(int n2) {
        this.equation = n2;
    }

    public int getEquation() {
        return this.equation;
    }

    public int getSquare() {
        return this.square;
    }

    public void setMoveAverage(int n2) {
        this.moveAverage = n2;
    }

    public int getMoveAverage() {
        return this.moveAverage;
    }

    public void setTrendLineName(String string) {
        this.trendLineName = string;
    }

    public String getTrendLineName() {
        return this.trendLineName;
    }

    public void setLineStyleInfo(LineStyleInfo lineStyleInfo) {
        this.lineStyleInfo = lineStyleInfo;
    }

    public LineStyleInfo getLineStyleInfo() {
        return this.lineStyleInfo;
    }

    public Object clone() {
        TrendLine trendLine = new TrendLine(this.equation);
        trendLine.square = this.square;
        trendLine.setLineStyleInfo(this.getLineStyleInfo());
        return trendLine;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("LineStyleInfo")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string = xMLableReader.getTagName();
                        if (string.equals("LineStyleInfo")) {
                            TrendLine.this.setLineStyleInfo((LineStyleInfo)xMLableReader.readXMLObject(new LineStyleInfo()));
                        }
                    }
                });
            } else if (string.equals("Attr")) {
                this.square = xMLableReader.getAttrAsInt("square", 6);
                this.equation = xMLableReader.getAttrAsInt("equation", 1);
                this.setMoveAverage(xMLableReader.getAttrAsInt("moveAverage", 2));
                if (xMLableReader.getAttrAsString("trendLineName", null) != null) {
                    this.setTrendLineName(xMLableReader.getAttrAsString("trendLineName", Inter.getLocText("Chart_TrendLine")));
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("TrendLine");
        xMLPrintWriter.startTAG("Attr").attr("equation", this.equation).attr("square", this.square).attr("trendLineName", this.trendLineName).attr("moveAverage", this.getMoveAverage()).end();
        this.getLineStyleInfo().writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("equation", this.equation);
        jSONObject.put("square", this.square);
        jSONObject.put("moveAverage", this.getMoveAverage());
        jSONObject.put("trendLineName", this.trendLineName);
        if (this.lineStyleInfo != null) {
            jSONObject.put("lineStyleInfo", this.lineStyleInfo.toJSONObject());
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        return object instanceof TrendLine && ComparatorUtils.equals(((TrendLine)object).trendLineName, this.trendLineName) && ComparatorUtils.equals(((TrendLine)object).lineStyleInfo, this.lineStyleInfo) && ((TrendLine)object).square == this.square && ((TrendLine)object).moveAverage == this.moveAverage && ((TrendLine)object).equation == this.equation;
    }
}

