/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.GraphHelper;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.AttrLine;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.OuterLight;
import com.fr.chart.base.Shadow;
import com.fr.chart.base.StyleContactWithConditionCollection;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.Map;

public class LineStyleInfo
implements XMLable,
StyleContactWithConditionCollection {
    private static final long serialVersionUID = -5616374725367075547L;
    public static final String XML_TAG = "LineStyleInfo";
    private AttrColor lineColor = new AttrColor();
    private AttrLineStyle lineStyle = new AttrLineStyle();
    private AttrAlpha seriesAttrAlpha = new AttrAlpha();
    private AttrBorder seriesAttrBorder = new AttrBorder();
    private Shadow shadow;
    private OuterLight outerLight;

    public void setSeriesAttrAlpha(AttrAlpha attrAlpha) {
        this.seriesAttrAlpha = attrAlpha;
    }

    public AttrAlpha getSeriesAttrAlpha() {
        return this.seriesAttrAlpha;
    }

    public void setAttrLineColor(AttrColor attrColor) {
        this.lineColor = attrColor;
    }

    public AttrColor getAttrLineColor() {
        return this.lineColor;
    }

    public void setAttrLineStyle(AttrLineStyle attrLineStyle) {
        this.lineStyle = attrLineStyle;
    }

    public AttrLineStyle getAttrLineStyle() {
        return this.lineStyle;
    }

    public void setShadow(Shadow shadow) {
        this.shadow = shadow;
    }

    public Shadow getShadow() {
        return this.shadow;
    }

    public void setOuterLight(OuterLight outerLight) {
        this.outerLight = outerLight;
    }

    public OuterLight getOuterLight() {
        return this.outerLight;
    }

    public void changeStyleAttrAlpha(AttrAlpha attrAlpha) {
        this.setSeriesAttrAlpha(attrAlpha);
    }

    public void changeStyleAttrBackground(AttrBackground attrBackground) {
    }

    public void changeStyleAttrBorder(AttrBorder attrBorder) {
    }

    public void changeStyleAttrColor(AttrColor attrColor) {
        this.setAttrLineColor(attrColor);
    }

    public void changeStyleAttrContents(AttrContents attrContents) {
    }

    public void changeStyleAttrLineStyle(AttrLineStyle attrLineStyle) {
        this.setAttrLineStyle(attrLineStyle);
    }

    public void paint(Graphics graphics, Shape shape) {
        if (shape == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = GraphHelper.getLineStyleSize(this.getAttrLineStyle().getLineStyle());
        if (this.shadow != null && n2 > 0) {
            this.shadow.paint(graphics2D, shape, n2);
        }
        if (this.getOuterLight() != null && n2 > 0) {
            this.getOuterLight().paint(graphics2D, shape, n2);
        }
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getSeriesAttrAlpha().getAlpha()));
        if (this.seriesAttrBorder != null && this.seriesAttrBorder.getBorderStyle() != 0 && this.seriesAttrBorder.getBorderColor() != null) {
            Stroke stroke = graphics2D.getStroke();
            Paint paint = graphics2D.getPaint();
            int n3 = GraphHelper.getLineStyleSize(this.getAttrLineStyle().getLineStyle());
            BasicStroke basicStroke = (BasicStroke)GraphHelper.getStroke(this.seriesAttrBorder.getBorderStyle());
            BasicStroke basicStroke2 = new BasicStroke((float)n3 + basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
            graphics2D.setStroke(basicStroke2);
            if (this.seriesAttrBorder.getBorderColor() != null) {
                graphics2D.setPaint(this.seriesAttrBorder.getBorderColor());
                graphics2D.draw(shape);
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.setRenderingHints((Map)object);
        }
        if (this.getAttrLineColor() != null && this.getAttrLineColor().getSeriesColor() != null && this.getAttrLineStyle() != null && this.getAttrLineStyle().getLineStyle() != 0) {
            graphics2D.setPaint(this.getAttrLineColor().getSeriesColor());
            GraphHelper.setStroke(graphics2D, (BasicStroke)GraphHelper.getStroke(this.getAttrLineStyle().getLineStyle()));
            graphics2D.draw(shape);
        }
        graphics2D.setComposite(composite);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                this.getSeriesAttrAlpha().setAlpha(xMLableReader.getAttrAsFloat("alpha", 1.0f));
                this.getAttrLineStyle().setLineStyle(xMLableReader.getAttrAsInt("lineStyle", 1));
                String string2 = xMLableReader.getAttrAsString("lineColor", null);
                if (string2 != null) {
                    this.getAttrLineColor().setSeriesColor(new Color(Integer.parseInt(string2), true));
                }
            } else if (string.equals("AttrAlpha")) {
                this.seriesAttrAlpha = (AttrAlpha)xMLableReader.readXMLObject(new AttrAlpha());
            } else if (string.equals("AttrLine")) {
                AttrLine attrLine = (AttrLine)xMLableReader.readXMLObject(new AttrLine());
                this.lineColor = new AttrColor(attrLine.getSeriesLineColor());
                this.lineStyle = new AttrLineStyle(attrLine.getSeriesLineStyle());
            } else if (string.equals("AttrBorder")) {
                this.seriesAttrBorder = (AttrBorder)xMLableReader.readXMLObject(new AttrBorder());
            } else if (string.equals("AttrColor")) {
                this.setAttrLineColor((AttrColor)xMLableReader.readXMLObject(new AttrColor()));
            } else if (string.equals("AttrLineStyle")) {
                this.setAttrLineStyle((AttrLineStyle)xMLableReader.readXMLObject(new AttrLineStyle()));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.seriesAttrAlpha != null) {
            this.seriesAttrAlpha.writeXML(xMLPrintWriter);
        }
        if (this.getAttrLineColor() != null) {
            this.getAttrLineColor().writeXML(xMLPrintWriter);
        }
        if (this.getAttrLineStyle() != null) {
            this.getAttrLineStyle().writeXML(xMLPrintWriter);
        }
        if (this.seriesAttrBorder != null) {
            this.seriesAttrBorder.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        LineStyleInfo lineStyleInfo = (LineStyleInfo)super.clone();
        return lineStyleInfo;
    }

    public boolean equals(Object object) {
        return object instanceof LineStyleInfo && ComparatorUtils.equals(((LineStyleInfo)object).getAttrLineStyle(), this.getAttrLineStyle()) && ComparatorUtils.equals(((LineStyleInfo)object).getAttrLineColor(), this.getAttrLineColor()) && ComparatorUtils.equals(((LineStyleInfo)object).seriesAttrAlpha, this.seriesAttrAlpha);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.seriesAttrAlpha != null) {
            jSONObject.put("seriesAttrAlpha", this.seriesAttrAlpha.toJSONObject());
        }
        if (this.getAttrLineColor() != null) {
            jSONObject.put("attrLineColor", this.getAttrLineColor().toJSONObject());
        }
        if (this.getAttrLineStyle() != null) {
            jSONObject.put("attrLineStyle", this.getAttrLineStyle().toJSONObject());
        }
        if (this.seriesAttrBorder != null) {
            jSONObject.put("seriesAttrBorder", this.seriesAttrBorder.toJSONObject());
        }
        if (this.shadow != null) {
            jSONObject.put("shadow", this.shadow.toJSONObject());
        }
        if (this.outerLight != null) {
            jSONObject.put("outerLight", this.outerLight.toJSONObject());
        }
        return jSONObject;
    }
}

