/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.io;

import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.base.Utils;
import com.fr.base.io.XMLEncryptKey;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class XMLEncryptUtils {
    public static final String XML_TAG = "<FREncrypted>";
    public static final String KEY_NAME = "encryption.key";
    private static XMLEncryptKey KEY;

    public static boolean isCptEncoded() {
        return StringUtils.isNotEmpty(KEY.toString());
    }

    public static boolean checkVaild(String string) {
        return ComparatorUtils.equals(CodeUtils.passwordDecode(string), KEY.toString());
    }

    private static void readKey() {
        try {
            String string = XMLEncryptUtils.readKeyFromLic();
            String string2 = XMLEncryptUtils.readKeyFromLocal();
            KEY = StringUtils.isEmpty(string) ? new XMLEncryptKey(string2, true) : new XMLEncryptKey(string, ComparatorUtils.equals(string, string2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String readKeyFromLocal() throws Exception {
        InputStream inputStream = FRContext.getCurrentEnv().readBean(KEY_NAME, "resources");
        if (inputStream == null) {
            return "";
        }
        return CodeUtils.passwordDecode(XMLEncryptUtils.readStreamAsString(inputStream));
    }

    private static String readKeyFromLic() throws Exception {
        byte[] byArray = StableUtils.getBytes();
        if (byArray != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StableUtils.decode(byArray, byteArrayOutputStream);
            JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
            return jSONObject.has("KEY") ? jSONObject.getString("KEY") : "";
        }
        return "";
    }

    public static void setKEY(String string) {
        KEY = new XMLEncryptKey(string, true);
        try {
            Env env = FRContext.getCurrentEnv();
            if (StringUtils.isEmpty(string)) {
                File file = new File(StableUtils.pathJoin(new String[]{env.getPath(), "resources", KEY_NAME}));
                StableUtils.deleteFile(file);
            } else {
                OutputStream outputStream = env.writeBean(KEY_NAME, "resources");
                XMLEncryptUtils.writeToOutputStream(CodeUtils.passwordEncode(string), outputStream);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getKEY() {
        return KEY.toString();
    }

    public static File getReportletFolder() {
        Env env = FRContext.getCurrentEnv();
        return new File(StableUtils.pathJoin(new String[]{env.getPath(), "reportlets"}));
    }

    private static Key getKey(String string) {
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = KeyGenerator.getInstance("DES");
            keyGenerator.init(new SecureRandom(string.getBytes()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return keyGenerator.generateKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEncString(String string, String string2) {
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string3 = "";
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        try {
            byArray2 = string.getBytes("UTF8");
            byArray = XMLEncryptUtils.getEncCode(byArray2, string2);
            string3 = bASE64Encoder.encode(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            bASE64Encoder = null;
            byArray2 = null;
            byArray = null;
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDesString(String string, String string2) {
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string3 = "";
        try {
            byArray2 = bASE64Decoder.decodeBuffer(string);
            byArray = XMLEncryptUtils.getDesCode(byArray2, string2);
            string3 = new String(byArray, "UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            bASE64Decoder = null;
            byArray = null;
            byArray2 = null;
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getEncCode(byte[] byArray, String string) {
        byte[] byArray2 = null;
        try {
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, XMLEncryptUtils.getKey(string));
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            Object var3_4 = null;
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getDesCode(byte[] byArray, String string) {
        byte[] byArray2 = null;
        try {
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(2, XMLEncryptUtils.getKey(string));
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            Object var2_4 = null;
        }
        return byArray2;
    }

    public static void encodeAllFile(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (fileArray[i2].isDirectory()) {
                XMLEncryptUtils.encodeAllFile(fileArray[i2]);
                continue;
            }
            if (!fileArray[i2].getName().endsWith(".cpt") && !fileArray[i2].getName().endsWith(".frm")) continue;
            XMLEncryptUtils.encodeSingleFile(fileArray[i2]);
        }
    }

    public static void decodeAllFile(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (fileArray[i2].isDirectory()) {
                XMLEncryptUtils.decodeAllFile(fileArray[i2]);
                continue;
            }
            if (!fileArray[i2].getName().endsWith(".cpt") && !fileArray[i2].getName().endsWith(".frm")) continue;
            XMLEncryptUtils.decodeSingleFile(fileArray[i2]);
        }
    }

    public static void decodeSingleFile(File file) {
        String string = XMLEncryptUtils.readFileAsString(file);
        if (string.indexOf(XML_TAG) == -1 || StringUtils.isEmpty(KEY.toString())) {
            return;
        }
        string = string.replaceAll(XML_TAG, "");
        String string2 = XMLEncryptUtils.getDesString(string, KEY.toString());
        XMLEncryptUtils.writeToFile(string2, file);
    }

    public static InputStream decodeInputStream(InputStream inputStream) {
        try {
            if (StringUtils.isEmpty(KEY.toString())) {
                return inputStream;
            }
            String string = XMLEncryptUtils.readStreamAsString(inputStream);
            if (string.indexOf(XML_TAG) == -1 && KEY.isMatchedInlic()) {
                return new ByteArrayInputStream(string.getBytes("UTF-8"));
            }
            string = string.replaceAll(XML_TAG, "");
            String string2 = XMLEncryptUtils.getDesString(string, KEY.toString());
            return new ByteArrayInputStream(string2.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(Inter.getLocText("ECP_decode_failed") + exception.getMessage());
            return inputStream;
        }
    }

    public static InputStream encodeInputStream(InputStream inputStream) {
        try {
            if (StringUtils.isEmpty(KEY.toString())) {
                return inputStream;
            }
            String string = XMLEncryptUtils.readStreamAsString(inputStream);
            if (string.indexOf(XML_TAG) != -1 || !KEY.isMatchedInlic()) {
                return new ByteArrayInputStream(string.getBytes("UTF-8"));
            }
            String string2 = XML_TAG + XMLEncryptUtils.getEncString(string, KEY.toString());
            return new ByteArrayInputStream(string2.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(Inter.getLocText("ECP_encode_failed") + exception.getMessage());
            return inputStream;
        }
    }

    public static void encodeSingleFile(File file) {
        String string = XMLEncryptUtils.readFileAsString(file);
        if (string.indexOf(XML_TAG) != -1 || StringUtils.isEmpty(KEY.toString())) {
            return;
        }
        String string2 = XML_TAG + XMLEncryptUtils.getEncString(string, KEY.toString());
        XMLEncryptUtils.writeToFile(string2, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToOutputStream(String string, OutputStream outputStream) {
        BufferedWriter bufferedWriter = null;
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(string);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void writeToFile(String string, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            XMLEncryptUtils.writeToOutputStream(string, fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static String readFileAsString(File file) {
        try {
            return XMLEncryptUtils.readStreamAsString(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            FRContext.getLogger().error(fileNotFoundException.getMessage());
            return "";
        }
    }

    private static String readStreamAsString(InputStream inputStream) {
        try {
            return Utils.inputStream2String(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    static {
        XMLEncryptUtils.readKey();
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                XMLEncryptUtils.readKey();
            }
        });
    }
}

