/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.background;

import com.fr.base.BaseUtils;
import com.fr.base.BaseXMLUtils;
import com.fr.base.GraphHelper;
import com.fr.base.background.AbstractBackground;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class TextureBackground
extends AbstractBackground {
    private static final long serialVersionUID = 1994011909459388705L;
    private static final Rectangle2D EMBEDED_IMAGE_RECT = new Rectangle2D.Double(0.0, 0.0, 58.0, 42.0);
    private transient TexturePaint texturePaint = null;
    public static final TexturePaint NEWSPRINT_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Newsprint.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint RECYCLED_PAPER_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/RecycledPaper.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint PARCHMENT_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Parchment.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint STATIONERY_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Stationery.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint GREEN_MARBLE_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/GreenMarble.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint WHITE_MARBLE_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/WhiteMarble.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint BROWN_MARBLE_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/BrownMarble.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint GRANITE_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Granite.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint BLUE_TISSUE_PAPER_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/BlueTissuePaper.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint PINK_TISSUE_PAPER_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/PinkTissuePaper.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint PURPLE_MESH_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/PurpleMesh.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint BOUQUET_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Bouquet.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint PAPYRUS_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Papyrus.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint CANVAS_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Canvas.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint DENIM_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Denim.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint WOVEN_MAT_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/WovenMat.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint WATER_DROPLETS_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/WaterDroplets.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint PAPER_BAG_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/PaperBag.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint FISH_FOSSIL_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/FishFossil.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint SAND_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Sand.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint CORK_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Cork.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint WALNUT_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Walnut.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint OAK_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Oak.gif"), EMBEDED_IMAGE_RECT);
    public static final TexturePaint MEDIUM_WOOD_TEXTURE_PAINT = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/MediumWood.gif"), EMBEDED_IMAGE_RECT);

    public TextureBackground() {
        this(null);
    }

    public TextureBackground(TexturePaint texturePaint) {
        this.setTexturePaint(texturePaint);
    }

    public void paint(Graphics graphics, Shape shape) {
        if (this.getTexturePaint() == null || shape == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.getTexturePaint());
        graphics2D.fill(shape);
        graphics2D.setPaint(paint);
    }

    public void drawWithGradientLine(Graphics graphics, Shape shape) {
        if (this.getTexturePaint() == null || shape == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.getTexturePaint());
        graphics2D.draw(shape);
        graphics2D.setPaint(paint);
    }

    public TexturePaint getTexturePaint() {
        return this.texturePaint;
    }

    public void setTexturePaint(TexturePaint texturePaint) {
        this.texturePaint = texturePaint;
    }

    public boolean equals(Object object) {
        return object instanceof TextureBackground && ComparatorUtils.equals(((TextureBackground)object).texturePaint, this.texturePaint);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        return jSONObject;
    }

    public Image getImage() {
        if (this.texturePaint != null) {
            return this.texturePaint.getImage();
        }
        return null;
    }

    public String getBackgroundType() {
        return "TextureBackground";
    }

    public Background readAdditionalAttr(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("TexturePaint")) {
                    TextureBackground.this.setTexturePaint(BaseXMLUtils.readTexturePaint(xMLableReader));
                }
            }
        });
        return this;
    }

    public void writeAdditionalAttr(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.attr("name", "TextureBackground");
        if (this.getTexturePaint() != null) {
            BaseXMLUtils.writeTexturePaint(xMLPrintWriter, this.getTexturePaint());
        }
    }

    private static BufferedImage createBufferedImage(String string) {
        return GraphHelper.createBufferedImageFromImage(BaseUtils.readImage(string));
    }
}

