/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.background;

import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class AreaColor
implements XMLable {
    public static final String XML_TAG = "AreaColor";
    private double minValue;
    private double maxValue;
    private Color color = Color.blue;

    public AreaColor() {
    }

    public AreaColor(double d2, double d3, Color color) {
        this.minValue = d2;
        this.maxValue = d3;
        this.color = color;
    }

    public boolean inArea(double d2) {
        return d2 >= this.minValue && d2 <= this.maxValue;
    }

    public double getMin() {
        return this.minValue;
    }

    public double getMax() {
        return this.maxValue;
    }

    public Color getAreaColor() {
        return this.color;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("minValue", this.minValue);
        jSONObject.put("maxValue", this.maxValue);
        jSONObject.put("color", StableUtils.javaColor2JSColorWithAlpha(this.color));
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && ComparatorUtils.equals(string = xMLableReader.getTagName(), "AC_Attr")) {
            this.minValue = xMLableReader.getAttrAsDouble("minValue", 0.0);
            this.maxValue = xMLableReader.getAttrAsDouble("maxValue", 100.0);
            this.color = xMLableReader.getAttrAsColor("color", Color.blue);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("AC_Attr");
        xMLPrintWriter.attr("minValue", this.minValue).attr("maxValue", this.maxValue);
        if (this.color != null) {
            xMLPrintWriter.attr("color", this.color.getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        AreaColor areaColor = new AreaColor(this.minValue, this.maxValue, this.color);
        return areaColor;
    }

    public boolean equals(Object object) {
        return object instanceof AreaColor && ComparatorUtils.equals(((AreaColor)object).color, this.color) && ((AreaColor)object).minValue != this.minValue && ((AreaColor)object).maxValue != this.maxValue;
    }
}

