/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.ParameterHelper;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.SegmentHandler;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.script.Calculator;
import com.fr.stable.InterpreterError;
import com.fr.stable.StableUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.NameSpace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateUtils {
    public static Pattern ParameterPattern = Pattern.compile("\\$\\{((\\\"[^(\\$\\{)]*\\}[^(\\$\\{)]*\\\")|(\\\"[^(\\$\\{)]*[^\\$]?\\{[^(\\$\\{)]*\\\")|[^\\{\\}])*+\\}");
    private static final Pattern deprecatedParaPattern = Pattern.compile("\\[\\?[^\\]\\?]*\\?\\]");
    private static RenderAction Eval_RenderAction = new RenderAction(){

        public String render(String string, CalculatorProvider calculatorProvider) {
            Object object = null;
            try {
                object = calculatorProvider.evalValue(string);
            }
            catch (UtilEvalError utilEvalError) {
                // empty catch block
            }
            return object == null ? null : GeneralUtils.objectToString(object);
        }
    };

    private TemplateUtils() {
    }

    public static String readTemplate2String(String string, String string2) {
        StringWriter stringWriter = new StringWriter();
        InputStream inputStream = GeneralUtils.readResource(string);
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
            GeneralUtils.copyCharTo(inputStreamReader, stringWriter);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
        return stringWriter.getBuffer().toString();
    }

    public static String render(String string, String string2, Object object) {
        return TemplateUtils.render(string, new String[]{string2}, new Object[]{object});
    }

    public static String render(String string, String[] stringArray, Object[] objectArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            hashMap.put(stringArray[i2], objectArray[i2]);
        }
        try {
            return TemplateUtils.renderParameter4Tpl(string, hashMap);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return string;
        }
    }

    public static String render(String string) throws Exception {
        return TemplateUtils.renderParameter4Tpl(string, Collections.EMPTY_MAP);
    }

    public static String render(String string, Calculator calculator) throws Exception {
        return TemplateUtils.render(string, Collections.EMPTY_MAP, calculator);
    }

    public static String renderParameter4Tpl(String string, Map map) throws Exception {
        Calculator calculator = Calculator.createCalculator();
        String string2 = TemplateUtils.renderTpl((CalculatorProvider)calculator, string, ParameterMapNameSpace.create(map));
        return string2;
    }

    public static String render(String string, Map map, Calculator calculator) throws Exception {
        String string2 = TemplateUtils.renderTpl((CalculatorProvider)calculator, string, ParameterMapNameSpace.create(map));
        return string2;
    }

    public static String render(StringReader stringReader, Map map) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        StringBuffer stringBuffer = new StringBuffer();
        while (bufferedReader.readLine() != null) {
            stringBuffer.append(bufferedReader.readLine());
        }
        String string = "";
        try {
            string = TemplateUtils.renderParameter4Tpl(stringBuffer.toString(), map);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        return string;
    }

    public static String renderTemplate(String string, Map map) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        TemplateUtils.dealWithTemplate(string, printWriter, map);
        return stringWriter.toString();
    }

    public static void dealWithTemplate(String string, PrintWriter printWriter, Map map) throws IOException {
        InputStream inputStream = GeneralUtils.readResource(string);
        if (inputStream == null) {
            throw new IOException("Not found template: " + string);
        }
        TemplateUtils.dealWithTemplate(inputStream, "GBK", printWriter, map);
        inputStream.close();
    }

    public static void dealWithTemplate(InputStream inputStream, String string, PrintWriter printWriter, Map map) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        TemplateUtils.dealWithTemplate(bufferedReader, printWriter, map);
        bufferedReader.close();
    }

    public static void dealWithTemplate(Reader reader, PrintWriter printWriter) throws IOException {
        TemplateUtils.dealWithTemplate(reader, printWriter, Collections.EMPTY_MAP);
    }

    public static void dealWithTemplate(Reader reader, PrintWriter printWriter, Map map) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        while ((string = bufferedReader.readLine()) != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(string);
        }
        String string2 = "";
        try {
            if (map.containsKey("message")) {
                map.put("message", StableUtils.replaceScript4Xss(map.get("message").toString()));
            }
            if (map.containsKey("exception")) {
                map.put("exception", StableUtils.replaceScript4Xss(map.get("exception").toString()));
            }
            string2 = TemplateUtils.renderParameter4Tpl(stringBuffer.toString(), map);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        printWriter.write(string2);
    }

    public static String renderTpl(CalculatorProvider calculatorProvider, String string) {
        try {
            return TemplateUtils.renderTpl(calculatorProvider, string, Eval_RenderAction);
        }
        catch (InterpreterError interpreterError) {
            FRLogger.getLogger().error("parser error:" + string);
            return string;
        }
    }

    public static String renderTpl(CalculatorProvider calculatorProvider, String string, NameSpace nameSpace) {
        calculatorProvider.pushNameSpace(nameSpace);
        String string2 = TemplateUtils.renderTpl(calculatorProvider, string);
        calculatorProvider.removeNameSpace(nameSpace);
        return string2;
    }

    public static String renderTpl(CalculatorProvider calculatorProvider, String string, RenderAction renderAction) {
        if (deprecatedParaPattern.matcher(string).find()) {
            SegmentHandler.QueryCreator queryCreator = new SegmentHandler.QueryCreator(calculatorProvider);
            ParameterHelper.analyzeParametersFromQuery(string, queryCreator);
            return queryCreator.getNewQuery();
        }
        Matcher matcher = ParameterPattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        while (matcher.find()) {
            n3 = matcher.start();
            String string2 = string.substring(n2, n3);
            n2 = matcher.end();
            stringBuffer.append(string2);
            String string3 = matcher.group();
            String string4 = string3.substring(2, string3.length() - 1);
            String string5 = renderAction.render(string4, calculatorProvider);
            if (string5 == null) continue;
            stringBuffer.append(string5);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String i18nTpl(String string) {
        return "${i18n('" + string + "')}";
    }

    public static interface RenderAction {
        public String render(String var1, CalculatorProvider var2);
    }
}

