/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.Parameter;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.stable.FormulaProvider;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.Date;

public class StoreProcedureParameter
extends Parameter {
    private int schema;
    private int type;

    public StoreProcedureParameter() {
        this("", new Object(), 0x7FFFFFFD, -10);
    }

    public StoreProcedureParameter(String string, int n2, int n3) {
        this(string, "", n2, n3);
    }

    public StoreProcedureParameter(String string, Object object, int n2, int n3) {
        this.setName(string);
        this.setSchema(n2);
        this.setType(n3);
        this.setValue(object);
    }

    private static Object sqlType(int n2, String string) {
        switch (n2) {
            case 12: {
                return ComparatorUtils.equals(string, "") ? new String() : String.valueOf(string);
            }
            case 4: {
                return ComparatorUtils.equals(string, "") ? new Integer(1) : new Integer(Integer.parseInt(string));
            }
            case 3: {
                return ComparatorUtils.equals(string, "") ? new Double(1.0) : new Double(Double.parseDouble(string));
            }
            case 16: {
                return ComparatorUtils.equals(string, "") ? Boolean.TRUE : Boolean.valueOf(string);
            }
            case 91: {
                return ComparatorUtils.equals(string, "") ? new Date() : DateUtils.string2Date(string, false);
            }
            case -10: {
                return new Object();
            }
            case 31: {
                return StableFactory.createXmlObject("Formula");
            }
        }
        return new String();
    }

    public Object getValue() {
        if (this.getType() == 31 && this.value instanceof String) {
            FormulaProvider formulaProvider = (FormulaProvider)((Object)StableFactory.createXmlObject("Formula"));
            formulaProvider.setContent((String)this.value);
            this.value = formulaProvider;
        }
        return this.value == null ? "" : this.value;
    }

    public void setValue(Object object) {
        if (this.getType() == 31) {
            FormulaProvider formulaProvider = (FormulaProvider)((Object)StableFactory.createXmlObject("Formula"));
            formulaProvider.setContent(object.toString());
            object = formulaProvider;
        }
        this.value = object instanceof String ? StoreProcedureParameter.sqlType(this.type, (String)object) : object;
    }

    public int getSchema() {
        return this.schema;
    }

    public void setSchema(int n2) {
        this.schema = n2;
    }

    public void setCalculateValue(Object object) {
        if (object instanceof String) {
            this.setType(12);
        }
        this.setValue(object);
    }

    public int getType() {
        if (this.value instanceof String && ((String)this.value).startsWith("=")) {
            return 31;
        }
        return this.type;
    }

    public void setType(int n2) {
        this.type = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[name:" + this.getName() + "]");
        stringBuffer.append("[type:" + this.getType() + "]");
        stringBuffer.append("[schema:" + this.getSchema() + "]");
        stringBuffer.append("[value:" + this.getValue().toString() + "]");
        return stringBuffer.toString();
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attributes").attr("name", this.getName()).attr("type", this.getType()).attr("schema", this.getSchema()).end();
        GeneralXMLTools.writeObject(xMLPrintWriter, this.getValue());
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Object".equals(string) || "O".equals(string)) {
                Object object = GeneralXMLTools.readObject(xMLableReader);
                this.setValue(object);
            } else if ("Attributes".equals(string)) {
                String string2 = xMLableReader.getAttrAsString("name", null);
                if (string2 != null) {
                    this.setName(string2);
                }
                this.setSchema(xMLableReader.getAttrAsInt("schema", 0));
                this.setType(xMLableReader.getAttrAsInt("type", 0));
            }
        }
    }
}

