/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.FRContext;
import com.fr.data.core.db.dialect.OracleDialect;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtils {
    private static Map propertiesCache = new HashMap();
    public static final String INSERT_IGNORE_COLUMN = "insertIgnoreColumn";
    private static Properties sequenceProperties;
    private static boolean isInitSequenceProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String string) {
        Properties properties = (Properties)propertiesCache.get(string);
        if (properties != null) {
            return new Properties(properties);
        }
        properties = PropertiesUtils.initProperties(string);
        Map map = propertiesCache;
        synchronized (map) {
            propertiesCache.put(string, properties);
        }
        return new Properties(properties);
    }

    private static Properties initProperties(String string) {
        Properties properties = new Properties();
        try {
            InputStream inputStream = FRContext.getCurrentEnv().readBean(string + ".properties", "resources");
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initSequenceProperties() {
        if (isInitSequenceProperties) {
            return;
        }
        Class<OracleDialect> clazz = OracleDialect.class;
        synchronized (OracleDialect.class) {
            if (isInitSequenceProperties) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            PropertiesUtils.setSequenceProperties(new Properties());
            try {
                InputStream inputStream = FRContext.getCurrentEnv().readBean("sequence.properties", "resources");
                if (inputStream != null) {
                    PropertiesUtils.getSequenceProperties().load(inputStream);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            isInitSequenceProperties = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Properties getSequenceProperties() {
        return sequenceProperties;
    }

    public static void setSequenceProperties(Properties properties) {
        sequenceProperties = properties;
    }

    static {
        isInitSequenceProperties = false;
    }
}

