/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.MultiFieldParameter;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.DefaultValues;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StableUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.text.ParseException;
import java.util.Date;

public class Parameter
implements ParameterProvider {
    protected String name = null;
    protected Object value = null;
    public static final String STRING = "String";
    public static final String INTEGER = "Integer";
    public static final String DOUBLE = "Double";
    public static final String DATE = "Date";
    public static final String BOOLEAN = "Boolean";
    public static final String FORMULA = "Formula";
    public static final String LONG = "Long";
    public static final String MULTI = "Multi";
    public static final String JSONARRAY = "JSONArray";

    public Parameter() {
        this("");
    }

    public Parameter(String string) {
        this(string, "");
    }

    public Parameter(String string, Object object) {
        this.setName(string);
        this.setValue(object);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public void setCalculateValue(Object object) {
        this.value = object;
    }

    public String xmlTag() {
        return "Parameter";
    }

    public String arrayXMLTag() {
        return "Parameters";
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("Object".equals(string2) || "O".equals(string2)) {
                Object object = GeneralXMLTools.readObject(xMLableReader);
                this.setValue(object);
            } else if ("Attributes".equals(string2) && (string = xMLableReader.getAttrAsString("name", null)) != null) {
                this.setName(string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attributes").attr("name", this.getName()).end();
        if (this.getValue() != null) {
            GeneralXMLTools.writeObject(xMLPrintWriter, this.getValue());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Parameter parameter = (Parameter)super.clone();
        if (this.value != null) {
            parameter.value = StableUtils.cloneObject(this.value);
        }
        return parameter;
    }

    public String toString() {
        return "$" + this.getName();
    }

    public String valueToString() {
        String string = "";
        if (this.value != null) {
            if (this.value instanceof FormulaProvider) {
                Object object = ((FormulaProvider)this.value).getResult();
                if (object == null) {
                    try {
                        object = Calculator.createCalculator().evalValue(((FormulaProvider)this.value).getContent().substring(1));
                    }
                    catch (Exception exception) {
                        FRLogger.getLogger().error(exception.getMessage(), exception);
                    }
                }
                if (object != null) {
                    return object.toString();
                }
                return "";
            }
            if (this.value instanceof Date) {
                DefaultValues defaultValues = GeneralContext.getDefaultValues();
                string = defaultValues.getDateTimeFormat().format(this.value);
            } else {
                string = this.value instanceof Double ? StableUtils.doubleToString((Double)this.value) : this.value.toString();
            }
        }
        return string;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = 31 * n2 + (this.value == null ? 0 : this.value.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        return object instanceof Parameter && ComparatorUtils.equals(this.name, ((Parameter)object).name) && ComparatorUtils.equals(this.value, ((Parameter)object).value);
    }

    public static Parameter[] providers2Parameter(ParameterProvider[] parameterProviderArray) {
        if (ArrayUtils.isEmpty(parameterProviderArray)) {
            return new Parameter[0];
        }
        Parameter[] parameterArray = new Parameter[parameterProviderArray.length];
        int n2 = parameterProviderArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            parameterArray[i2] = (Parameter)parameterProviderArray[i2];
        }
        return parameterArray;
    }

    public static Parameter getParameterFromJson(JSONObject jSONObject) throws JSONException {
        Parameter parameter = new Parameter();
        parameter.setName(jSONObject.getString("name"));
        String string = jSONObject.getString("type");
        if (jSONObject.has("value")) {
            if (STRING.equals(string)) {
                parameter.setValue(jSONObject.getString("value"));
            } else if (INTEGER.equals(string)) {
                parameter.setValue(Integer.valueOf(jSONObject.getString("value")));
            } else if (DOUBLE.equals(string)) {
                parameter.setValue(Double.valueOf(jSONObject.getString("value")));
            } else if (LONG.equals(string)) {
                parameter.setValue(Long.valueOf(jSONObject.getString("value")));
            } else if (DATE.equals(string)) {
                String string2 = jSONObject.getString("value");
                try {
                    parameter.setValue(DateUtils.DATEFORMAT2.parse(string2));
                }
                catch (ParseException parseException) {
                    FRLogger.getLogger().error(parseException.getMessage(), parseException);
                }
            } else if (BOOLEAN.equals(string)) {
                parameter.setValue(jSONObject.getBoolean("value"));
            } else if (FORMULA.equals(string)) {
                FormulaProvider formulaProvider = (FormulaProvider)((Object)StableFactory.createXmlObject(FORMULA));
                formulaProvider.setContent(jSONObject.getString("value"));
                parameter.setValue(formulaProvider);
            } else if (MULTI.equals(string) || JSONARRAY.equals(string)) {
                MultiFieldParameter multiFieldParameter = new MultiFieldParameter(parameter.getName());
                JSONArray jSONArray = jSONObject.getJSONArray("value");
                multiFieldParameter.parseValueJSON(jSONArray);
                return multiFieldParameter;
            }
        }
        return parameter;
    }

    public static JSONArray parameters2JSONString(Parameter[] parameterArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < parameterArray.length; ++i2) {
            String string;
            JSONObject jSONObject = new JSONObject();
            Parameter parameter = parameterArray[i2];
            jSONObject.put("name", parameter.getName());
            if (parameter.getValue() instanceof Date) {
                string = DateUtils.DATEFORMAT2.format(parameter.getValue());
                jSONObject.put("value", string);
            } else {
                jSONObject.put("value", parameter.getValue());
            }
            string = parameter.getValue().getClass().getName();
            int n2 = string.lastIndexOf(46) + 1;
            if (n2 > 0) {
                string = string.substring(n2);
            }
            jSONObject.put("type", string);
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }
}

