/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.BaseUtils;
import com.fr.base.Icon;
import com.fr.data.DataUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.ListMap;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.Service;
import com.fr.stable.web.BrowserProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IconManager
implements XMLable,
Service {
    public static final String XML_TAG = "IM";
    private static ListMap iconMap = new ListMap();
    private static List systemIconList = new ArrayList();
    public static final Icon SUBMIT = IconManager.getDefaultIcon("submit", "/com/fr/web/images/save.png");
    public static final Icon SUBMITALL = IconManager.getDefaultIcon("submitall", "/com/fr/web/images/save.png");
    public static final Icon SUBMITFORCILY = IconManager.getDefaultIcon("submitforcily", "/com/fr/web/images/save2.png");
    public static final Icon FIRST = IconManager.getDefaultIcon("first", "/com/fr/web/images/first.png");
    public static final Icon PREVIOUS = IconManager.getDefaultIcon("previous", "/com/fr/web/images/previous.png");
    public static final Icon NEXT = IconManager.getDefaultIcon("next", "/com/fr/web/images/next.png");
    public static final Icon LAST = IconManager.getDefaultIcon("last", "/com/fr/web/images/last.png");
    public static final Icon RELOAD = IconManager.getDefaultIcon("reload", "/com/fr/web/images/reload.png");
    public static final Icon PAGESETUP = IconManager.getDefaultIcon("pagesetup", "/com/fr/web/images/pageSetup.png");
    public static final Icon FLASHPRINT = IconManager.getDefaultIcon("flashprint", "/com/fr/web/images/flashPrint.png");
    public static final Icon PDFPRINT = IconManager.getDefaultIcon("pdfprint", "/com/fr/web/images/pdfPrint.png");
    public static final Icon APPLETPRINT = IconManager.getDefaultIcon("appletprint", "/com/fr/web/images/appletPrint.png");
    public static final Icon PDF = IconManager.getDefaultIcon("pdf", "/com/fr/web/images/pdf.png");
    public static final Icon EXCEL = IconManager.getDefaultIcon("excel", "/com/fr/web/images/excel.png");
    public static final Icon WORD = IconManager.getDefaultIcon("word", "/com/fr/web/images/word.png");
    public static final Icon IMAGE = IconManager.getDefaultIcon("image", "/com/fr/web/images/image.png");
    public static final Icon HTML = IconManager.getDefaultIcon("html", "/com/fr/web/images/bmp.png");
    public static final Icon BMP = IconManager.getDefaultIcon("bmp", "/com/fr/web/images/bmp.png");
    public static final Icon JPG = IconManager.getDefaultIcon("jpg", "/com/fr/web/images/jpg.png");
    public static final Icon GIF = IconManager.getDefaultIcon("gif", "/com/fr/web/images/gif.png");
    public static final Icon PNG = IconManager.getDefaultIcon("png", "/com/fr/web/images/png.png");
    public static final Icon PRINT = IconManager.getDefaultIcon("print", "/com/fr/web/images/print.png");
    public static final Icon EXPORT = IconManager.getDefaultIcon("export", "/com/fr/web/images/export.png");
    public static final Icon EMAIL = IconManager.getDefaultIcon("email", "/com/fr/web/images/email.png");
    public static final Icon FROZEN = IconManager.getDefaultIcon("frozzen", "/com/fr/web/images/frozen.png");
    public static final Icon DEFAULT = IconManager.getDefaultIcon("default", "/com/fr/web/images/default.png");
    public static final Icon DELETECOLUMN = IconManager.getDefaultIcon("deletecolumn", "/com/fr/web/images/deleteColumn.png");
    public static final Icon DELETEROW = IconManager.getDefaultIcon("deleterow", "/com/fr/web/images/deleteRow.png");
    public static final Icon APPENDCOLUMN = IconManager.getDefaultIcon("appendcolumn", "/com/fr/web/images/appendColumn.png");
    public static final Icon APPENDROW = IconManager.getDefaultIcon("appendrow", "/com/fr/web/images/appendRow.png");
    public static final Icon VERIFY = IconManager.getDefaultIcon("verify", "/com/fr/web/images/verify.gif");
    public static final Icon WRITEOFFLINE = IconManager.getDefaultIcon("writeoffline", "/com/fr/web/images/writeOffline.png");
    public static final Icon CLEAR = IconManager.getDefaultIcon("clear", "/com/fr/web/images/writeClear.png");
    public static final Icon UNDO = IconManager.getDefaultIcon("undo", "/com/fr/web/images/writeUndo.png");
    public static final Icon REDO = IconManager.getDefaultIcon("redo", "/com/fr/web/images/writeRedo.png");
    public static final Icon VIEWPROCESS = IconManager.getDefaultIcon("viewprocess", "/com/fr/web/core/process/reportprocess/web/images/viewprocess.png");
    public static final Icon ADD = IconManager.getDefaultIcon("add", "/com/fr/web/images/add.png");
    public static final Icon DELETE = IconManager.getDefaultIcon("delete", "/com/fr/web/images/delete.png");
    public static final Icon OK = IconManager.getDefaultIcon("ok", "/com/fr/web/images/ok.png");
    public static final Icon PREVIEW = IconManager.getDefaultIcon("preview", "/com/fr/web/images/preview.png");
    public static final Icon EDIT = IconManager.getDefaultIcon("edit", "/com/fr/web/images/edit.png");
    public static final Icon SORT = IconManager.getDefaultIcon("sort", "/com/fr/web/images/sort.png");
    public static final Icon ASCEND = IconManager.getDefaultIcon("ascend", "/com/fr/web/images/ascend.png");
    public static final Icon DESCEND = IconManager.getDefaultIcon("descend", "/com/fr/web/images/descend.png");
    public static final Icon FILTER = IconManager.getDefaultIcon("filter", "/com/fr/web/images/filter.png");
    public static final Icon SETPRINTEROFFSET = IconManager.getDefaultIcon("setprinteroffset", "/com/fr/web/images/pianyi.png");
    public static final String OP = "toolbar_icon";
    private static final String ICONCLASSNAME = "x-emb-";
    private IconInfo[] iis = null;
    private byte[] allInOneImageBytes = null;
    private Map iconImageBytesCacheMap = new HashMap();
    private StringBuffer iconCss = new StringBuffer();
    private StringBuffer iconCss2 = new StringBuffer();
    private int mark4Init = 0;
    public static final int DEFAULT_ICONWIDTH = 16;
    public static final int DEFAULT_ICONHEIGHT = 16;
    public static final String ICONRESOURCE = "icon_name_";
    private static final int SPACING = 2;
    private static long lastModified = System.currentTimeMillis();
    private static boolean cssChange = false;
    private static IconManager manager = null;

    public static synchronized IconManager getIconManager() {
        if (manager == null) {
            manager = new IconManager();
        }
        return manager;
    }

    private IconManager() {
    }

    public void refreshCss() {
        this.mark4Init = 0;
        this.iconCss = new StringBuffer();
    }

    private static Icon getDefaultIcon(String string, String string2) {
        string = string.toLowerCase();
        Icon icon = new Icon(string, string2);
        icon.setImage(IconManager.getIconManager().getDefaultIconImage(icon));
        iconMap.put(string, icon);
        systemIconList.add(string);
        return icon;
    }

    private void init4Image() {
        Rectangle rectangle;
        Dimension dimension = new Dimension(0, 0);
        this.iis = new IconInfo[iconMap.size()];
        ImageInfo[] imageInfoArray = new ImageInfo[iconMap.size()];
        this.collectImageInfo(imageInfoArray, dimension);
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(dimension.width, dimension.height);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        for (int i2 = 0; i2 < this.iis.length; ++i2) {
            if (imageInfoArray[i2] == null) continue;
            rectangle = imageInfoArray[i2].getRectangle();
            Image image = imageInfoArray[i2].getImage();
            Shape shape = graphics2D.getClip();
            graphics2D.clip(rectangle);
            graphics2D.drawImage(image, rectangle.x, rectangle.y, null);
            graphics2D.setClip(shape);
        }
        bufferedImage.flush();
        graphics2D.dispose();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GeneralUtils.writeImage(bufferedImage, "png", byteArrayOutputStream);
        this.allInOneImageBytes = byteArrayOutputStream.toByteArray();
        for (int i3 = 0; i3 < this.iis.length; ++i3) {
            if (imageInfoArray[i3] == null || this.iis[i3] == null) continue;
            rectangle = imageInfoArray[i3].getRectangle();
            this.iis[i3].setCss(rectangle.x + "px " + "-" + rectangle.y + "px");
        }
    }

    private void collectImageInfo(ImageInfo[] imageInfoArray, Dimension dimension) {
        Image image = null;
        for (int i2 = 0; i2 < iconMap.size(); ++i2) {
            Icon icon = (Icon)iconMap.getByIndex(i2);
            String string = icon.getPath();
            String string2 = icon.getName();
            if (StringUtils.isBlank(string2)) continue;
            if (this.isSystemIcon(string2)) {
                if (!string.startsWith("/") && !string.startsWith("\\")) {
                    string = File.separator + string;
                }
                image = BaseUtils.readImage(string);
                icon.setImage(image);
            } else {
                image = icon.getImage();
                if (image != null) {
                    string = ICONRESOURCE + string2;
                }
            }
            this.iis[i2] = new IconInfo(string2, ICONRESOURCE + string2);
            if (image != null) {
                int n2 = image.getWidth(null);
                n2 = n2 > -1 ? n2 : 16;
                int n3 = image.getHeight(null);
                n3 = n3 > -1 ? n3 : 16;
                Rectangle rectangle = new Rectangle(0, dimension.height, n2, n3);
                dimension.height += n3 + 2;
                dimension.width = dimension.width > n2 ? dimension.width : n2;
                imageInfoArray[i2] = new ImageInfo(image, rectangle);
                continue;
            }
            imageInfoArray[i2] = null;
        }
    }

    private void init4Css(String string) {
        for (int i2 = 0; i2 < this.iis.length; ++i2) {
            if (this.iis[i2] == null || this.iis[i2].getCss() == null) continue;
            this.iconCss.append('.').append(ICONCLASSNAME).append(this.iis[i2].getName()).append("{background-image:").append("url(").append(this.getAllInOneImageUrl(string)).append(") !important;").append("background-repeat:no-repeat !important;").append("background-position:").append(this.iis[i2].getCss()).append(" !important").append(";\n}\n");
            this.iconCss2.append('.').append(ICONCLASSNAME).append(this.iis[i2].getName()).append("{\n").append("filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(this.getAllInOneImagePath(string, this.iis[i2].getPath())).append("') !important;\n}\n");
        }
    }

    public String getCssInfo(String string, String string2) {
        if (string == null) {
            return "";
        }
        string = string.toLowerCase();
        this.checkInit(string2);
        if (this.iis != null) {
            for (int i2 = 0; i2 < this.iis.length; ++i2) {
                if (this.iis[i2] == null || this.iis[i2].getName() == null || !ComparatorUtils.equals(this.iis[i2].getName(), string)) continue;
                return new StringBuffer().append("css:").append(ICONCLASSNAME).append(this.iis[i2].getName()).toString();
            }
        }
        return "";
    }

    private void checkInit(String string) {
        if (this.mark4Init <= 0) {
            this.init4Image();
            if (StringUtils.isNotBlank(string)) {
                this.init4Css(string);
                this.mark4Init = 1;
            }
        }
    }

    public String getCssFile(String string, BrowserProvider browserProvider) {
        this.checkInit(string);
        if (browserProvider.supportTransparentImage()) {
            return this.iconCss.toString();
        }
        return this.iconCss2.toString();
    }

    public static long getLastModified() {
        return lastModified;
    }

    public static boolean isCssChange() {
        return cssChange;
    }

    public static void setCssChange(boolean bl) {
        cssChange = bl;
    }

    public byte[] getAllInOneImageBytes(String string) {
        this.checkInit(string);
        if (this.allInOneImageBytes != null) {
            return this.allInOneImageBytes;
        }
        return new byte[0];
    }

    public byte[] getIconImage4Web(String string, String string2) {
        this.checkInit(string);
        String string3 = string2.substring(ICONRESOURCE.length());
        if (string3 == null) {
            return new byte[0];
        }
        if (this.iconImageBytesCacheMap.containsKey(string3 = string3.toLowerCase())) {
            return (byte[])this.iconImageBytesCacheMap.get(string3);
        }
        Image image = this.getIconImage(string3);
        if (image != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GeneralUtils.writeImage(image, "png", byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.iconImageBytesCacheMap.put(string3, byArray);
            return byArray;
        }
        return new byte[0];
    }

    private String getAllInOneImageUrl(String string) {
        return new StringBuffer().append(string).append("?op=").append(OP).append("&id=toolbar-image.png").toString();
    }

    private String getAllInOneImagePath(String string, String string2) {
        return new StringBuffer().append(string).append("?op=").append(OP).append("&id=").append(string2).toString();
    }

    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        string = string.toLowerCase();
        return iconMap.containsKey(string);
    }

    public boolean addIcon(Icon icon, boolean bl) {
        if (icon == null || StringUtils.isBlank(icon.getName()) || icon.getImage() == null) {
            return false;
        }
        String string = icon.getName().toLowerCase();
        icon.setName(string);
        if (iconMap.containsKey(string) && !bl) {
            return false;
        }
        iconMap.put(string, icon);
        this.mark4Init = 0;
        lastModified = System.currentTimeMillis();
        cssChange = true;
        return true;
    }

    public boolean removeIcon(String string) {
        if (StringUtils.isBlank(string)) {
            return false;
        }
        if (iconMap.remove(string = string.toLowerCase()) != null) {
            this.mark4Init = 0;
            lastModified = System.currentTimeMillis();
            cssChange = true;
            return true;
        }
        return false;
    }

    public int getIconCount() {
        return iconMap.size();
    }

    public boolean isSystemIcon(String string) {
        if (string == null) {
            return false;
        }
        string = string.toLowerCase();
        return systemIconList.contains(string);
    }

    public Image getIconImage(String string) {
        Image image;
        if (string == null) {
            return null;
        }
        Icon icon = this.getIcon4Self(string = string.toLowerCase());
        if (icon == null) {
            return null;
        }
        if (icon.getImage() != null) {
            image = icon.getImage();
        } else {
            String string2 = icon.getPath();
            if (StringUtils.isBlank(string2)) {
                return null;
            }
            if (!string2.startsWith("/") && !string2.startsWith("\\")) {
                string2 = File.separator + string2;
            }
            image = BaseUtils.readImage(string2);
            icon.setImage(image);
        }
        return image;
    }

    public Image getDefaultIconImage(Icon icon) {
        Image image;
        if (icon.getImage() != null) {
            image = icon.getImage();
        } else {
            String string = icon.getPath();
            if (StringUtils.isBlank(string)) {
                return null;
            }
            if (!string.startsWith("/") && !string.startsWith("\\")) {
                string = File.separator + string;
            }
            image = BaseUtils.readImage(string);
            icon.setImage(image);
        }
        return image;
    }

    public Icon getIcon(Object object) throws CloneNotSupportedException {
        if (object == null || !(object instanceof String)) {
            return null;
        }
        String string = ((String)object).toLowerCase();
        return iconMap.get(string) == null ? null : (Icon)((Icon)iconMap.get(string)).clone();
    }

    private Icon getIcon4Self(Object object) {
        if (object == null || !(object instanceof String)) {
            return null;
        }
        String string = ((String)object).toLowerCase();
        return (Icon)iconMap.get(string);
    }

    public Object[] getIconNames() {
        return iconMap.keySet().toArray();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            Icon icon = new Icon();
            if (Icon.XML_TAG.equals(string)) {
                xMLableReader.readXMLObject(icon);
            }
            this.addIcon(icon, false);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (iconMap != null && iconMap.size() > 0) {
            for (int i2 = 0; i2 < iconMap.size(); ++i2) {
                Icon icon = (Icon)iconMap.getByIndex(i2);
                if (this.isSystemIcon(icon.getName())) continue;
                icon.writeXML(xMLPrintWriter);
            }
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        IconManager iconManager = (IconManager)super.clone();
        return iconManager;
    }

    public String actionOP() {
        return OP;
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws Exception {
        httpServletResponse.setContentType("image/png");
        String string3 = DataUtils.getHTTPRequestParameter(httpServletRequest, "id");
        byte[] byArray = null;
        if (string3 != null) {
            if (string3.startsWith(ICONRESOURCE)) {
                byArray = this.getIconImage4Web(DataUtils.createServletURL(httpServletRequest), string3);
            } else if (ComparatorUtils.equals(string3, "toolbar-image.png")) {
                byArray = this.getAllInOneImageBytes(DataUtils.createServletURL(httpServletRequest));
            }
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            servletOutputStream.write(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ImageInfo {
        private Image image;
        private Rectangle rectangle;

        public ImageInfo(Image image, Rectangle rectangle) {
            this.setImage(image);
            this.setRectangle(rectangle);
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public Rectangle getRectangle() {
            return this.rectangle;
        }

        public void setRectangle(Rectangle rectangle) {
            this.rectangle = rectangle;
        }
    }

    private static class IconInfo {
        private String name;
        private String path;
        private String css;

        public IconInfo(String string, String string2, String string3) {
            this.setName(string);
            this.setPath(string2);
            this.setCss(string3);
        }

        public IconInfo(String string, String string2) {
            this(string, string2, null);
        }

        public String getCss() {
            return this.css;
        }

        public void setCss(String string) {
            this.css = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String string) {
            this.path = string;
        }
    }
}

