/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.stable.FormulaProvider;
import com.fr.stable.StableUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDateUtil;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;

public class ExcelUtils {
    private static char ASCII_NORMAL = (char)32;
    private static char ASCII_LATIN = (char)160;
    private static double rate = 0.75;
    private static int n = 4;
    private static int increase_30 = 30;
    private static int colWidth_20 = 20;
    private static int colWidth_40 = 40;
    private static int colWidth_50 = 50;
    private static int colWidth_70 = 70;
    private static int JDK_5 = 5;
    private static final Pattern PATTERN_$_COLUMNROW_1 = Pattern.compile("[\\$]{1}[a-zA-Z]+[\\$]?[1-9][0-9]*");
    private static final Pattern PATTERN_$_COLUMNROW_2 = Pattern.compile("[a-zA-Z]+[\\$]{1}[1-9][0-9]*");
    private static final Pattern PATTERN_$ = Pattern.compile("\\$");

    public static short printWidth2Design(short s2) {
        if (s2 <= 0) {
            return 0;
        }
        s2 = (short)((double)s2 * rate);
        short s3 = (short)((s2 + increase_30) / colWidth_70 * n);
        short s4 = (short)((s2 + increase_30) % colWidth_70);
        if (s4 < 0 || s4 >= colWidth_20) {
            if (s4 >= colWidth_20 && s4 < colWidth_40) {
                s3 = (short)(s3 + 1);
            } else if (s4 >= colWidth_40 && s4 <= colWidth_50) {
                s3 = (short)(s3 + 2);
            } else if (s4 > colWidth_50 && s4 < colWidth_70) {
                s3 = (short)(s3 + 3);
            }
        }
        return (short)(s2 - s3);
    }

    public static Object getHSSFCellValue(HSSFCell hSSFCell) {
        Object object;
        block18: {
            if (hSSFCell == null) {
                return "";
            }
            object = null;
            if (hSSFCell.getCellType() == 1) {
                char[] cArray = hSSFCell.getRichStringCellValue().getString().toCharArray();
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    char c2 = cArray[i2];
                    if (cArray[i2] != ASCII_LATIN) continue;
                    cArray[i2] = ASCII_NORMAL;
                }
                return String.valueOf(cArray);
            }
            if (hSSFCell.getCellType() == 0) {
                if (HSSFDateUtil.isCellDateFormatted((HSSFCell)hSSFCell)) {
                    return hSSFCell.getDateCellValue();
                }
                object = StableUtils.string2Number(StableUtils.convertNumberStringToString(new Double(hSSFCell.getNumericCellValue()), true));
            } else if (hSSFCell.getCellType() == 4) {
                object = hSSFCell.getBooleanCellValue() ? Boolean.TRUE : Boolean.FALSE;
            } else if (hSSFCell.getCellType() == 2) {
                try {
                    String string = hSSFCell.getCellFormula();
                    if (string != null) {
                        if (string.trim().matches("^[\\=]+$")) {
                            object = string;
                        } else {
                            string = ExcelUtils.resolveDColumnRowFString(string);
                            object = ExcelUtils.string2formula(string);
                        }
                        break block18;
                    }
                    object = ExcelUtils.string2formula(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (hSSFCell.getCellType() == 5) {
                object = "" + hSSFCell.getErrorCellValue();
            } else if (hSSFCell.getCellType() == 3) {
                object = "";
            }
        }
        return object;
    }

    public static Object getCellValue(Cell cell) {
        Object object = null;
        if (cell.getCellType() == 3) {
            object = "";
        } else if (cell.getCellType() == 4) {
            object = cell.getBooleanCellValue() ? Boolean.TRUE : Boolean.FALSE;
        } else if (cell.getCellType() == 5) {
            object = "" + cell.getErrorCellValue();
        } else if (cell.getCellType() == 0) {
            object = DateUtil.isCellDateFormatted((Cell)cell) ? cell.getDateCellValue() : StableUtils.string2Number(StableUtils.convertNumberStringToString(new Double(cell.getNumericCellValue()), true));
        } else if (cell.getCellType() == 1) {
            char[] cArray = cell.getRichStringCellValue().getString().toCharArray();
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                char c2 = cArray[i2];
                if (cArray[i2] != ASCII_LATIN) continue;
                cArray[i2] = ASCII_NORMAL;
            }
            object = String.valueOf(cArray);
        } else if (cell.getCellType() == 2) {
            String string = cell.getCellFormula();
            if (string != null) {
                if (string.trim().matches("^[\\=]+$")) {
                    object = string;
                } else {
                    string = ExcelUtils.resolveDColumnRowFString(string);
                    object = ExcelUtils.string2formula(string);
                }
            } else {
                object = ExcelUtils.string2formula(string);
            }
        }
        return object;
    }

    private static FormulaProvider string2formula(String string) {
        FormulaProvider formulaProvider = (FormulaProvider)((Object)StableFactory.createXmlObject("Formula"));
        formulaProvider.setContent(string);
        return formulaProvider;
    }

    private static String resolveDColumnRowFString(String string) {
        string = ExcelUtils.resolveDColumnRowFString(PATTERN_$_COLUMNROW_1, string);
        return ExcelUtils.resolveDColumnRowFString(PATTERN_$_COLUMNROW_2, string);
    }

    private static String resolveDColumnRowFString(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group();
            string2 = PATTERN_$.matcher(string2).replaceAll("");
            matcher.appendReplacement(stringBuffer, string2);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static boolean checkPOIJarExist() {
        if (StableUtils.getMajorJavaVersion() < JDK_5) {
            return false;
        }
        InputStream inputStream = null;
        try {
            inputStream = GeneralContext.getEnvProvider().readBean("poi2007_fat.jar", "lib");
            if (inputStream == null) {
                return false;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return true;
    }

    public static void checkPOI() {
        if (!ExcelUtils.checkPOIJarExist()) {
            throw new RuntimeException(Inter.getLocText("NS_excel_poi"));
        }
    }
}

