/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class CustomConfigManager
extends XMLFileManager {
    public static final String REPORT_PREFIX = "reportPrefix";
    private String reportPrefix = "";
    private static CustomConfigManager configManager = null;

    public static synchronized CustomConfigManager getInstance() {
        if (configManager == null) {
            configManager = new CustomConfigManager();
            configManager.readXMLFile();
        }
        return configManager;
    }

    private static synchronized void envChanged() {
        configManager = null;
    }

    private CustomConfigManager() {
    }

    public String getReportPrefix() {
        return this.reportPrefix;
    }

    public void setReportPrefix(String string) {
        this.reportPrefix = string;
    }

    public String fileName() {
        return "customconfig.xml";
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (xMLableReader.isChildNode() && ComparatorUtils.equals(REPORT_PREFIX, string)) {
            String string2 = xMLableReader.getAttrAsString("prefix", "");
            if (!StringUtils.isEmpty(string2 = string2.replaceAll("\\\\", "/")) && !string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            this.setReportPrefix(string2);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                CustomConfigManager.envChanged();
            }
        });
    }
}

