package com.gtis.fileCenter.web;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.generic.util.JsonUtils;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by jane on 14-2-27.
 * 文件中心服务
 */
@RequestMapping(value = "/uploadPage")
public class uploadPageController extends BaseController {
    public static final String ACCESS_CONTROL_ALLOW_ORIGN = "Access-Control-Allow-Origin";

	/** 文件中心的表空间 */
    public static final String WORK_FLOW_STUFF = "WORK_FLOW_STUFF";

    @RequestMapping(value = "/uploadPage",method = RequestMethod.GET)
    public ModelAndView uploadPage(HttpServletResponse response, Model model, String proid, String readOnly, String type, HttpServletRequest request){
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGN,"*");
        //获得工作流附件工作流空间节点Id
        Space space = nodeService.getWorkSpace(WORK_FLOW_STUFF,true);
        Node prjNode = nodeService.getNode(space.getId(), proid,true);
        Integer rootId = prjNode.getId();
        //获得工作流文件中心节点访问令牌
        String token = nodeService.getToken(prjNode);
        Map params = new HashMap();
        params.put("disable",false);
        params.put("rootId",rootId.toString());
        params.put("token",token);
        params.put("readOnly",readOnly);
        model.addAttribute("rootId",rootId.toString());
        model.addAttribute("token",token);
        model.addAttribute("readOnly",readOnly);
        request.setAttribute("params", JsonUtils.toString(params));
        return new ModelAndView("fileUpload1");
    }

   /* @RequestMapping(value = "/uploadPage1",method = RequestMethod.GET)
    public ModelAndView uploadPage1(HttpServletResponse response, Model model, String proid, String readOnly, String type, HttpServletRequest request){
        uploadPage1(response, model, proid, readOnly, type, request);
        return new ModelAndView("fileUpload1");
    }*/
}
