/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: JsonExceptionResolver.java
 *
 * LastModified: 2009-09-25 04:45:57
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.web;

import com.gtis.fileCenter.ex.*;
import com.gtis.generic.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-25
 */
public class JsonExceptionResolver implements HandlerExceptionResolver {
    private static final Logger logger = LoggerFactory.getLogger(JsonExceptionResolver.class);
    private Integer defaultStatusCode = HttpServletResponse.SC_INTERNAL_SERVER_ERROR;

    public void setDefaultStatusCode(Integer defaultStatusCode) {
        this.defaultStatusCode = defaultStatusCode;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        logger.debug("Resolving exception from handler [" + handler + "]", ex);

        Map<String, Serializable> map = new HashMap<String, Serializable>();
        int errType = 0;
        if (ex instanceof NodeNotFoundException) {
            errType = 1;
        } else if (ex instanceof NodeExistsException) {
            errType = 2;
        } else if (ex instanceof FileIOException) {
            errType = 3;
        } else if (ex instanceof CapabilityNotEnoughException) {
            errType = 4;
        } else if (ex instanceof DataAccessException) {
            errType = 5;
        } else if (ex instanceof NoPermissionException) {
            errType = 6;
        }
        map.put("type", errType);
        map.put("msg", ex.getMessage());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(os));
        map.put("detail", os.toString());
        response.setStatus(defaultStatusCode);
        request.setAttribute("fc_error", JsonUtils.toString(map));
        return new ModelAndView("error");
    }
}
