package com.gtis.fileCenter.web;

import com.gtis.fileCenter.model.PreviewFile;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.service.FileStoreService;
import com.gtis.fileCenter.service.MimeTypeService;
import com.gtis.fileCenter.service.NodeService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.util.UrlPathHelper;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 13-1-24
 */
@Controller
public class DocController {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    @Autowired
    protected NodeService nodeService;
    @Autowired
    private FileStoreService fileService;
    @Autowired
    private MimeTypeService mimeTypeService;

    @RequestMapping(value = "/doc/**")
    public String doc(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = urlPathHelper.getLookupPathForRequest(request);
        int index = path.indexOf('/', 5);
        String id = index > -1 ? path.substring(5, index) : path.substring(1);
        String name = index > -1 ? path.substring(index + 1) : null;
        if (StringUtils.isEmpty(name)) {
            name = "0.htm";
        }
        File file = (File) nodeService.getNode(Integer.parseInt(id));
        response.reset();
        response.setContentType(mimeTypeService.getMimeType(name)+"; charset=gbk");
        fileService.transferZipContainedFileTo(new PreviewFile(file), name, response.getOutputStream());
        return null;
    }
}
