package com.gtis.fileCenter.service.impl;

import com.gtis.fileCenter.Constants;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.service.NodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-12
 */
public abstract class FileIndexOwnerDetector implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(FileIndexOwnerDetector.class);
    private NodeService nodeService;
    private String spaceName;
    private String spacePath;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public Owner detect(File file) {
        if (spacePath != null) {
            String path = file.getPath();
            int i = path.indexOf(spacePath);
            if (i > -1) {
                i += spacePath.length() + 1;
                int end = path.indexOf(Constants.SEPARATOR, i);
                String idStr = end == -1 ? path.substring(i) : path.substring(i, end);
                return getOwner(nodeService.getNode(Integer.valueOf(idStr)).getName());
            }
        }
        return null;
    }

    protected abstract Owner getOwner(String ownerId);

    public void afterPropertiesSet() throws Exception {
        Space space = null;
        try {
            space = nodeService.getWorkSpace(spaceName);
        } catch (NodeNotFoundException e) {
            LOG.error("Index detector form space [" + space + "] init error," + e.getMessage());
        }
        if (space != null) {
            spacePath = space.getPath() + space.getId();
        }
    }

    public final class Owner {
        private String ownerId;
        private String businessId;
        private String categoryId;

        public Owner(String ownerId, String businessId, String categoryId) {
            this.ownerId = ownerId;
            this.businessId = businessId;
            this.categoryId = categoryId;
        }

        public String getOwnerId() {
            return ownerId;
        }

        public String getBusinessId() {
            return businessId;
        }

        public String getCategoryId() {
            return categoryId;
        }
    }
}
