package com.gtis.fileCenter.service.impl;

import com.gtis.fileCenter.NodeHelper;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.search.Category;
import com.gtis.search.EntityIndexProvider;
import com.gtis.search.IndexManager;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashSet;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-12
 */
public class FileIndexAspect {

    private static final Logger LOG = LoggerFactory.getLogger(FileIndexAspect.class);
    private NodeService nodeService;
    private IndexManager indexManager;
    private EntityIndexProvider<File> indexProvider;
    private Set<String> spaceNames = new HashSet<String>();

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public void setIndexProvider(EntityIndexProvider<File> indexProvider) {
        this.indexProvider = indexProvider;
        for (Category cat : indexProvider.getDefaultBusiness().getCategories()) {
            spaceNames.add(cat.getId());
        }
    }

    public void save(Node node) throws Throwable {
        try {
            if (node instanceof File && spaceNames.contains(nodeService.getSpace(node.getId()).getName())) {
                indexManager.update(indexProvider.toIndex((File) node));
            }
        } catch (Throwable e) {
            LOG.error("Error to save index", e);
        }
    }

    public Object remove(ProceedingJoinPoint joinPoint) throws Throwable {
        Node node = nodeService.getNode((Integer) joinPoint.getArgs()[0]);
        boolean needRemoveIndex = false;
        if (node instanceof File) {
            Space space = nodeService.getSpace(node.getId());
            if (spaceNames.contains(space.getName())) {
                needRemoveIndex = true;
            }
        }
        Object retVal = joinPoint.proceed();
        if (needRemoveIndex) {
            indexManager.remove(NodeHelper.toIndexId(node.getId()));
        }
        return retVal;
    }

}
