/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FileStorePropSaveJob.java
 *
 * LastModified: 2009-09-21 11:48:02
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.scheduling;

import com.gtis.fileCenter.file.FileStore;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

/**
 * 自动保存fileStore空间使用信息
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-21
 */
public class FileStorePropSaveJob extends QuartzJobBean {

    private static final Logger logger = LoggerFactory.getLogger(FileStorePropSaveJob.class);

    FileStore fileStore;

    public void setFileStore(FileStore fileStore) {
        this.fileStore = fileStore;
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        logger.debug("start to save fileStore properties");
        try {
            fileStore.save();
        } catch (Exception e) {
            logger.error("save fileStore error:{}", e);
        }
        logger.debug("save fileStore properties success");
    }
}
