/*
 * Author: xyang
 *
 * Project: trunk
 *
 * File: WebdavSessionListener.java
 *
 * LastModified: 2010-01-18 10:59:18
 *
 * Copyright (c) 2010 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.fs.webdav;

import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-1-18
 */
public class WebdavSessionListener implements HttpSessionListener {

    private WebdavSessionContext wsc = WebdavSessionContext.getInstance();

    public void sessionCreated(HttpSessionEvent se) {
        wsc.addSession(se.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        wsc.removeSession(se.getSession());
    }
}
