/*
 * Author: xyang
 *
 * Project: trunk
 *
 * File: WebdavSessionContext.java
 *
 * LastModified: 2010-01-18 11:00:17
 *
 * Copyright (c) 2010 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.fs.webdav;

import javax.servlet.http.HttpSession;
import java.util.HashMap;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-1-18
 */
public class WebdavSessionContext {

    private static WebdavSessionContext instance;
    private HashMap<String, HttpSession> map;

    private WebdavSessionContext() {
        map = new HashMap<String, HttpSession>();
    }

    public static WebdavSessionContext getInstance() {
        if (instance == null) {
            instance = new WebdavSessionContext();
        }
        return instance;
    }

    public synchronized void addSession(HttpSession session) {
        if (session != null)
            map.put(session.getId(), session);

    }

    public synchronized void removeSession(HttpSession session) {
        if (session != null)
            map.remove(session.getId());

    }

    public synchronized HttpSession getSession(String sessionId) {
        if (sessionId == null)
            return null;
        return map.get(sessionId);
    }
}
