/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: WriteStreamListener.java
 *
 * LastModified: 2009-09-21 03:19:54
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.file.impl;

import com.gtis.fileCenter.ex.FileIOException;
import com.gtis.fileCenter.file.FileStreamListener;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.service.FileStoreService;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-17
 */
public class WriteStreamListener implements FileStreamListener {

    private FileStoreService fileService;

    private File file;

    public WriteStreamListener(FileStoreService fileService, File file) {
        this.file = file;
        this.fileService = fileService;
    }

    /**
     * Called when the stream is closed
     *
     * @throws com.gtis.fileCenter.ex.FileIOException
     *
     */
    public void contentStreamClosed(long size) throws FileIOException {
        file.setSize(size);
        fileService.getFileStore().increaseUsed(file.getStoreUrlObject(), size);
    }
}
