/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FileStoresWrapper.java
 *
 * LastModified: 2009-09-21 10:26:45
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.file;

import com.gtis.fileCenter.ex.CapabilityNotEnoughException;
import com.gtis.fileCenter.ex.FileIOException;
import com.gtis.fileCenter.model.impl.StoreUrl;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-16
 */
public abstract class FileStoresWrapper implements FileStore {

    private Map<String, FileStore> stores;

    public FileStoresWrapper(List<FileStore> stores) {
        this.stores = new HashMap<String, FileStore>(stores.size());
        for (FileStore fs : stores)
            this.stores.put(fs.getName(), fs);
    }

    public Map<String, FileStore> getStores() {
        return stores;
    }


    public String getName() {
        return "storeWrapper";
    }

    public File getDirectory() {
        return getProperStore().getDirectory();
    }

    public long getCapability() {
        long capability = 0l;
        for (FileStore fs : stores.values())
            capability += fs.getCapability();
        return capability;
    }

    public long getUsed() {
        long used = 0l;
        for (FileStore fs : stores.values())
            used += fs.getUsed();
        return used;
    }

    public boolean isAvailable() {
        for (FileStore fs : stores.values())
            if (fs.isAvailable())
                return true;
        return false;
    }

    public void increaseUsed(StoreUrl storeUrl, long size) {
        getFileStore(storeUrl).increaseUsed(storeUrl, size);
    }

    public boolean exists(StoreUrl storeUrl) {
        return getFileStore(storeUrl).exists(storeUrl);
    }

    public File createFile(com.gtis.fileCenter.model.impl.File file) throws CapabilityNotEnoughException, FileIOException {
        FileStore fs = getProperStore();
        if (fs == null)
            throw new CapabilityNotEnoughException("all store has been full.");
        return fs.createFile(file);
    }

    public StoreUrl getStoreUrl(File file) {
        for (FileStore fs : stores.values()) {
            StoreUrl storeUrl = fs.getStoreUrl(file);
            if (storeUrl != null)
                return storeUrl;
        }
        return null;
    }

    public File getFile(StoreUrl storeUrl) {
        return getFileStore(storeUrl).getFile(storeUrl);
    }

    public boolean delete(StoreUrl storeUrl) {
        return getFileStore(storeUrl).delete(storeUrl);
    }

    public void init() throws Exception {
        for (FileStore fs : stores.values())
            fs.init();
    }

    public void save() throws Exception {
        for (FileStore fs : stores.values())
            fs.save();
    }

    public void countUsed() throws Exception {
        for (FileStore fs : stores.values())
            fs.countUsed();
    }

    private FileStore getFileStore(StoreUrl storeUrl) {
        return stores.get(storeUrl.getStoreName());
    }

    public abstract FileStore getProperStore();
}
