/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: NodePermissionInterceptor.java
 *
 * LastModified: 2009-09-23 03:07:57
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.web;

import com.gtis.fileCenter.Constants;
import com.gtis.fileCenter.ex.NoPermissionException;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.generic.security.Helper;
import com.gtis.generic.security.User;
import com.gtis.generic.util.SessionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-23
 */
public class NodePermissionInterceptor extends HandlerInterceptorAdapter {
    private static final String[] CHECK_ID_NAMES = new String[]{Constants.NODE_ID, Constants.SRC_NODE_ID, Constants.DEST_NODE_ID, Constants.PARENT_NODE_ID};
    @Autowired
    private NodeService nodeService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object object) throws Exception {
        String token = request.getParameter(Constants.TOKEN);
        User user = Helper.getCurrentUser();
        ArrayList<Integer> nodeIds = new ArrayList<Integer>();
        for (String idName : CHECK_ID_NAMES) {
            String[] ids = request.getParameterValues(idName);
            if (ids != null && ids.length > 0)
                for (String nodeId : ids)
                    try {
                        if (StringUtils.isNotBlank(nodeId))
                            nodeIds.add(Integer.valueOf(nodeId));
                    } catch (NumberFormatException e) {
                        throw new NodeNotFoundException(nodeId);
                    }
        }
        if (nodeIds.size() == 0)
            return true;
        if (token != null) {
            SecurityContextHolder.clearContext();//如果是访问workspace，则清除holder的用户信息
            for (Integer nodeId : nodeIds)
                if (!nodeService.hasPermission(token, nodeId))
                    throw new NoPermissionException(nodeId);
            return true;
        }
        if (user != null) {
            if (user.isAdmin())
                return true;
            Space space = SessionUtils.get(request, Constants.PERSONAL_SPACE);
            for (Integer nodeId : nodeIds) {
                if (!(nodeService.isChildNode(space.getId(), nodeId) || space.getId().equals(nodeId))) {
                    throw new NoPermissionException(nodeId);
                }
            }
            return true;
        }
        throw new NoPermissionException("no permission to access node:" + nodeIds);
    }
}
