/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: IndexController.java
 *
 * LastModified: 2009-09-25 02:52:31
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.web;

import com.gtis.fileCenter.Constants;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.PersonalSpace;
import com.gtis.generic.security.Helper;
import com.gtis.generic.util.JsonUtils;
import com.gtis.generic.util.SessionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-25
 */
@RequestMapping("/index.do")
public class IndexController extends BaseController {
    @RequestMapping(method = RequestMethod.GET)
    public ModelAndView index(HttpServletRequest request) throws Exception {
        String token = request.getParameter(Constants.TOKEN);
        Map<String, Object> params = convertParameters(request);
        if (StringUtils.isBlank(token)) {
            Space space = SessionUtils.get(request, Constants.PERSONAL_SPACE);
            if (space == null) {
                String userId = Helper.getCurrentUserId();
                try {
                    space = nodeService.getPersonalSpace(userId);
                } catch (NodeNotFoundException e) {
                    space = initPersonalSpace(userId);
                }
                SessionUtils.put(request, Constants.PERSONAL_SPACE, space);
            }
            params.put("rootId", space.getId());
        } else {
            if (!"true".equals(params.get("readOnly"))) {
                params.put("readOnly", !nodeService.isWriteable(token));
            }
        }
        params.put("jsessionid", request.getSession().getId());
        request.setAttribute("params", JsonUtils.toString(params));
        return new ModelAndView("index");
    }

    protected Map<String, Object> convertParameters(HttpServletRequest request) {
        Map<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String) names.nextElement();
            String value = request.getParameter(name);
            Object v;
            try {
                v = Long.valueOf(value);
            } catch (NumberFormatException e) {
                if ("true".equalsIgnoreCase(value)) {
                    v = Boolean.TRUE;
                } else if ("false".equalsIgnoreCase(value)) {
                    v = Boolean.FALSE;
                } else {
                    v = value;
                }
            }
            params.put(name, v);
        }
        return params;
    }

    private Space initPersonalSpace(String userId) {
        PersonalSpace space = new PersonalSpace();
        space.setOwner(userId);
        space.setName(userId);
        space.setSize(-1);
        nodeService.save(space);
        for (String name : new String[]{"我的文件", "我的音乐", "图片收藏", "下载文件"}) {
            nodeService.createNode(space.getId(), name, null, null, null, userId, null);
        }
        return space;
    }
}
