/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FileController.java
 *
 * LastModified: 2009-09-25 02:50:27
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.web;

import com.gtis.config.AppConfig;
import com.gtis.fileCenter.ComparatorNodes;
import com.gtis.fileCenter.Constants;
import com.gtis.fileCenter.NodeHelper;
import com.gtis.fileCenter.ex.*;
import com.gtis.fileCenter.model.MicroFile;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.PreviewFile;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.model.impl.NodeImpl;
import com.gtis.fileCenter.model.impl.PersonalSpace;
import com.gtis.fileCenter.service.FileStoreService;
import com.gtis.fileCenter.service.MimeTypeService;
import com.gtis.generic.security.Helper;
import com.gtis.generic.util.JsonUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-25
 */
public class FileController extends BaseController {
    protected static final Logger logger = LoggerFactory.getLogger(FileController.class);
    /** 文件中心的表空间 */
    public static final String WORK_FLOW_STUFF = "WORK_FLOW_STUFF";
    @Autowired
    private MimeTypeService mimeTypeService;
    @Autowired
    private FileStoreService fileService;
    private boolean useDocServer;


    public void setPreviewServerUrl(String previewServerUrl) {
        this.useDocServer = previewServerUrl.contains("docserver");
    }

    @RequestMapping
    public void upload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if ("post".equals(request.getMethod().toLowerCase())) {
            String client = request.getParameter("client"); //客户端类型，如果为js则返回js结果
            String path = request.getParameter("path");  //上传路径
            if ("ke".equals(client)) {
                path = request.getParameter("dir");
            }
            String callBack = request.getParameter("callBack");//js回调函数
            String desc = request.getParameter("desc");//desc
            String viewName = request.getParameter("viewName");//viewName
            String userId = request.getParameter("userId");//viewName
            boolean cover = ServletRequestUtils.getBooleanParameter(request, "cover", false); //是否强制覆盖
            boolean multi = ServletRequestUtils.getBooleanParameter(request, "multi", false); //是否允许同时上传多个文件
            boolean autoRename = ServletRequestUtils.getBooleanParameter(request, "rename", false); //自动重命名文件
            Integer nodeId = getNodeId(request);
            checkWriteable(request, nodeId);
            Map<String, Object> map = new HashMap<String, Object>();
            List<Map<String, Object>> files = new ArrayList<Map<String, Object>>();
            try {
                Node node = StringUtils.isNotBlank(path) ? nodeService.getNode(nodeId, path, true) : nodeService.getNode(nodeId);
                nodeId = node.getId();
                Space space = nodeService.getSpace(nodeId);
                MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
                /**
                 * 附件上传后的获取方式改为支持多文件上传，原来的方式，一次请求只支持一个文件
                 */
                for (Map.Entry<String, List<MultipartFile>> entry: multipartRequest.getMultiFileMap().entrySet()) {
                    List<MultipartFile> filelist = entry.getValue();
                    if (filelist != null && filelist.size() > 0){
                        for (int i = 0; i < filelist.size(); i++) {
                            MultipartFile mFile = filelist.get(i);
                            if (!mFile.isEmpty()) {
                                if (!nodeService.hasCapacity(space, mFile.getSize()))
                                    throw new SpaceExhaustException(space.getName());
                                File file = new File();
                                if (StringUtils.isNotBlank(desc)) {
                                    file.setDescription(desc);
                                }
                                if (StringUtils.isNotBlank(viewName)) {
                                    file.setViewName(viewName);
                                }
                                file.setParentId(node.getId());
                                String name = mFile.getOriginalFilename();
                                try {
                                    Node sameNameNode = nodeService.getChildNode(nodeId, name);
                                    if (cover) {
                                        if (sameNameNode instanceof File) {
                                            fileService.delete((File) sameNameNode);
                                            file.setId(sameNameNode.getId());
                                        } else {
                                            throw new NestedRuntimeException("can not cover a folder");
                                        }
                                    } else if (!autoRename) {
                                        throw new NodeExistsException(node.getId(), name);
                                    }
                                } catch (NodeNotFoundException ignored) {
                                }
                                file.setName(name);
                                file.setSize(mFile.getSize());
                                file.setOwner(userId);
                                nodeService.save(file, autoRename);
                                fileService.save(file, mFile.getInputStream());
                                nodeService.save(file);
                                logger.info("upload file [{}] success", file);
                                files.add(NodeHelper.nodeToJson(file));
                                if (!multi)
                                    break;
                            }
                        }
                    }
                }

                /*Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
                StringBuffer msgBuf = new StringBuffer("");
                msgBuf.append("\n***【附件上传跟踪】***：文件中心主节点ID："+nodeId+"；节点名称："+node.getName()+"；");
                for (Map.Entry<String, MultipartFile> entry: fileMap.entrySet()) {
                    //msg += "\r\n对应附件名称："+entry.getValue().getOriginalFilename()+"备注："+entry.getValue().getName();
                    //System.out.println(msg);
                    //logger.info(msg);
                    msgBuf.append("\r\n     对应附件名称："+entry.getValue().getOriginalFilename()+"备注："+entry.getValue().getName());
                }
                logger.info(msgBuf.toString());*/

                /*Iterator it = multipartRequest.getFileNames();
                while (it.hasNext()) {
                    MultipartFile mFile = multipartRequest.getFile((String) it.next());
                    if (!mFile.isEmpty()) {
                        if (!nodeService.hasCapacity(space, mFile.getSize()))
                            throw new SpaceExhaustException(space.getName());
                        File file = new File();
                        if (StringUtils.isNotBlank(desc)) {
                            file.setDescription(desc);
                        }
                        if (StringUtils.isNotBlank(viewName)) {
                            file.setViewName(viewName);
                        }
                        file.setParentId(node.getId());
                        String name = mFile.getOriginalFilename();
                        try {
                            Node sameNameNode = nodeService.getChildNode(nodeId, name);
                            if (cover) {
                                if (sameNameNode instanceof File) {
                                    fileService.delete((File) sameNameNode);
                                    file.setId(sameNameNode.getId());
                                } else {
                                    throw new NestedRuntimeException("can not cover a folder");
                                }
                            } else if (!autoRename) {
                                throw new NodeExistsException(node.getId(), name);
                            }
                        } catch (NodeNotFoundException ignored) {
                        }
                        file.setName(name);
                        file.setSize(mFile.getSize());
                        file.setOwner(userId);
                        nodeService.save(file, autoRename);
                        fileService.save(file, mFile.getInputStream());
                        nodeService.save(file);
                        logger.info("upload file [{}] success", file);
                        files.add(NodeHelper.nodeToJson(file));
                        if (!multi)
                            break;
                    }
                }*/
                map.put("type", 0);
            } catch (NodeNotFoundException e) {
                putError(map, 1, e.getMessage(), e);
            } catch (NodeExistsException e) {
                putError(map, 2, e.getMessage(), e);
            } catch (FileIOException e) {
                putError(map, 3, e.getMessage(), e);
            } catch (SpaceExhaustException e) {
                putError(map, 4, e.getMessage(), e);
            } catch (Exception e) {
                putError(map, 5, e.getMessage(), e);
            }
            if (multi) {
                map.put("files", files);
            } else if (files.size() == 1) {
                map.put("file", files.get(0));
            }
            if ("js".equals(client)) {
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write("<script type=\"text/javascript\">try{(opener || parent)." +
                        (StringUtils.isBlank(callBack) ? "OnUploadCompleted" : callBack) + "(" + JsonUtils.toString(map) + ");}catch(e){}</script>");
            } else if ("fck".equals(client)) {
                StringBuilder sb = new StringBuilder("<script type=\"text/javascript\">try{(opener || parent).OnUploadCompleted(");
                Integer type = (Integer) map.get("type");
                if (type.equals(0)) {
                    Map file = (Map) map.get("file");
                    String url = request.getContextPath() + "/file/get.do?fid=" + file.get("id");
                    sb.append("0,'").append(url).append("','").append(file.get("name")).append("'");
                } else {
                    sb.append("1,null,null,'").append(map.get("msg")).append("'");
                }
                sb.append(");}catch(e){}</script>");
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().print(sb);
            } else if ("ke".equals(client)) {
                Integer type = (Integer) map.get("type");
                StringBuilder sb = new StringBuilder("{\"error\":");
                sb.append(type.equals(0) ? "0" : "1");
                if (type.equals(0)) {
                    Map file = (Map) map.get("file");
                    sb.append(",\"url\":\"").append(request.getContextPath()).append("/file/get.do?fid=").append(file.get("id"));
                } else {
                    sb.append(",\"message\":\"").append(map.get("msg"));
                }
                sb.append("\"}");
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().print(sb);
            } else {
                JsonUtils.out(response, map);
            }
        }
    }
    @RequestMapping
    public void uploadByProid(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if ("post".equals(request.getMethod().toLowerCase())) {
            String client = request.getParameter("client"); //客户端类型，如果为js则返回js结果
            String path = request.getParameter("path");  //上传路径
            if ("ke".equals(client)) {
                path = request.getParameter("dir");
            }
            String callBack = request.getParameter("callBack");//js回调函数
            String desc = request.getParameter("desc");//desc
            String viewName = request.getParameter("viewName");//viewName
            String userId = request.getParameter("userId");//viewName
            boolean cover = ServletRequestUtils.getBooleanParameter(request, "cover", false); //是否强制覆盖
            boolean multi = ServletRequestUtils.getBooleanParameter(request, "multi", false); //是否允许同时上传多个文件
            boolean autoRename = ServletRequestUtils.getBooleanParameter(request, "rename", false); //自动重命名文件
            String proid = request.getParameter("proid");
            Space space = nodeService.getWorkSpace(WORK_FLOW_STUFF,true);
            Node rootNode = nodeService.getNode(space.getId(), proid, true);
            checkWriteable(request, rootNode.getId());
            Map<String, Object> map = new HashMap<String, Object>();
            List<Map<String, Object>> files = new ArrayList<Map<String, Object>>();
            try {
                Node node = StringUtils.isNotBlank(path) ? nodeService.getNode(rootNode.getId(), path, true) : nodeService.getNode(rootNode.getId());
                Integer nodeId = node.getId();
                MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
                /**
                 * 附件上传后的获取方式改为支持多文件上传，原来的方式，一次请求只支持一个文件
                 */
                for (Map.Entry<String, List<MultipartFile>> entry: multipartRequest.getMultiFileMap().entrySet()) {
                    List<MultipartFile> filelist = entry.getValue();
                    if (filelist != null && filelist.size() > 0){
                        for (int i = 0; i < filelist.size(); i++) {
                            MultipartFile mFile = filelist.get(i);
                            if (!mFile.isEmpty()) {
                                if (!nodeService.hasCapacity(space, mFile.getSize()))
                                    throw new SpaceExhaustException(space.getName());
                                File file = new File();
                                if (StringUtils.isNotBlank(desc)) {
                                    file.setDescription(desc);
                                }
                                if (StringUtils.isNotBlank(viewName)) {
                                    file.setViewName(viewName);
                                }
                                file.setParentId(node.getId());
                                String name = mFile.getOriginalFilename();
                                try {
                                    Node sameNameNode = nodeService.getChildNode(nodeId, name);
                                    if (cover) {
                                        if (sameNameNode instanceof File) {
                                            fileService.delete((File) sameNameNode);
                                            file.setId(sameNameNode.getId());
                                        } else {
                                            throw new NestedRuntimeException("can not cover a folder");
                                        }
                                    } else if (!autoRename) {
                                        throw new NodeExistsException(node.getId(), name);
                                    }
                                } catch (NodeNotFoundException ignored) {
                                }
                                file.setName(name);
                                file.setSize(mFile.getSize());
                                file.setOwner(userId);
                                nodeService.save(file, autoRename);
                                fileService.save(file, mFile.getInputStream());
                                nodeService.save(file);
                                logger.info("upload file [{}] success", file);
                                files.add(NodeHelper.nodeToJson(file));
                                if (!multi)
                                    break;
                            }
                        }
                    }
                }
                map.put("type", 0);
            } catch (NodeNotFoundException e) {
                putError(map, 1, e.getMessage(), e);
            } catch (NodeExistsException e) {
                putError(map, 2, e.getMessage(), e);
            } catch (FileIOException e) {
                putError(map, 3, e.getMessage(), e);
            } catch (SpaceExhaustException e) {
                putError(map, 4, e.getMessage(), e);
            } catch (Exception e) {
                putError(map, 5, e.getMessage(), e);
            }
            if (multi) {
                map.put("files", files);
            } else if (files.size() == 1) {
                map.put("file", files.get(0));
            }
            if ("js".equals(client)) {
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write("<script type=\"text/javascript\">try{(opener || parent)." +
                        (StringUtils.isBlank(callBack) ? "OnUploadCompleted" : callBack) + "(" + JsonUtils.toString(map) + ");}catch(e){}</script>");
            } else if ("fck".equals(client)) {
                StringBuilder sb = new StringBuilder("<script type=\"text/javascript\">try{(opener || parent).OnUploadCompleted(");
                Integer type = (Integer) map.get("type");
                if (type.equals(0)) {
                    Map file = (Map) map.get("file");
                    String url = request.getContextPath() + "/file/get.do?fid=" + file.get("id");
                    sb.append("0,'").append(url).append("','").append(file.get("name")).append("'");
                } else {
                    sb.append("1,null,null,'").append(map.get("msg")).append("'");
                }
                sb.append(");}catch(e){}</script>");
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().print(sb);
            } else if ("ke".equals(client)) {
                Integer type = (Integer) map.get("type");
                StringBuilder sb = new StringBuilder("{\"error\":");
                sb.append(type.equals(0) ? "0" : "1");
                if (type.equals(0)) {
                    Map file = (Map) map.get("file");
                    sb.append(",\"url\":\"").append(request.getContextPath()).append("/file/get.do?fid=").append(file.get("id"));
                } else {
                    sb.append(",\"message\":\"").append(map.get("msg"));
                }
                sb.append("\"}");
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().print(sb);
            } else {
                JsonUtils.out(response, map);
            }
        }
    }

    private static void putError(Map<String, Object> map, int errType, String msg, Exception e) {
        logger.error("upload error", e);
        map.put("type", errType);
        map.put("msg", msg);
    }

    @RequestMapping
    public void check(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] names = request.getParameterValues("name");
        String path = request.getParameter("path");  //上传路径
        Integer nodeId = getNodeId(request);
        Map<String, Boolean> invalidNames = new HashMap<String, Boolean>();
        for (String name : names) {
            try {
                Node node = nodeService.getNode(nodeId, (StringUtils.isNotBlank(path) ? path + "/" : "") + name);
                invalidNames.put(name, node instanceof File);
            } catch (NodeNotFoundException ignored) {
            }
        }
        JsonUtils.out(response, invalidNames);
    }

    @RequestMapping
    public void list(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer nodeId = getFileId(request);
        String path = request.getParameter("path");
        boolean all = ServletRequestUtils.getBooleanParameter(request, "all", false);

        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Map<String, Object> currentNode = null;
        try {
            if (!hasPermission(nodeId))
                throw new NoPermissionException(nodeId);
            Node node = StringUtils.isNotBlank(path) ? nodeService.getNode(nodeId, path) : nodeService.getNode(nodeId);
            nodeId = node.getId();
            currentNode = NodeHelper.nodeToJson(node);
            List<Node> nodes = all ? nodeService.getAllChildNodes(nodeId) : nodeService.getChildNodes(nodeId);
//            Fc.FcList文件列表按上传时间排序，不配置默认为按附件名称排序
            String viewFileListField= AppConfig.getProperty("viewFileList.field");
            if(StringUtils.isNotBlank(viewFileListField) && StringUtils.equals(viewFileListField,"update_time")){
                ComparatorNodes comparator=new ComparatorNodes();
                Collections.sort(nodes, comparator);
            }
            for (Node n : nodes) {
                if (n instanceof File)
                    list.add(NodeHelper.nodeToJson(n));
            }
        } catch (Exception e) {
            logger.error("list file for node [" + nodeId + "] error", e);
        }
        Map<String, Object> map = new HashMap<String, Object>(2);
        map.put("items", list);
        map.put("total", list.size());
        map.put("node", currentNode);
        JsonUtils.out(response, map);
    }

    @RequestMapping
    public ModelAndView get(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer nodeId = getFileId(request);

        if (!hasPermission(nodeId))
            throw new NoPermissionException(nodeId);

        Boolean enablePreview = ServletRequestUtils.getBooleanParameter(request, "enablePreview", Boolean.FALSE);
        Boolean isInline = ServletRequestUtils.getBooleanParameter(request, "inline", Boolean.FALSE);
        String type = request.getParameter("type");
        String page = request.getParameter("page");
        Node node = nodeService.getNode(nodeId);
        if (node.getScope() == Node.SCOPE_TOKEN) {
            String token = request.getParameter(Constants.TOKEN);
            if (nodeService.hasPermission(token, nodeId)) {
                throw new NoPermissionException(nodeId);
            }
        }
        if (node instanceof File) {
            File file = (File) node;
            if ("micro".equals(type))
                file = new MicroFile(file);
            else if ("preview".equals(type)) {
                file = new PreviewFile(file);
            }
            java.io.File diskFile = fileService.getFile(file);
            if (!diskFile.exists()) {
                if ("preview".equals(type)) {
                    PreviewFile pf=(PreviewFile) file;
                    request.setAttribute("file", pf.getFile());
                    if(!fileService.getFile(pf.getFile()).exists()){
                        return new ModelAndView("notExists");
                    }
                    try {
                        fileService.createPreviewFile(pf);
                    } catch (FileOverSizeException e) {
                        //return new ModelAndView("redirect:/images/icon/big/jpg.gif");
                        return new ModelAndView("overSize");
                    }
                    return new ModelAndView("converting");
                } else if ("micro".equals(type)) {
                    //判断是否传了自定义的缩略图定义尺寸，如果有，则按照传递的尺寸生成
                    String previewSize = request.getParameter("previewSize");
                    if (StringUtils.isNotBlank(previewSize)){
                        fileService.createMicroImage((MicroFile) file,Integer.parseInt(previewSize));
                    }else {
                        fileService.createMicroImage((MicroFile) file);
                    }
                    diskFile = fileService.getFile(file);
                    if (!diskFile.exists())
                        return new ModelAndView("redirect:/images/icon/big/jpg.gif");
                } else {
                    response.sendError(HttpServletResponse.SC_NOT_FOUND, "file [" + node.getName() + "] not found");
                    return null;
                }
            }

            long modified = diskFile.lastModified();
            long modifiedSince = request.getDateHeader("If-Modified-Since");
            if (modifiedSince > 0L) {
                // round the date to the ignore millisecond value which is not supplied by header
                long modDate = (modified / 1000L) * 1000L;
                if (modDate <= modifiedSince) {
                    response.setStatus(HttpServletResponse.SC_NOT_MODIFIED);
                    return null;
                }
            }
            response.setDateHeader("Last-Modified", modified);

            if ("text".equals(type)) {
                request.setAttribute("file", file);
                request.setAttribute("content", fileService.toString(file));
                return new ModelAndView("text");
            } else if ("preview".equals(type)) {
                request.setAttribute("file", ((PreviewFile) file).getFile());
                if (useDocServer) {
                    request.setAttribute("useDocServer", useDocServer);
                    return new ModelAndView("redirect:/doc/doc/" + nodeId + "/0.htm?_t=" + file.getUpdateTime().getTime());
                }
                String ext = ((PreviewFile) file).getFile().getExtension();
                if (!"xls".equals(ext) && !"xlsx".equals(ext)) {
                    if (!StringUtils.isBlank(page)) {
                        response.reset();
                        response.setContentType(mimeTypeService.getMimeType(page));
                        fileService.transferZipContainedFileTo(file, page, response.getOutputStream());
                        return null;
                    } else {
                        return new ModelAndView("preview");
                    }
                }
            }

            response.setContentType(mimeTypeService.getMimeType(file.getName()));
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("Content-Disposition", (type != null || isInline || (!enablePreview && file.isDocument()) ? "inline" : "attachment") +
                    "; filename=\"" + new String(file.getName().getBytes("gbk"), "iso8859-1") + "\"");
            long start = 0;
            long size = diskFile.length();
            String range = request.getHeader("Range");
            if (range != null && range.startsWith("bytes=")) {
                int minus = range.indexOf('-');
                if (minus > -1)
                    range = range.substring(6, minus);
                try {
                    start = Long.parseLong(range);
                } catch (NumberFormatException ignored) {
                }
            }
            if (start > 0) {
                response.setStatus(HttpServletResponse.SC_PARTIAL_CONTENT);
                StringBuilder sb = new StringBuilder("bytes ");
                sb.append(start).append("-").append(size - 1).append("/").append(size);
                response.setHeader("Content-Range", sb.toString());
            }
            response.setContentLength((int) (size - start));
            try {
                fileService.transferTo(file, start, response.getOutputStream());
            } catch (Exception e) {
                throw new NestedRuntimeException(e);
            }
        } else
            throw new NestedRuntimeException("not a file");
        return null;
    }

    @RequestMapping
    public void preview(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer nodeId = getFileId(request);
        Node node = nodeService.getNode(nodeId);
        File file = (File) node;
        if ("post".equals(request.getMethod().toLowerCase())) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
            Iterator it = multipartRequest.getFileNames();
            if (it.hasNext()) {
                MultipartFile mFile = multipartRequest.getFile((String) it.next());
                if (!mFile.isEmpty()) {
                    file = new PreviewFile(file);
                    fileService.save(file, mFile.getInputStream());
                }
            }
        } else {
            if (fileService.exists(file))
                fileService.transferTo(file, 0, response.getOutputStream());
            else
                response.sendError(HttpServletResponse.SC_NOT_FOUND, "file [" + node.getName() + "] not found");
        }
    }

    /**
     * 网页打印功能
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    @RequestMapping
    public ModelAndView print(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer nodeId = getFileId(request);
        Node node = nodeService.getNode(nodeId);
        File file = (File) node;
        request.setAttribute("file", file);
        return new ModelAndView("print");
    }

    /**
     * 调用文件管理器控件
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    @RequestMapping
    public ModelAndView uploadExe(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer nodeId = getFileId(request);
        Node node = nodeService.getNode(nodeId);
        request.setAttribute("node", node);
        request.setAttribute("fileCenterUrl", fileCenterUrl);
        return new ModelAndView("fileUploadExe");
    }

    private boolean hasPermission(Integer nodeId) {
        Space space = nodeService.getSpace(nodeId);
        if (space instanceof PersonalSpace) {
            String userId = Helper.getCurrentUserId();
            if (userId != null) {
                if (!nodeService.isChildNode(space.getId(), nodeId))
                    return false;
            } else
                return false;
        }
        return true;
    }

    private static Integer getNodeId(HttpServletRequest request) {
        return NodeHelper.getIntegerParameter(request, Constants.NODE_ID);
    }

    private static Integer getFileId(HttpServletRequest request) {
        return NodeHelper.getIntegerParameter(request, Constants.FILE_ID);
    }

    private void checkWriteable(HttpServletRequest request, Integer... nodeIds) {
        String token = request.getParameter(Constants.TOKEN);
        if (token != null && !nodeService.isWriteable(token)) {
            throw new NoPermissionException(Arrays.toString(nodeIds));
        }
    }
}
