package com.gtis.fileCenter.service.impl;

import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.search.Business;
import com.gtis.search.Category;
import com.gtis.search.IndexProvider;

import java.util.HashMap;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-12
 */
public class WorkFlowFileIndexOwnerDetectorImpl extends FileIndexOwnerDetector {
    private SysWorkFlowInstanceService workFlowInstanceService;
    private IndexProvider workFlowIndexProvider;
    private volatile Map<String, String> bizIdMap;

    public void setWorkFlowInstanceService(SysWorkFlowInstanceService workFlowInstanceService) {
        this.workFlowInstanceService = workFlowInstanceService;
    }

    public void setWorkFlowIndexProvider(IndexProvider workFlowIndexProvider) {
        this.workFlowIndexProvider = workFlowIndexProvider;
    }

    @Override
    protected Owner getOwner(String ownerId) {
        PfWorkFlowInstanceVo wfInstantce = workFlowInstanceService.getWorkflowInstance(ownerId);
        if (wfInstantce != null) {
            String wfBizId = getBizIdMap().get(wfInstantce.getWorkflowDefinitionId());
            if (wfBizId != null) {
                return new Owner(ownerId, wfBizId, wfInstantce.getWorkflowDefinitionId());
            }
        }
        return null;
    }

    protected Map<String, String> getBizIdMap() {
        if (bizIdMap == null) {
            synchronized (this) {
                if (bizIdMap == null) {
                    bizIdMap = new HashMap<String, String>();
                    for (Business biz : workFlowIndexProvider.getBusinesses()) {
                        for (Category cat : biz.getCategories()) {
                            bizIdMap.put(cat.getId(), biz.getId());
                        }
                    }
                }
            }
        }
        return bizIdMap;
    }
}
