package com.gtis.fileCenter.service.impl;

import com.gtis.fileCenter.NodeHelper;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.search.EntityIndexProvider;
import com.gtis.search.Index;
import com.gtis.search.MimeTypeHelper;
import org.apache.commons.lang.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-11
 */
public class FileIndexProviderImpl extends EntityIndexProvider<File> {
    private NodeService nodeService;
    private List<FileIndexOwnerDetector> detectors;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDetectors(List<FileIndexOwnerDetector> detectors) {
        this.detectors = detectors;
    }

    @Override
    protected File getEntity(String categoryId, String id) {
        return (File) nodeService.getNode(Integer.valueOf(id));
    }

    @Override
    @SuppressWarnings("unchecked")
    protected List<File> getEntities(String categoryId, int start, int size) {
        Space space = nodeService.getWorkSpace(categoryId);
        return nodeService.getAllChildFile(space.getId(), start, size);
    }

    @Override
    protected Index createIndex(File file) {
        Index index = super.createIndex(file);
        index.setId(NodeHelper.toIndexId(file.getId()));
        index.setBusinessId(defaultBusiness.getId());
        index.setCategoryId(nodeService.getSpace(file.getId()).getName());
        return index;
    }

    @Override
    protected void extractEntity(File file, Index index) {
        index.setDate(file.getUpdateTime());
        index.setTitle(StringUtils.isBlank(file.getViewName()) ? file.getName() : file.getViewName() + "." + MimeTypeHelper.getExt(file.getName()));
        index.setMimeType(MimeTypeHelper.getMimeType(file.getName()));
        index.appendBody(file.getDescription());
        index.appendBody(file.getViewName());
        index.addField("size", file.getSize());
        index.addField("fid", file.getId());
        Map<String, String> attrs = file.getAttributes();
        if (attrs != null) {
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                index.addSearchableField(entry.getKey(), entry.getValue());
            }
        }
        FileIndexOwnerDetector.Owner owner = null;
        for (FileIndexOwnerDetector detector : detectors) {
            owner = detector.detect(file);
            if (owner != null) {
                break;
            }
        }
        if (owner != null) {
            index.addSearchableField("ownerId", owner.getOwnerId());
            index.setBusinessId(owner.getBusinessId());
            index.setCategoryId(owner.getCategoryId());
        }
    }

    public int getTotalCount(String categoryId) {
        Space space = nodeService.getWorkSpace(categoryId);
        return nodeService.getAllChildFilesCount(space.getId());
    }
}
