/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: MicroFile.java
 *
 * LastModified: 2009-09-24 10:36:16
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.model;

import com.gtis.fileCenter.ex.NestedRuntimeException;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.model.impl.StoreUrl;
import org.springframework.beans.BeanUtils;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-23
 */
public class MicroFile extends File {

    private static final long serialVersionUID = -4205431081095784883L;

    public static final String MICRO_EXTENSION = ".jpg";
    public static final long MAX_SIZE = 1024 * 1024 * 5;
    public static final long TASK_SIZE = 1024 * 1024;

    private StoreUrl su;
    private File file;

    public MicroFile(File file) {
        this.file = file;
        if (!file.isImage())
            throw new NestedRuntimeException("not a image file");
        BeanUtils.copyProperties(file, this);
    }

    public File getFile() {
        return file;
    }

    @Override
    public String getName() {
        return super.getName() + MICRO_EXTENSION;
    }


    @Override
    public String getStoreUrl() {
        return super.getStoreUrl() + MICRO_EXTENSION;
    }

    @Override
    public StoreUrl getStoreUrlObject() {
        if (su == null)
            su = new StoreUrl(getStoreUrl());
        return su;
    }
}
