package com.gtis.fileCenter.fs.jlan;

import org.alfresco.jlan.app.JLANServer;
import org.alfresco.jlan.app.XMLServerConfiguration;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.io.Resource;

import java.util.ArrayList;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-10-12
 */
public class JLanServer extends JLANServer implements ApplicationListener, InitializingBean, ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(JLanServer.class);

    private ApplicationContext applicationContext;
    private Resource configLocation;
    private List<NetworkServer> servers;
    private boolean cifsEnable;
    private boolean ftpEnable;

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setCifsEnable(boolean cifsEnable) {
        this.cifsEnable = cifsEnable;
    }

    public void setFtpEnable(boolean ftpEnable) {
        this.ftpEnable = ftpEnable;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextClosedEvent && (cifsEnable || ftpEnable)) {
            stop();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (cifsEnable || ftpEnable) {
            applicationContext.getBean("nodeService");//just test nodeService
            init();
            start();
        }
    }

    protected synchronized void init() {
        ServerConfiguration srvConfig = new XMLServerConfiguration();
        try {
            srvConfig.loadConfiguration(configLocation.getFile().getAbsolutePath());
            servers = new ArrayList<NetworkServer>();
            if (cifsEnable)
                servers.add(createSMBServer(srvConfig));
            if (ftpEnable)
                servers.add(createFTPServer(srvConfig));
        } catch (Exception e) {
            logger.error("error to load JlanServer config file:[{}]", configLocation.getDescription(), e);
        }
    }

    protected synchronized void start() {
        for (NetworkServer server : servers) {
            try {
                server.startServer();
            } catch (Exception e) {
                logger.error("start server error", server.getConfiguration().getServerName(), e);
            }
        }
    }

    protected synchronized void stop() {
        for (NetworkServer server : servers) {
            try {
                server.shutdownServer(true);
            } catch (Exception e) {
                logger.error("stop server error", server.getConfiguration().getServerName(), e);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        FileCenterDiskDriver.setApplicationContext(this.applicationContext = applicationContext);
    }
}
