package com.gtis.fileCenter.file.impl;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.generic.util.SpringContextUtils;
import org.apache.commons.lang.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-7-18
 */
public class TrueNameFileStoreImpl extends FileStoreImpl {

    private static final SimpleDateFormat PATH_SDF = new SimpleDateFormat("yyyy/MM/dd");

    private volatile NodeService nodeService;

    public TrueNameFileStoreImpl(String name, String path, String capability) throws Exception {
        super(name, path, capability);
    }

    @Override
    protected String generateName(File f) {
        if (nodeService == null) {
            synchronized (this) {
                if (nodeService == null) {
                    nodeService = (NodeService) SpringContextUtils.getApplicationContext().getBean("nodeService");
                }
            }
        }
        if (nodeService == null) {
            throw new NullPointerException("nodeService can not be null");
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append(nodeService.getSpace(f.getParentId()).getName()).append("/").append(PATH_SDF.format(new Date()));
        List<Node> nodes = nodeService.getPath(f.getParentId());
        for (int i = nodes.size() - 1; i > -1; i--) {
            Node node = nodes.get(i);
            sb.append("/").append(node.getName());
            if (StringUtils.isNotEmpty(node.getViewName())) {
                sb.append(node.getViewName());
            }            
        }
        if (StringUtils.isNotEmpty(f.getViewName())) {
            sb.append(f.getViewName()).append("_");
        }
        sb.append("/").append(f.getName());
        return sb.toString();
    }
}
