/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: OrderFileStoresWrapper.java
 *
 * LastModified: 2009-09-17 05:31:56
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.file.impl;

import com.gtis.fileCenter.file.FileStore;
import com.gtis.fileCenter.file.FileStoresWrapper;

import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-16
 */
public class OrderFileStoresWrapper extends FileStoresWrapper {

    private List<FileStore> stores;

    public OrderFileStoresWrapper(List<FileStore> stores) {
        super(stores);
        this.stores = stores;
    }

    public FileStore getProperStore() {
        for (FileStore fs : stores)
            if (fs.isAvailable())
                return fs;
        return null;
    }
}
