/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: FileStoresConfigImpl.java
 *
 * LastModified: 2009-09-17 04:30:42
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.file.impl;

import com.gtis.config.AppConfig;
import com.gtis.fileCenter.file.FileStore;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.ResourceUtils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-16
 */
public class FileStoresConfigImpl implements FactoryBean {

    private static final Logger logger = LoggerFactory.getLogger(FileStoresConfigImpl.class);
    private String configLocation;
    List<FileStore> stores;

    public Object getObject() throws Exception {
        return stores;
    }

    public Class getObjectType() {
        return List.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getConfigLocation() {
        return configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public synchronized void init() throws Exception {
        File file = ResourceUtils.getFile(configLocation);
        Properties config = new Properties();
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(new FileInputStream(file), "UTF-8");
            config.load(isr);

            int count = Integer.parseInt(config.getProperty("fileStoresCount"));
            stores = new ArrayList<FileStore>(count);
            logger.info("file store count:{}", count);

            for (int i = 1; i <= count; i++) {
                String name = config.getProperty("fileStore" + i + ".name");
                String path = config.getProperty("fileStore" + i + ".directory");
                path = AppConfig.getPlaceholderValue(path);
                String capability = StringUtils.trimToEmpty(config.getProperty("fileStore" + i + ".capability"));
                boolean useTruePath = BooleanUtils.toBoolean(config.getProperty("fileStore" + i + ".useTruePath"));
                FileStore fileStore;
                if (useTruePath) {
                    fileStore = new TrueNameFileStoreImpl(name, path, capability);
                } else {
                    fileStore = new FileStoreImpl(name, path, capability);
                }
                logger.info("Use file store:[name={},path={},capability={}]", new Object[]{name, path, capability});
                stores.add(fileStore);
            }
        } finally {
            if (isr != null) {
                try {
                    isr.close();
                } catch (IOException ignored) {
                }
            }
        }

    }
}
